/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.Lengthable;
import types.MSA;
import types.Sequence;
import types.Taxable;
import writer.Writer;
import writer.WriterUtils;

public class PhylipWriter
implements Writer {
    String nl;
    boolean lowerCase;
    boolean sequential;
    boolean match;
    Logger logger;

    public PhylipWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.sequential = bl2;
        this.match = bl3;
        this.logger = Logger.getLogger(string2);
    }

    @Override
    public String write(MSA mSA) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        int n = this.getTaxa(mSA);
        int n2 = this.getLength(mSA);
        stringBuffer.append(this.writeHeader(n, n2));
        String[] stringArray = new String[mSA.getSeqs().size()];
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        int n3 = 0;
        for (int i = 0; i < mSA.getSeqs().size(); ++i) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(i);
            stringArray[i] = this.getData(sequence, (Sequence)mSA.getSeqs().firstElement());
            String string = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string);
            if (string.length() <= n3) continue;
            n3 = string.length();
        }
        if (this.sequential) {
            stringBuffer.append(this.sequential(linkedHashSet, n3, stringArray));
        } else {
            stringBuffer.append(this.interleaved(linkedHashSet, n3, stringArray));
        }
        this.logger.log(Level.INFO, "MSA successfully converted to PHYLIP format!");
        return stringBuffer.toString();
    }

    private String interleaved(LinkedHashSet<String> linkedHashSet, int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        int n2 = 0;
        for (String string : linkedHashSet) {
            stringBuffer.append(this.writeLine(string, n, stringArray, n2));
            ++n2;
        }
        stringBuffer.append(this.nl);
        while (!stringArray[0].isEmpty()) {
            n2 = 0;
            for (String string : linkedHashSet) {
                stringBuffer.append(this.writeLine(n, stringArray, n2));
                ++n2;
            }
            stringBuffer.append(this.nl);
        }
        return stringBuffer.toString();
    }

    private String sequential(LinkedHashSet<String> linkedHashSet, int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        int n2 = 0;
        for (String string : linkedHashSet) {
            stringBuffer.append(this.writeSequence(string, n, stringArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected int getTaxa(MSA mSA) {
        if (mSA instanceof Taxable) {
            return ((Taxable)((Object)mSA)).getTaxa();
        }
        return mSA.getSeqs().size();
    }

    protected int getLength(MSA mSA) {
        if (mSA instanceof Lengthable) {
            return ((Lengthable)((Object)mSA)).getLength();
        }
        return ((Sequence)mSA.getSeqs().firstElement()).getData().length();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.length() > 10) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" is longer than 10 characters. ID truncated to \"" + string.substring(0, 10) + "\"");
            string = string.substring(0, 10);
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence, Sequence sequence2) {
        String string = this.match ? WriterUtils.writeMatch(sequence, sequence2) : sequence.getData();
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string;
    }

    protected String writeHeader(int n, int n2) {
        return n + " " + n2 + this.nl;
    }

    protected String writeLine(String string, int n, String[] stringArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "  ");
        for (int i = 0; i < 5; ++i) {
            if (stringArray[n2].length() > 10) {
                stringBuffer.append(stringArray[n2].substring(0, 10) + " ");
                stringArray[n2] = stringArray[n2].substring(10);
            } else {
                stringBuffer.append(stringArray[n2]);
                stringArray[n2] = "";
            }
            if (stringArray[n2].isEmpty()) break;
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }

    protected String writeLine(int n, String[] stringArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(WriterUtils.align(0, n) + WriterUtils.align(n, 10) + "  ");
        for (int i = 0; i < 5; ++i) {
            if (stringArray[n2].length() > 10) {
                stringBuffer.append(stringArray[n2].substring(0, 10) + " ");
                stringArray[n2] = stringArray[n2].substring(10);
            } else {
                stringBuffer.append(stringArray[n2]);
                stringArray[n2] = "";
            }
            if (stringArray[n2].isEmpty()) break;
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }

    protected String writeSequence(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "  ");
        while (!string2.isEmpty()) {
            for (int i = 0; i < 5; ++i) {
                if (string2.length() > 10) {
                    stringBuffer.append(string2.substring(0, 10) + " ");
                    string2 = string2.substring(10);
                } else {
                    stringBuffer.append(string2);
                    string2 = "";
                }
                if (string2.isEmpty()) break;
            }
            stringBuffer.append(this.nl);
            if (string2.isEmpty()) continue;
            stringBuffer.append(WriterUtils.align(0, n) + WriterUtils.align(n, 10) + "  ");
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }
}

