/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import types.MSA;
import types.Sequence;
import writer.PhylipWriter;
import writer.WriterUtils;

public class PhylipRAxMLWriter
extends PhylipWriter {
    public PhylipRAxMLWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(string, bl, bl2, bl3, string2);
    }

    @Override
    public String write(MSA mSA) {
        if (mSA.getSeqs().size() < 4) {
            this.logger.log(Level.WARNING, "MSA contains less than 4 sequences. It will not be processed by RAxML.");
        }
        return super.write(mSA);
    }

    @Override
    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.contains("(") || string.contains(")") || string.contains(",") || string.contains(":") || string.contains(";") || string.contains("[") || string.contains("]")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains one of \"()[],:;\". Characters removed.");
            string = string.replaceAll("[,:;()\\[\\]]", "");
        }
        if (string.contains(" ") || string.contains("\t")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains blanks. Blanks replaced by \"_\".");
            string = string.replaceAll("[\t ]", "_");
        }
        if (string.length() > 256) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" is longer than 50 characters. ID truncated to \"" + string.substring(0, 256) + "\"");
            string = string.substring(0, 256);
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    @Override
    protected String writeSequence(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "  " + string2 + this.nl);
        return stringBuffer.toString();
    }
}

