/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import types.Sequence;
import writer.PhylipWriter;
import writer.WriterUtils;

public class PhylipPhyMLWriter
extends PhylipWriter {
    public PhylipPhyMLWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(string, bl, bl2, bl3, string2);
    }

    @Override
    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.contains("(") || string.contains(")") || string.contains(",") || string.contains(":")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains one of \"(),:\". Characters removed.");
            string = string.replaceAll("[,:()]", "");
        }
        if (string.contains(" ") || string.contains("\t")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains blanks. Blanks replaced by \"_\".");
            string = string.replaceAll("[\t ]", "_");
        }
        if (string.length() > 100) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" is longer than 100 characters. ID truncated to \"" + string.substring(0, 100) + "\"");
            string = string.substring(0, 100);
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }
}

