/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import types.Sequence;
import writer.PhylipWriter;
import writer.WriterUtils;

public class PhylipPAMLWriter
extends PhylipWriter {
    public PhylipPAMLWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(string, bl, bl2, bl3, string2);
    }

    @Override
    protected String writeHeader(int n, int n2) {
        if (this.sequential) {
            return n + " " + n2 + this.nl;
        }
        return n + " " + n2 + " I" + this.nl;
    }

    @Override
    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.contains("(") || string.contains(")") || string.contains(",") || string.contains(":") || string.contains("#") || string.contains("$") || string.contains("=")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains one of \",:#()$=\". Characters removed.");
            string = string.replaceAll("[,:=()#$]", "");
        }
        if (string.length() > 30) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" is longer than 30 characters. ID truncated to \"" + string.substring(0, 30) + "\"");
            string = string.substring(0, 30);
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }
}

