/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.DNA;
import types.Lengthable;
import types.MSA;
import types.Nucleotide;
import types.Protein;
import types.RNA;
import types.Sequence;
import types.Taxable;
import types.Type;
import types.Typeable;
import writer.Writer;
import writer.WriterUtils;

public class NexusWriter
implements Writer {
    String nl;
    boolean lowerCase;
    boolean sequential;
    boolean match;
    Logger logger;

    public NexusWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.sequential = bl2;
        this.match = bl3;
        this.logger = Logger.getLogger(string2);
    }

    @Override
    public String write(MSA mSA) {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer(10000);
        String[] stringArray = new String[mSA.getSeqs().size()];
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        int n2 = 0;
        for (n = 0; n < mSA.getSeqs().size(); ++n) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(n);
            stringArray[n] = this.getData(sequence, (Sequence)mSA.getSeqs().firstElement());
            string = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string);
            if (string.length() <= n2) continue;
            n2 = string.length();
        }
        n = this.getTaxa(mSA);
        int n3 = this.getLength(mSA);
        string = this.getType(mSA);
        stringBuffer.append(this.writeHeader(n, n3, string));
        if (this.sequential) {
            stringBuffer.append(this.sequential(linkedHashSet, n2, stringArray));
        } else {
            stringBuffer.append(this.interleaved(linkedHashSet, n2, stringArray));
        }
        stringBuffer.append(this.writeFooter());
        this.logger.log(Level.INFO, "MSA successfully converted to NEXUS format!");
        return stringBuffer.toString();
    }

    private String sequential(LinkedHashSet<String> linkedHashSet, int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        int n2 = 0;
        for (String string : linkedHashSet) {
            stringBuffer.append(this.writeSequence(string, n, stringArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String interleaved(LinkedHashSet<String> linkedHashSet, int n, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        while (!stringArray[0].isEmpty()) {
            int n2 = 0;
            for (String string : linkedHashSet) {
                stringBuffer.append(this.writeLine(string, n, stringArray, n2));
                ++n2;
            }
            stringBuffer.append(this.nl);
        }
        return stringBuffer.toString();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.contains(" ") || string.contains("\t")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains blanks. Blanks replaced by \"_\"");
            string = string.replaceAll("[\t ]", "_");
        }
        if (string.contains("[") || string.contains("]")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains \"[\" or \"]\". Characters replaced by \"_\"");
            string = string.replaceAll("\\[\\]", "_");
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence, Sequence sequence2) {
        String string = this.match ? WriterUtils.writeMatch(sequence, sequence2) : sequence.getData();
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string;
    }

    protected int getTaxa(MSA mSA) {
        if (mSA instanceof Taxable) {
            return ((Taxable)((Object)mSA)).getTaxa();
        }
        return mSA.getSeqs().size();
    }

    protected int getLength(MSA mSA) {
        if (mSA instanceof Lengthable) {
            return ((Lengthable)((Object)mSA)).getLength();
        }
        return ((Sequence)mSA.getSeqs().firstElement()).getData().length();
    }

    protected String getType(MSA mSA) {
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
            if (type instanceof Nucleotide) {
                this.logger.log(Level.INFO, "Nucleotide MSA type inferred.");
            } else {
                this.logger.log(Level.INFO, "Protein MSA type inferred.");
            }
        }
        if (type instanceof Protein) {
            return "PROTEIN";
        }
        if (type instanceof Nucleotide) {
            if (type instanceof DNA) {
                return "DNA";
            }
            if (type instanceof RNA) {
                return "RNA";
            }
            return "NUCLEOTIDE";
        }
        return "UNKNOWN";
    }

    protected String writeHeader(int n, int n2, String string) {
        String string2 = "#NEXUS" + this.nl;
        string2 = string2 + "BEGIN DATA;" + this.nl;
        string2 = string2 + "dimensions ntax=" + n + " nchar=" + n2 + ";" + this.nl;
        string2 = string2 + "format missing=?" + this.nl;
        string2 = string2 + "symbols=\"ABCDEFGHIKLMNOPQRSTUVWXYZ\"" + this.nl;
        if (!this.sequential) {
            string2 = string2 + "interleave ";
        }
        string2 = string2 + "datatype=" + string + " gap=- match=.;" + this.nl + this.nl;
        string2 = string2 + "matrix" + this.nl;
        return string2;
    }

    protected String writeFooter() {
        return ";" + this.nl + "end;" + this.nl;
    }

    protected String writeSequence(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "  ");
        stringBuffer.append(string2 + this.nl);
        return stringBuffer.toString();
    }

    protected String writeLine(String string, int n, String[] stringArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "  ");
        if (stringArray[n2].length() > 50) {
            stringBuffer.append(stringArray[n2].substring(0, 50));
            stringArray[n2] = stringArray[n2].substring(50);
        } else {
            stringBuffer.append(stringArray[n2]);
            stringArray[n2] = "";
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }
}

