/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.logging.Level;
import types.MSA;
import types.Protein;
import types.Type;
import types.Typeable;
import writer.NexusWriter;
import writer.WriterUtils;

public class NexusTCSWriter
extends NexusWriter {
    public NexusTCSWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(string, bl, bl2, bl3, string2);
    }

    @Override
    public String write(MSA mSA) {
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
        }
        if (type instanceof Protein) {
            this.logger.log(Level.WARNING, "MSA is a protein MSA. It will not be processed by TCS (only DNA is processed).");
        }
        if (WriterUtils.isIUPAC(mSA, type)) {
            this.logger.log(Level.WARNING, "MSA contains IUPAC ambiguous characters. They will be treated as missing data by TCS.");
        }
        return super.write(mSA);
    }
}

