/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import types.DNA;
import types.MSA;
import types.Nucleotide;
import types.Protein;
import types.RNA;
import types.Sequence;
import types.Type;
import types.Typeable;
import writer.NexusWriter;
import writer.WriterUtils;

public class NexusMrBayesWriter
extends NexusWriter {
    public NexusMrBayesWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        super(string, bl, bl2, bl3, string2);
    }

    @Override
    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.contains(" ") || string.contains("\t")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains blanks. Blanks replaced by \"_\"");
            string = string.replaceAll("[\t ]", "_");
        }
        if (string.contains("[") || string.contains("]")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains \"[\" or \"]\". Characters replaced by \"_\"");
            string = string.replaceAll("\\[\\]", "_");
        }
        if (string.replaceAll("[_.0-9a-zA-Z]", "").length() != 0) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains invalid characters. Characters replaced by \"_\"");
            string = string.replaceAll("[^_.0-9a-zA-Z]", "_");
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    @Override
    protected String writeHeader(int n, int n2, String string) {
        String string2 = "#NEXUS" + this.nl;
        string2 = string2 + "BEGIN DATA;" + this.nl;
        string2 = string2 + "dimensions ntax=" + n + " nchar=" + n2 + ";" + this.nl;
        string2 = string2 + "format missing=?" + this.nl;
        string2 = this.sequential ? string2 + "interleave=no " : string2 + "interleave=yes ";
        string2 = string2 + "datatype=" + string + " gap=- match=.;" + this.nl + this.nl;
        string2 = string2 + "matrix" + this.nl;
        return string2;
    }

    @Override
    protected String getType(MSA mSA) {
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
            if (type instanceof Nucleotide) {
                this.logger.log(Level.INFO, "Nucleotide MSA type inferred.");
            } else {
                this.logger.log(Level.INFO, "Protein MSA type inferred.");
            }
        }
        if (type instanceof Protein) {
            return "PROTEIN";
        }
        if (type instanceof Nucleotide) {
            if (type instanceof DNA) {
                return "DNA";
            }
            if (type instanceof RNA) {
                return "RNA";
            }
            return "DNA";
        }
        return "UNKNOWN";
    }
}

