/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.Lengthable;
import types.MSA;
import types.Nucleotide;
import types.Protein;
import types.Sequence;
import types.Type;
import types.Typeable;
import types.Weightable;
import writer.Writer;
import writer.WriterUtils;

public class MsfWriter
implements Writer {
    String nl;
    boolean lowerCase;
    Logger logger;

    public MsfWriter(String string, boolean bl, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.logger = Logger.getLogger(string2);
    }

    @Override
    public String write(MSA mSA) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(10000);
        String[] stringArray = new String[mSA.getSeqs().size()];
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        int[] nArray = new int[mSA.getSeqs().size()];
        int[] nArray2 = new int[mSA.getSeqs().size()];
        float[] fArray = new float[mSA.getSeqs().size()];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < mSA.getSeqs().size(); ++n) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(n);
            stringArray[n] = this.getData(sequence);
            String string = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string);
            nArray[n] = this.getLength(sequence);
            nArray2[n] = this.getChecksum(stringArray[n]);
            fArray[n] = this.getWeight(sequence);
            if (string.length() > n2) {
                n2 = string.length();
            }
            if (String.valueOf(nArray[n]).length() > n3) {
                n3 = String.valueOf(nArray[n]).length();
            }
            if (String.valueOf(nArray2[n]).length() > n4) {
                n4 = String.valueOf(nArray2[n]).length();
            }
            if (String.valueOf(fArray[n]).length() <= n5) continue;
            n5 = String.valueOf(fArray[n]).length();
        }
        n = this.getLength(mSA);
        int n6 = this.getChecksum(nArray2);
        char c = this.getType(mSA);
        stringBuffer.append(this.writeHeader(n, c, n6));
        int n7 = 0;
        for (String string : linkedHashSet) {
            stringBuffer.append(this.writeInfo(string, n2, nArray[n7], n3, nArray2[n7], n4, fArray[n7], n5));
            ++n7;
        }
        stringBuffer.append(this.nl + "//" + this.nl + this.nl + this.nl + this.nl);
        while (!stringArray[0].isEmpty()) {
            n7 = 0;
            for (String string : linkedHashSet) {
                stringBuffer.append(this.writeLine(string, n2, stringArray, n7));
                ++n7;
            }
            stringBuffer.append(this.nl);
        }
        this.logger.log(Level.INFO, "MSA successfully converted to MSF format!");
        return stringBuffer.toString();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.length() > 10 && (string.contains(" ") || string.contains("\t"))) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" is longer than 10 characters and contains blanks. Blanks replaced by \"_\".");
            string = string.replaceAll("[\t ]", "_");
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence) {
        if (this.lowerCase) {
            return sequence.getData().replace('-', '.').toLowerCase();
        }
        return sequence.getData().replace('-', '.');
    }

    protected int getLength(Sequence sequence) {
        if (sequence instanceof Lengthable) {
            return ((Lengthable)((Object)sequence)).getLength();
        }
        return sequence.getData().length();
    }

    protected int getLength(MSA mSA) {
        if (mSA instanceof Lengthable) {
            return ((Lengthable)((Object)mSA)).getLength();
        }
        return ((Sequence)mSA.getSeqs().firstElement()).getData().length();
    }

    protected float getWeight(Sequence sequence) {
        if (sequence instanceof Weightable) {
            return ((Weightable)((Object)sequence)).getWeight();
        }
        return 1.0f;
    }

    protected int getChecksum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
            n %= 10000;
        }
        return n;
    }

    protected int getChecksum(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            n2 += ++n * c;
            if (n != 57) continue;
            n = 0;
        }
        return n2 % 10000;
    }

    protected char getType(MSA mSA) {
        Type type = null;
        if (mSA instanceof Typeable) {
            type = ((Typeable)((Object)mSA)).getType();
        }
        if (type == null) {
            type = WriterUtils.inferType(mSA);
            if (type instanceof Nucleotide) {
                this.logger.log(Level.INFO, "Nucleotide MSA type inferred.");
            } else {
                this.logger.log(Level.INFO, "Protein MSA type inferred.");
            }
        }
        if (type instanceof Protein) {
            return 'P';
        }
        if (type instanceof Nucleotide) {
            return 'N';
        }
        return 'X';
    }

    protected String writeHeader(int n, char c, int n2) {
        String string = "";
        string = string + "PileUp" + this.nl + this.nl + this.nl + this.nl;
        string = string + "   MSF:  " + n + "  Type: " + c + "    Check:  " + n2 + "   .. " + this.nl + this.nl;
        return string;
    }

    protected String writeInfo(String string, int n, int n2, int n3, int n4, int n5, float f, int n6) {
        return " Name: " + string + " oo" + WriterUtils.align(string.length(), n) + "  Len:  " + WriterUtils.align(String.valueOf(n2).length(), n3) + n2 + "  Check:  " + WriterUtils.align(String.valueOf(n4).length(), n5) + n4 + "  Weight:  " + WriterUtils.align(String.valueOf(f).length(), n6) + f + this.nl;
    }

    protected String writeLine(String string, int n, String[] stringArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n));
        stringBuffer.append(WriterUtils.align(n, 10) + "      ");
        for (int i = 0; i < 6; ++i) {
            if (stringArray[n2].length() <= 10) {
                stringBuffer.append(stringArray[n2]);
                stringArray[n2] = "";
                break;
            }
            stringBuffer.append(stringArray[n2].substring(0, 10) + " ");
            stringArray[n2] = stringArray[n2].substring(10);
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }
}

