/*
 * Decompiled with CFR 0.152.
 */
package writer;

import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.MSA;
import types.Sequence;
import writer.Writer;
import writer.WriterUtils;

public class AlnWriter
implements Writer {
    String nl;
    boolean lowerCase;
    boolean resNumbers;
    boolean match;
    Logger logger;

    public AlnWriter(String string, boolean bl, boolean bl2, boolean bl3, String string2) {
        this.nl = string.equals("macos") ? "\r" : (string.equals("linux") ? "\n" : "\r\n");
        this.lowerCase = bl;
        this.resNumbers = bl2;
        this.match = bl3;
        this.logger = Logger.getLogger(string2);
    }

    @Override
    public String write(MSA mSA) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        String[] stringArray = new String[mSA.getSeqs().size()];
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(mSA.getSeqs().size());
        int[] nArray = new int[mSA.getSeqs().size()];
        int n = 0;
        for (int i = 0; i < mSA.getSeqs().size(); ++i) {
            Sequence sequence = (Sequence)mSA.getSeqs().elementAt(i);
            stringArray[i] = this.getData(sequence, (Sequence)mSA.getSeqs().firstElement());
            String string = this.getId(sequence, linkedHashSet);
            linkedHashSet.add(string);
            if (string.length() > n) {
                n = string.length();
            }
            nArray[i] = 0;
        }
        stringBuffer.append(this.writeHeader());
        while (!stringArray[0].isEmpty()) {
            String[] stringArray2 = new String[stringArray.length];
            int n2 = 0;
            for (String string : linkedHashSet) {
                stringBuffer.append(this.writeLine(string, n, stringArray, stringArray2, nArray, n2));
                ++n2;
            }
            stringBuffer.append(this.consensusLine(stringArray2, n));
            stringBuffer.append(this.nl);
        }
        this.logger.log(Level.INFO, "MSA successfully converted to ALN format!");
        return stringBuffer.toString();
    }

    protected String getId(Sequence sequence, LinkedHashSet<String> linkedHashSet) {
        String string = sequence.getId();
        if (string.contains(" ") || string.contains("\t")) {
            this.logger.log(Level.WARNING, "ID for sequence \"" + string + "\" contains blanks. Blanks replaced by \"_\".");
            string = string.replaceAll("[\t ]", "_");
        }
        return WriterUtils.getUniqueId(linkedHashSet, string, this.logger.getName());
    }

    protected String getData(Sequence sequence, Sequence sequence2) {
        String string = this.match ? WriterUtils.writeMatch(sequence, sequence2) : sequence.getData();
        if (this.lowerCase) {
            return string.toLowerCase();
        }
        return string;
    }

    protected String writeHeader() {
        return "CLUSTAL W (1.8) multiple sequence alignment (ALTER 1.3)" + this.nl + this.nl + this.nl;
    }

    protected String writeLine(String string, int n, String[] stringArray, String[] stringArray2, int[] nArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(string + WriterUtils.align(string.length(), n) + WriterUtils.align(n, 10) + "      ");
        if (stringArray[n2].length() > 60) {
            int n3;
            stringArray2[n2] = stringArray[n2].substring(0, 60);
            stringBuffer.append(stringArray2[n2]);
            if (this.resNumbers && (n3 = this.countResidues(stringArray2[n2])) != 0) {
                int n4 = n2;
                nArray[n4] = nArray[n4] + n3;
                stringBuffer.append(" " + nArray[n2]);
            }
            stringArray[n2] = stringArray[n2].substring(60);
        } else {
            int n5;
            stringArray2[n2] = stringArray[n2];
            stringBuffer.append(stringArray2[n2]);
            if (this.resNumbers && (n5 = this.countResidues(stringArray2[n2])) != 0) {
                int n6 = n2;
                nArray[n6] = nArray[n6] + n5;
                stringBuffer.append(" " + nArray[n2]);
            }
            stringArray[n2] = "";
        }
        stringBuffer.append(this.nl);
        return stringBuffer.toString();
    }

    protected int countResidues(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '-' || string.charAt(i) == '?') continue;
            ++n;
        }
        return n;
    }

    protected String consensusLine(String[] stringArray, int n) {
        String string = "";
        string = string + WriterUtils.align(0, n) + WriterUtils.align(n, 10) + "      ";
        for (int i = 0; i < stringArray[0].length(); ++i) {
            boolean bl = true;
            boolean bl2 = false;
            char c = stringArray[0].charAt(i);
            String string2 = "";
            for (int j = 0; j < stringArray.length; ++j) {
                char c2 = stringArray[j].charAt(i);
                if (c2 == '.') {
                    c2 = c;
                }
                if (c2 == '-' || c2 == '?') {
                    bl2 = true;
                    break;
                }
                if (c2 != c) {
                    bl = false;
                }
                string2 = string2 + c2;
            }
            string = bl2 ? string + ' ' : (bl ? string + '*' : (string2.replaceAll("[STA]", "").isEmpty() ? string + ':' : (string2.replaceAll("[NEQK]", "").isEmpty() ? string + ':' : (string2.replaceAll("[NHQK]", "").isEmpty() ? string + ':' : (string2.replaceAll("[NDEQ]", "").isEmpty() ? string + ':' : (string2.replaceAll("[QHRK]", "").isEmpty() ? string + ':' : (string2.replaceAll("[MILV]", "").isEmpty() ? string + ':' : (string2.replaceAll("[MILF]", "").isEmpty() ? string + ':' : (string2.replaceAll("[HY]", "").isEmpty() ? string + ':' : (string2.replaceAll("[FYW]", "").isEmpty() ? string + ':' : (string2.replaceAll("[CSA]", "").isEmpty() ? string + '.' : (string2.replaceAll("[ATV]", "").isEmpty() ? string + '.' : (string2.replaceAll("[SAG]", "").isEmpty() ? string + '.' : (string2.replaceAll("[STNK]", "").isEmpty() ? string + '.' : (string2.replaceAll("[STPA]", "").isEmpty() ? string + '.' : (string2.replaceAll("[SGND]", "").isEmpty() ? string + '.' : (string2.replaceAll("[SNDEQK]", "").isEmpty() ? string + '.' : (string2.replaceAll("[NDEQHK]", "").isEmpty() ? string + '.' : (string2.replaceAll("[NEQHRK]", "").isEmpty() ? string + '.' : (string2.replaceAll("[FVLIM]", "").isEmpty() ? string + '.' : (string2.replaceAll("[HFY]", "").isEmpty() ? string + '.' : string + ' ')))))))))))))))))))));
        }
        string = string + this.nl;
        return string;
    }
}

