/*
 * Decompiled with CFR 0.152.
 */
package types;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.Lengthable;
import types.MSA;
import types.PhylipSequence;
import types.Sequence;
import types.Taxable;

public class Phylip
extends MSA
implements Lengthable,
Taxable {
    private int taxa;
    private int length;

    public Phylip(int n, int n2, Vector<PhylipSequence> vector) {
        super(vector);
        this.taxa = n;
        this.length = n2;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getTaxa() {
        return this.taxa;
    }

    @Override
    public MSA collapse(boolean bl, boolean bl2, int n, String string) {
        Logger logger = Logger.getLogger(string);
        Vector<PhylipSequence> vector = new Vector<PhylipSequence>();
        vector.add((PhylipSequence)this.seqs.firstElement());
        for (int i = 1; i < this.seqs.size(); ++i) {
            PhylipSequence phylipSequence = (PhylipSequence)this.seqs.elementAt(i);
            Sequence sequence = this.isUnique(phylipSequence, vector, bl, bl2, n);
            if (sequence != null) {
                logger.log(Level.INFO, "Sequence \"" + phylipSequence.getId() + "\" is equal" + " to sequence \"" + sequence.getId() + "\". Sequence removed.");
                continue;
            }
            vector.add(phylipSequence);
        }
        return new Phylip(vector.size(), this.length, vector);
    }
}

