/*
 * Decompiled with CFR 0.152.
 */
package types;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import types.Checksumable;
import types.Lengthable;
import types.MSA;
import types.MsfSequence;
import types.Nucleotide;
import types.Protein;
import types.Sequence;
import types.Type;
import types.Typeable;

public class Msf
extends MSA
implements Lengthable,
Typeable,
Checksumable {
    private int length;
    private Type type;
    private int check;

    public Msf(Vector<MsfSequence> vector, int n, String string, int n2) {
        super(vector);
        this.length = n;
        this.check = n2;
        this.type = string.equals("N") ? new Nucleotide() : (string.equals("P") || string.equals("A") ? new Protein() : null);
    }

    public Msf(Vector<MsfSequence> vector, int n, Type type, int n2) {
        super(vector);
        this.length = n;
        this.check = n2;
        this.type = type;
    }

    @Override
    public int getChecksum() {
        return this.check;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public MSA collapse(boolean bl, boolean bl2, int n, String string) {
        Logger logger = Logger.getLogger(string);
        Vector<MsfSequence> vector = new Vector<MsfSequence>();
        vector.add((MsfSequence)this.seqs.firstElement());
        for (int i = 1; i < this.seqs.size(); ++i) {
            MsfSequence msfSequence = (MsfSequence)this.seqs.elementAt(i);
            Sequence sequence = this.isUnique(msfSequence, vector, bl, bl2, n);
            if (sequence != null) {
                logger.log(Level.INFO, "Sequence \"" + msfSequence.getId() + "\" is equal" + " to sequence \"" + sequence.getId() + "\". Sequence removed.");
                continue;
            }
            vector.add(msfSequence);
        }
        return new Msf(vector, this.length, this.type, this.check);
    }
}

