/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.ParseException;
import parser.PirParser;
import reader.Reader;
import reader.ReaderUtils;
import types.MSA;
import types.Pir;
import types.PirSequence;

public class PirReader
implements Reader {
    Logger logger;

    public PirReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Pir pir = PirParser.parseMSA(string);
        PirSequence pirSequence = (PirSequence)pir.getSeqs().elementAt(0);
        for (int i = 0; i < pir.getSeqs().size(); ++i) {
            PirSequence pirSequence2 = (PirSequence)pir.getSeqs().elementAt(i);
            if (pirSequence2.getData().length() != pirSequence.getData().length()) {
                throw new ParseException("Sequence lengths are not equal.");
            }
            if (pirSequence2.getType().getClass() != pirSequence.getType().getClass()) {
                throw new ParseException("Sequence types are not equal.");
            }
            ReaderUtils.replaceMatch(pirSequence2, pirSequence);
        }
        this.logger.log(Level.INFO, "MSA read in PIR format (Taxa = " + pir.getSeqs().size() + ", " + "Length =  " + ((PirSequence)pir.getSeqs().elementAt(0)).getData().length() + ").");
        return pir;
    }
}

