/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.MsfParser;
import parser.ParseException;
import reader.Reader;
import types.MSA;
import types.Msf;
import types.MsfSequence;
import types.Sequence;

public class MsfReader
implements Reader {
    Logger logger;

    public MsfReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Msf msf = MsfParser.parseMSA(string);
        for (int i = 0; i < msf.getSeqs().size(); ++i) {
            Sequence sequence = (Sequence)msf.getSeqs().elementAt(i);
            if (sequence.getData().length() == msf.getLength() && sequence.getData().length() == ((MsfSequence)sequence).getLength()) continue;
            throw new ParseException("Sequence lengths are not equal to the given length.");
        }
        this.logger.log(Level.INFO, "MSA read in MSF format (Taxa = " + msf.getSeqs().size() + ", " + "Length =  " + ((Sequence)msf.getSeqs().elementAt(0)).getData().length() + ").");
        return msf;
    }
}

