/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.GdeParser;
import parser.ParseException;
import reader.Reader;
import reader.ReaderUtils;
import types.Gde;
import types.MSA;
import types.Sequence;

public class GdeReader
implements Reader {
    Logger logger;

    public GdeReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Gde gde = GdeParser.parseMSA(string);
        Sequence sequence = (Sequence)gde.getSeqs().elementAt(0);
        for (int i = 0; i < gde.getSeqs().size(); ++i) {
            Sequence sequence2 = (Sequence)gde.getSeqs().elementAt(i);
            if (sequence2.getData().length() != sequence.getData().length()) {
                throw new ParseException("Sequence lengths are not equal.");
            }
            ReaderUtils.replaceMatch(sequence2, sequence);
        }
        this.logger.log(Level.INFO, "MSA read in GDE format (Taxa = " + gde.getSeqs().size() + ", " + "Length =  " + ((Sequence)gde.getSeqs().elementAt(0)).getData().length() + ").");
        return gde;
    }
}

