/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.FastaParser;
import parser.ParseException;
import reader.Reader;
import reader.ReaderUtils;
import types.Fasta;
import types.MSA;
import types.Sequence;

public class FastaReader
implements Reader {
    Logger logger;

    public FastaReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Fasta fasta = FastaParser.parseMSA(string);
        Sequence sequence = (Sequence)fasta.getSeqs().elementAt(0);
        for (int i = 0; i < fasta.getSeqs().size(); ++i) {
            Sequence sequence2 = (Sequence)fasta.getSeqs().elementAt(i);
            if (sequence2.getData().length() != sequence.getData().length()) {
                throw new ParseException("Sequence lengths are not equal.");
            }
            ReaderUtils.replaceMatch(sequence2, sequence);
        }
        this.logger.log(Level.INFO, "MSA read in FASTA format (Taxa = " + fasta.getSeqs().size() + ", " + "Length =  " + ((Sequence)fasta.getSeqs().elementAt(0)).getData().length() + ").");
        return fasta;
    }
}

