/*
 * Decompiled with CFR 0.152.
 */
package reader;

import java.util.logging.Level;
import java.util.logging.Logger;
import parser.AutodetectionParser;
import parser.ParseException;
import reader.AlnReader;
import reader.FastaReader;
import reader.GdeReader;
import reader.MsfReader;
import reader.NexusReader;
import reader.PhylipReader;
import reader.PirReader;
import reader.Reader;
import types.MSA;

public class AutodetectionReader
implements Reader {
    Logger logger;

    public AutodetectionReader(String string) {
        this.logger = Logger.getLogger(string);
    }

    @Override
    public MSA read(String string) throws ParseException {
        Reader reader;
        String string2 = AutodetectionParser.detectFormat(string);
        this.logger.log(Level.INFO, string2.toUpperCase() + " format detected.");
        if (string2.equals("aln")) {
            reader = new AlnReader(this.logger.getName());
        } else if (string2.equals("fasta")) {
            reader = new FastaReader(this.logger.getName());
        } else if (string2.equals("gde")) {
            reader = new GdeReader(this.logger.getName());
        } else if (string2.equals("msf")) {
            reader = new MsfReader(this.logger.getName());
        } else if (string2.equals("nexus")) {
            reader = new NexusReader(this.logger.getName());
        } else if (string2.equals("phylip")) {
            reader = new PhylipReader(this.logger.getName());
        } else if (string2.equals("pir")) {
            reader = new PirReader(this.logger.getName());
        } else {
            throw new UnsupportedOperationException("Input format not supported.");
        }
        return reader.read(string);
    }
}

