/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler<T> {
    private final Class<T> enumType;

    public EnumOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super T> setter, Class<T> clazz) {
        super(cmdLineParser, optionDef, setter);
        this.enumType = clazz;
    }

    @Override
    public int parseArguments(Parameters parameters) throws CmdLineException {
        String string = parameters.getParameter(0);
        Enum enum_ = null;
        for (Enum enum_2 : (Enum[])this.enumType.getEnumConstants()) {
            if (!enum_2.name().equalsIgnoreCase(string)) continue;
            enum_ = enum_2;
            break;
        }
        if (enum_ == null) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.option.toString(), string));
        }
        this.setter.addValue(enum_);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (Enum enum_ : (Enum[])this.enumType.getEnumConstants()) {
            stringBuffer.append(enum_).append(" | ");
        }
        stringBuffer.delete(stringBuffer.length() - 3, stringBuffer.length());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

