/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j.spi;

import java.util.Arrays;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.Messages;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class BooleanOptionHandler
extends OptionHandler<Boolean> {
    private static final List<String> ACCEPTABLE_VALUES = Arrays.asList("true", "on", "yes", "1", "false", "off", "no", "0");

    public BooleanOptionHandler(CmdLineParser cmdLineParser, OptionDef optionDef, Setter<? super Boolean> setter) {
        super(cmdLineParser, optionDef, setter);
    }

    @Override
    public int parseArguments(Parameters parameters) throws CmdLineException {
        if (this.option.isArgument()) {
            String string = parameters.getParameter(0).toLowerCase();
            int n = ACCEPTABLE_VALUES.indexOf(string);
            if (n == -1) {
                throw new CmdLineException(Messages.ILLEGAL_BOOLEAN.format(string));
            }
            this.setter.addValue(n < ACCEPTABLE_VALUES.size() / 2);
            return 1;
        }
        this.setter.addValue(true);
        return 0;
    }

    @Override
    public String getDefaultMetaVariable() {
        return null;
    }
}

