/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.spi.Setter;

final class MultiValueFieldSetter
implements Setter {
    private final Object bean;
    private final Field f;

    public MultiValueFieldSetter(Object object, Field field) {
        this.bean = object;
        this.f = field;
        if (!List.class.isAssignableFrom(field.getType())) {
            throw new IllegalAnnotationError(Messages.ILLEGAL_FIELD_SIGNATURE.format(field.getType()));
        }
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    public Class getType() {
        ParameterizedType parameterizedType;
        Type type = this.f.getGenericType();
        if (type instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    public void addValue(Object object) {
        try {
            this.doAddValue(this.bean, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.f.setAccessible(true);
            try {
                this.doAddValue(this.bean, object);
            }
            catch (IllegalAccessException illegalAccessException2) {
                throw new IllegalAccessError(illegalAccessException2.getMessage());
            }
        }
    }

    private void doAddValue(Object object, Object object2) throws IllegalAccessException {
        ArrayList arrayList = this.f.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.f.set(object, arrayList);
        }
        if (!(arrayList instanceof List)) {
            throw new IllegalAnnotationError("type of " + this.f + " is not a List");
        }
        ((List)arrayList).add(object2);
    }
}

