/*
 * Decompiled with CFR 0.152.
 */
package converter;

import java.util.LinkedList;
import java.util.List;

public class ProgramOptions {
    public static List<String> getSO() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("windows");
        linkedList.add("linux");
        linkedList.add("macos");
        return linkedList;
    }

    public static List<String> getInputPrograms() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("clustal");
        linkedList.add("mafft");
        linkedList.add("tcoffee");
        linkedList.add("muscle");
        linkedList.add("probcons");
        return linkedList;
    }

    public static List<String> getInputFormats() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("aln");
        linkedList.add("fasta");
        linkedList.add("gde");
        linkedList.add("msf");
        linkedList.add("nexus");
        linkedList.add("phylip");
        linkedList.add("pir");
        return linkedList;
    }

    public static List<String> getOutputPrograms() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("general");
        linkedList.add("jmodeltest");
        linkedList.add("mrbayes");
        linkedList.add("paml");
        linkedList.add("paup");
        linkedList.add("phyml");
        linkedList.add("prottest");
        linkedList.add("raxml");
        linkedList.add("tcs");
        linkedList.add("bioedit");
        linkedList.add("se-al");
        linkedList.add("mega");
        linkedList.add("mesquite");
        linkedList.add("splitstree");
        linkedList.add("dnasp");
        linkedList.add("clustal");
        linkedList.add("mafft");
        linkedList.add("muscle");
        linkedList.add("probcons");
        linkedList.add("tcoffee");
        linkedList.add("gblocks");
        linkedList.add("seaview");
        linkedList.add("trimal");
        return linkedList;
    }

    public static List<String> getOutputFormats() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("aln");
        linkedList.add("fasta");
        linkedList.add("gde");
        linkedList.add("mega");
        linkedList.add("msf");
        linkedList.add("nexus");
        linkedList.add("phylip");
        linkedList.add("pir");
        return linkedList;
    }

    public static List<String> getOutOptions() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("sequential");
        linkedList.add("interleaved");
        linkedList.add("lowercase");
        linkedList.add("match");
        linkedList.add("residue");
        return linkedList;
    }

    public static List<String> getInputProgramFormats(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string.equalsIgnoreCase("clustal")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("gde");
            linkedList.add("msf");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("mafft")) {
            linkedList.add("aln");
            linkedList.add("fasta");
        } else if (string.equalsIgnoreCase("tcoffee")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("msf");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("muscle")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("msf");
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("probcons")) {
            linkedList.add("aln");
            linkedList.add("fasta");
        } else {
            throw new IllegalArgumentException("Input program not found: " + string);
        }
        return linkedList;
    }

    public static List<String> getOutputProgramFormats(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (string.equalsIgnoreCase("jmodeltest")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("msf");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("mrbayes")) {
            linkedList.add("nexus");
        } else if (string.equalsIgnoreCase("paml")) {
            linkedList.add("nexus");
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("paup")) {
            linkedList.add("mega");
            linkedList.add("msf");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("phyml")) {
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("prottest")) {
            linkedList.add("nexus");
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("raxml")) {
            linkedList.add("phyplip");
        } else if (string.equalsIgnoreCase("tcs")) {
            linkedList.add("nexus");
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("bioedit")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("msf");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("se-al")) {
            linkedList.add("fasta");
            linkedList.add("gde");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("mega")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("mega");
            linkedList.add("msf");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("mesquite")) {
            linkedList.add("nexus");
        } else if (string.equalsIgnoreCase("splitstree")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("nexus");
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("dnasp")) {
            linkedList.add("fasta");
            linkedList.add("mega");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("clustal")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("gde");
            linkedList.add("msf");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("mafft")) {
            linkedList.add("fasta");
        } else if (string.equalsIgnoreCase("muscle")) {
            linkedList.add("fasta");
        } else if (string.equalsIgnoreCase("probcons")) {
            linkedList.add("fasta");
        } else if (string.equalsIgnoreCase("tcoffee")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("msf");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("gblocks")) {
            linkedList.add("fasta");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("seaview")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("msf");
            linkedList.add("nexus");
            linkedList.add("phylip");
        } else if (string.equalsIgnoreCase("trimal")) {
            linkedList.add("aln");
            linkedList.add("fasta");
            linkedList.add("mega");
            linkedList.add("nexus");
            linkedList.add("phylip");
            linkedList.add("pir");
        } else if (string.equalsIgnoreCase("general")) {
            linkedList.addAll(ProgramOptions.getOutputFormats());
        } else {
            throw new IllegalArgumentException("Output program not found: " + string);
        }
        return linkedList;
    }

    public static List<String> getOutputProgramOptions(String string, String string2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (!ProgramOptions.getOutputPrograms().contains(string)) {
            throw new IllegalArgumentException("Output program not found: " + string);
        }
        if (!ProgramOptions.getOutputFormats().contains(string2)) {
            throw new IllegalArgumentException("Output format not found: " + string2);
        }
        if (!ProgramOptions.getOutputProgramFormats(string).contains(string2)) {
            throw new IllegalArgumentException("Output Program " + string + " does not work with " + string2 + " format");
        }
        linkedList.add("lowercase");
        linkedList.add("match");
        if (string.equalsIgnoreCase("mrbayes")) {
            linkedList.remove("match");
        } else if (string.equalsIgnoreCase("splitstree")) {
            linkedList.remove("match");
        } else if (string.equalsIgnoreCase("dnasp") && string2.equalsIgnoreCase("nexus")) {
            linkedList.remove("match");
        } else if (string.equalsIgnoreCase("clustal")) {
            linkedList.remove("match");
        } else if (string.equalsIgnoreCase("mafft")) {
            linkedList.remove("match");
        } else if (string.equalsIgnoreCase("tcoffee")) {
            linkedList.remove("match");
        } else if (string.equalsIgnoreCase("gblocks")) {
            linkedList.remove("match");
        }
        if (string2.equalsIgnoreCase("aln")) {
            linkedList.add("residue");
        }
        if (string2.equalsIgnoreCase("nexus")) {
            linkedList.add("sequential");
            if (string.equalsIgnoreCase("phyml")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("raxml")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("mega")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("clustal")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("mafft")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("tcoffee")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("trimal")) {
                linkedList.remove("sequential");
            }
            linkedList.add("interleaved");
            if (string.equalsIgnoreCase("paml")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("phyml")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("prottest")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("raxml")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("tcs")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("clustal")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("mafft")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("tcoffee")) {
                linkedList.remove("interleaved");
            }
        }
        if (string2.equalsIgnoreCase("phylip")) {
            linkedList.add("sequential");
            if (string.equalsIgnoreCase("mrbayes")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("mesquite")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("clustal")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("mafft")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("tcoffee")) {
                linkedList.remove("sequential");
            } else if (string.equalsIgnoreCase("seaview")) {
                linkedList.remove("sequential");
            }
            linkedList.add("interleaved");
            if (string.equalsIgnoreCase("mrbayes")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("tcs")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("mesquite")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("clustal")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("mafft")) {
                linkedList.remove("interleaved");
            } else if (string.equalsIgnoreCase("tcoffee")) {
                linkedList.remove("interleaved");
            }
        }
        return linkedList;
    }
}

