/*
 * Decompiled with CFR 0.152.
 */
package cmdLine;

import cmdLine.CmdLineLogHandler;
import cmdLine.CmdLineOptions;
import converter.DefaultFactory;
import gui.MainFrame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import parser.ParseException;

public class Convert {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            MainFrame.main(stringArray);
        } else {
            Object object;
            Object object2;
            Logger logger = Logger.getLogger("alter" + System.currentTimeMillis());
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            logger.addHandler(new CmdLineLogHandler());
            CmdLineOptions cmdLineOptions = new CmdLineOptions();
            CmdLineParser cmdLineParser = new CmdLineParser(cmdLineOptions);
            try {
                cmdLineParser.parseArgument(stringArray);
            }
            catch (CmdLineException cmdLineException) {
                System.err.println(cmdLineException.getMessage());
                cmdLineParser.printUsage(System.err);
                return;
            }
            if (!(cmdLineOptions.autodetect || cmdLineOptions.inOS != null && cmdLineOptions.inProgram != null && cmdLineOptions.inFormat != null)) {
                System.err.println("Autodetection not enabled. Input options required.");
                cmdLineParser.printUsage(System.err);
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            try {
                object2 = new BufferedReader(new FileReader(cmdLineOptions.in));
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    stringBuffer.append((String)object + "\r\n");
                }
                ((BufferedReader)object2).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.log(Level.SEVERE, "Input file " + cmdLineOptions.in + " not found.");
                return;
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Failure reading input file " + cmdLineOptions.in + ":\r\n" + iOException.getMessage());
                return;
            }
            object2 = new DefaultFactory();
            String string = "";
            try {
                object = object2.getConverter(cmdLineOptions.inOS, cmdLineOptions.inProgram, cmdLineOptions.inFormat, cmdLineOptions.autodetect, cmdLineOptions.collapse, cmdLineOptions.gaps, cmdLineOptions.missing, cmdLineOptions.limit, cmdLineOptions.outOS, cmdLineOptions.outProgram, cmdLineOptions.outFormat, cmdLineOptions.lowerCase, cmdLineOptions.residueNumbers, cmdLineOptions.sequential, cmdLineOptions.match, logger.getName());
                string = object.convert(stringBuffer.toString());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                logger.log(Level.SEVERE, unsupportedOperationException.getMessage());
                return;
            }
            catch (ParseException parseException) {
                logger.log(Level.SEVERE, "Failure parsing source file:\r\n" + parseException.getMessage());
                return;
            }
            try {
                FileWriter fileWriter = new FileWriter(cmdLineOptions.out);
                fileWriter.write(string);
                fileWriter.close();
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Failure writing output file:\r\n" + iOException.getMessage());
                System.err.println(iOException.getMessage());
            }
        }
    }
}

