/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.utilities;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.prottest.util.exception.AlignmentParseException;
import es.uvigo.darwin.prottest.util.fileio.AlignmentReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import pal.alignment.Alignment;

public final class Utilities {
    public static final int NA = Integer.MIN_VALUE;
    public static final int OS_LINUX = 1;
    public static final int OS_OSX = 2;
    public static final int OS_WINDOWS = 3;

    public static String firstNumericToken(String string) {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        for (bl = false; stringTokenizer.hasMoreTokens() && !bl; bl |= Utilities.isNumber(string2)) {
            string2 = stringTokenizer.nextToken();
        }
        if (bl) {
            return string2;
        }
        return null;
    }

    public static String lastToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Window");
    }

    public static int findCurrentOS() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac")) {
            return 2;
        }
        if (string.startsWith("Windows")) {
            return 3;
        }
        return 1;
    }

    public static String getBinaryVersion() {
        String string = System.getProperty("os.arch");
        String string2 = System.getProperty("sun.arch.data.model");
        String string3 = null;
        switch (Utilities.findCurrentOS()) {
            case 2: {
                if (string.startsWith("ppc")) {
                    System.err.println("Sorry, PowerPC architecture is no longer supported");
                    System.exit(0);
                    break;
                }
                string3 = "PhyML_3.0_macOS_i386";
                break;
            }
            case 1: {
                if (string2.startsWith("64")) {
                    string3 = "PhyML_3.0_linux64";
                    break;
                }
                string3 = "PhyML_3.0_linux32";
                break;
            }
            case 3: {
                string3 = "PhyML_3.0_win32.exe";
                break;
            }
            default: {
                string3 = null;
            }
        }
        return string3;
    }

    public static String calculateRuntimeMinutes(long l, long l2) {
        long l3 = Math.round((double)(l2 - l) / 1000.0);
        int n = (int)((double)l3 / 3600.0);
        int n2 = (int)((double)l3 % 3600.0);
        int n3 = (int)((double)n2 / 60.0);
        l3 = (int)(l3 - (long)(n * 3600 + n3 * 60));
        String string = "" + n;
        String string2 = "" + n3;
        String string3 = "" + l3;
        if (n3 < 10) {
            string2 = "0" + string2;
        }
        if (l3 < 10L) {
            string3 = "0" + string3;
        }
        return string + "h:" + string2 + ":" + string3 + "";
    }

    public static String displayRuntime(long l) {
        long l2 = Math.round((double)l / 100.0);
        int n = (int)((double)l2 / 36000.0);
        int n2 = (int)((double)l2 % 36000.0);
        int n3 = (int)((double)n2 / 600.0);
        int n4 = (int)((double)n2 % 600.0);
        int n5 = (int)((double)n4 / 10.0);
        l2 = (int)(l2 - (long)(n * 36000 + n3 * 600 + n5 * 10));
        String string = "" + n;
        String string2 = "" + n3;
        String string3 = "" + n5;
        String string4 = "0" + l2;
        if (n < 10) {
            string = "0" + string;
        }
        if (n3 < 10) {
            string2 = "0" + string2;
        }
        if (n5 < 10) {
            string3 = "0" + string3;
        }
        return string + "h:" + string2 + ":" + string3 + ":" + string4 + "";
    }

    public static String calculateRuntime(long l, long l2) {
        return Utilities.displayRuntime(l2 - l);
    }

    public static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static void toConsoleEnd() {
        if (ModelTest.buildGUI) {
            XManager.getInstance().getPane().setCaretPosition(XManager.getInstance().getPane().getDocument().getLength());
        }
    }

    public static void copyFile(String string, String string2) throws IOException {
        int n;
        File file = new File(string);
        File file2 = new File(string2);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public static String checkNA(double d) {
        if (d == -2.147483648E9) {
            return "  -  ";
        }
        String string = String.format(Locale.ENGLISH, "%8.4f", d);
        return string;
    }

    public static void deleteFile(String string) {
        File file;
        try {
            file = new File(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("DeleteFiles: deletion of " + string + " failed");
        }
        if (file.exists()) {
            String[] stringArray;
            if (!file.canWrite()) {
                throw new IllegalArgumentException("DeleteFiles: write protected: " + string);
            }
            if (file.isDirectory() && (stringArray = file.list()).length > 0) {
                throw new IllegalArgumentException("DeleteFiles: directory not empty: " + string);
            }
            boolean bl = file.delete();
            if (!bl) {
                throw new IllegalArgumentException("DeleteFiles: deletion of " + string + " failed");
            }
        }
    }

    public static void printRed(String string) {
        if (ModelTest.buildGUI) {
            try {
                Document document = XManager.getInstance().getPane().getDocument();
                document.insertString(document.getLength(), string, XManager.redText);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static double roundDoubleTo(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, 0);
        return bigDecimal.doubleValue();
    }

    public static String asPercent(double d) {
        if (d > 100.0) {
            d = 100.0;
        }
        return Utilities.format(d, 6, 2, false) + "%";
    }

    public static String format(double d, int n, int n2, boolean bl) {
        String string = bl ? "%" + n + "." + n2 + "e" : "%" + n + "." + n2 + "f";
        StringBuffer stringBuffer = new StringBuffer(String.format(Locale.ENGLISH, string, d));
        for (int i = stringBuffer.length(); i < n; ++i) {
            stringBuffer.insert(0, " ");
        }
        return stringBuffer.toString();
    }

    public static String putSlashBeforeSpaces(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != ' ') continue;
            stringBuffer.insert(i++, '\\');
        }
        return stringBuffer.toString();
    }

    public static String substituteSpaces(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != ' ') continue;
            stringBuffer.setCharAt(i, '0');
            stringBuffer.insert(i++, '%');
            stringBuffer.insert(i++, '2');
        }
        return stringBuffer.toString();
    }

    public static String putQuotesAroundSpaces(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        String string2 = "\"";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.contains(" ")) {
                string2 = string2 + File.separator + "\"" + string3 + "\"";
                continue;
            }
            string2 = string2 + File.separator + string3;
        }
        return string2.substring(1, string2.length());
    }

    public static String[] specialConcatStringArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length - 1];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 1, stringArray3, stringArray.length, stringArray2.length - 1);
        return stringArray3;
    }

    public static int calculateInvariableSites(Alignment alignment) {
        int n = alignment.getSiteCount();
        int n2 = alignment.getSequenceCount();
        int n3 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n4 = Utilities.indexOfChar(alignment.getData(0, i));
            bl = true;
            for (int j = 0; j < n2; ++j) {
                if (Utilities.indexOfChar(alignment.getData(j, i)) == n4) continue;
                j = n2;
                bl = false;
            }
            if (!bl) continue;
            ++n3;
        }
        return n3;
    }

    private static int indexOfChar(char c) {
        char[] cArray = new char[]{'A', 'C', 'G', 'T', 'a', 'c', 'g', 't'};
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return i % 4;
        }
        return -1;
    }

    public static double calculateShannonSampleSize(Alignment alignment, boolean bl) {
        int n;
        int n2;
        int n3 = alignment.getSiteCount();
        int n4 = alignment.getSequenceCount();
        double[][] dArray = new double[n3][4];
        byte[][] byArray = new byte[n3][4];
        double[] dArray2 = new double[n3];
        int[] nArray = new int[n3];
        double d = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n4; ++n) {
                int n5 = Utilities.indexOfChar(alignment.getData(n, n2));
                if (n5 < 0) continue;
                byte[] byArray2 = byArray[n2];
                int n6 = n5;
                byArray2[n6] = (byte)(byArray2[n6] + 1);
                int n7 = n2;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 4; ++n) {
                dArray[n2][n] = (double)byArray[n2][n] / (double)nArray[n2];
                if (!(dArray[n2][n] > 0.0)) continue;
                int n8 = n2;
                dArray2[n8] = dArray2[n8] + dArray[n2][n] * Math.log(dArray[n2][n]) / Math.log(2.0);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            d += dArray2[n2];
        }
        if (bl) {
            return -1.0 * d;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -1.0 * d / (double)n3;
        for (int i = 0; i < 4; ++i) {
            d2 += 0.25 * Math.log(0.25) / Math.log(2.0);
        }
        d3 = -1.0 * d4 / d2;
        return (double)n3 * (double)n4 * d3;
    }

    public static double calculateShannonSampleSize(File file, boolean bl) {
        Alignment alignment = null;
        try {
            alignment = AlignmentReader.readAlignment(new PrintWriter(System.err), file.getAbsolutePath(), false);
        }
        catch (AlignmentParseException alignmentParseException) {
            alignmentParseException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return Utilities.calculateShannonSampleSize(alignment, bl);
    }
}

