/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.utilities;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;

    public static void printComponent(Component component) {
        new PrintUtilities(component).print();
    }

    public PrintUtilities(Component component) {
        this.componentToBePrinted = component;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = 1;
        Graphics2D graphics2D = (Graphics2D)graphics;
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        Dimension dimension = this.componentToBePrinted.getSize();
        double d = dimension.width;
        double d2 = dimension.height;
        double d3 = pageFormat.getImageableHeight();
        double d4 = pageFormat.getImageableWidth();
        double d5 = d4 / d;
        int n3 = (int)Math.ceil(d5 * d2 / d3);
        if (n >= n3) {
            n2 = 1;
        } else {
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.translate(0.0, (double)(-n) * d3);
            graphics2D.scale(d5, d5);
            this.componentToBePrinted.paint(graphics2D);
            PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
            n2 = 0;
        }
        return n2;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

