/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.selection;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.util.ArrayList;
import java.util.List;

public abstract class InformationCriterion {
    protected ApplicationOptions options = ApplicationOptions.getInstance();
    public static final int IC_AIC = 1;
    public static final int IC_AICc = 2;
    public static final int IC_BIC = 3;
    public static final int IC_DT = 4;
    private static final String[] names = new String[]{"", "AIC", "AICc", "BIC", "DT"};
    public int[] order;
    protected int numModels;
    protected Model[] models;
    protected boolean writePAUPblock;
    protected boolean doImportances;
    protected boolean doModelAveraging;
    protected double confidenceInterval;
    protected List<Model> confidenceModels;
    protected double cumWeight;
    protected Model minModel;
    protected boolean doCheckAgainstULK;
    protected Model unconstrainedModel;
    protected double ifA;
    protected double ifG;
    protected double ifC;
    protected double ifT;
    protected double ititv;
    protected double ikappa;
    protected double ipinvI;
    protected double ishapeG;
    protected double ipinvIG;
    protected double ishapeIG;
    protected double iRa;
    protected double iRb;
    protected double iRc;
    protected double iRd;
    protected double iRe;
    protected double iRf;
    protected double afA;
    protected double afG;
    protected double afC;
    protected double afT;
    protected double atitv;
    protected double akappa;
    protected double apinvI;
    protected double ashapeG;
    protected double apinvIG;
    protected double ashapeIG;
    protected double aRa;
    protected double aRb;
    protected double aRc;
    protected double aRd;
    protected double aRe;
    protected double aRf;

    public List<Model> getConfidenceModels() {
        return this.confidenceModels;
    }

    public InformationCriterion(boolean bl, boolean bl2, boolean bl3, double d) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (Model model : ModelTest.getCandidateModels()) {
            if (!(model.getLnL() > 0.0)) continue;
            arrayList.add(model);
        }
        this.models = arrayList.toArray(new Model[0]);
        this.numModels = this.models.length;
        this.order = new int[this.numModels];
        this.writePAUPblock = bl;
        this.doImportances = bl2;
        this.doModelAveraging = bl3;
        this.confidenceInterval = d;
        this.confidenceModels = new ArrayList<Model>();
        boolean bl4 = this.doCheckAgainstULK = this.getType() != 4 && this.options.getNumPatterns() > 0 && this.options.getUnconstrainedLnL() > 1.0E-10;
        if (this.doCheckAgainstULK) {
            this.unconstrainedModel = new Model(this.numModels, "UModel", "-", this.options.getNumPatterns() - 1);
            this.unconstrainedModel.setLnL(this.options.getUnconstrainedLnL());
        }
    }

    public void parameterImportance() {
        this.ifT = 0.0;
        this.ifC = 0.0;
        this.ifG = 0.0;
        this.ifA = 0.0;
        this.iRf = 0.0;
        this.iRe = 0.0;
        this.iRd = 0.0;
        this.iRc = 0.0;
        this.iRb = 0.0;
        this.iRa = 0.0;
        this.ititv = 0.0;
        this.ishapeIG = 0.0;
        this.ipinvIG = 0.0;
        this.ishapeG = 0.0;
        this.ipinvI = 0.0;
        for (Model model : this.confidenceModels) {
            double d = this.getWeight(model) / this.cumWeight;
            String string = model.getPartition();
            if (model.ispF()) {
                this.ifA += d;
                this.ifC += d;
                this.ifG += d;
                this.ifT += d;
            }
            if (model.ispT()) {
                this.ikappa += d;
                this.ititv += d;
            } else if (model.ispR()) {
                if (string.charAt(0) != string.charAt(5)) {
                    this.iRa += d;
                }
                if (string.charAt(1) != string.charAt(5)) {
                    this.iRb += d;
                }
                if (string.charAt(2) != string.charAt(5)) {
                    this.iRc += d;
                }
                if (string.charAt(3) != string.charAt(5)) {
                    this.iRd += d;
                }
                if (string.charAt(4) != string.charAt(5)) {
                    this.iRe += d;
                }
                this.iRf += d;
            }
            if (model.ispI() && !model.ispG()) {
                this.ipinvI += d;
                continue;
            }
            if (!model.ispI() && model.ispG()) {
                this.ishapeG += d;
                continue;
            }
            if (!model.ispI() || !model.ispG()) continue;
            this.ipinvIG += d;
            this.ishapeIG += d;
        }
    }

    public void averageModels() {
        this.afT = 0.0;
        this.afC = 0.0;
        this.afG = 0.0;
        this.afA = 0.0;
        this.aRf = 0.0;
        this.aRe = 0.0;
        this.aRd = 0.0;
        this.aRc = 0.0;
        this.aRb = 0.0;
        this.aRa = 0.0;
        this.akappa = 0.0;
        this.atitv = 0.0;
        this.ashapeIG = 0.0;
        this.apinvIG = 0.0;
        this.ashapeG = 0.0;
        this.apinvI = 0.0;
        double d = -2.147483648E9;
        double d2 = this.getWeight(this.models[this.order[this.numModels - 1]]);
        for (Model model : this.confidenceModels) {
            double d3 = this.getWeight(model) / this.cumWeight;
            String string = model.getPartition();
            if (model.ispF()) {
                if (this.ifA >= d2) {
                    this.afA += model.getfA() * d3 / this.ifA;
                }
                if (this.ifC >= d2) {
                    this.afC += model.getfC() * d3 / this.ifC;
                }
                if (this.ifG >= d2) {
                    this.afG += model.getfG() * d3 / this.ifG;
                }
                if (this.ifT >= d2) {
                    this.afT += model.getfT() * d3 / this.ifT;
                }
            }
            if (model.ispT()) {
                if (this.ikappa >= d2) {
                    this.akappa += model.getKappa() * d3 / this.ikappa;
                }
                if (this.ititv >= d2) {
                    this.atitv += model.getTitv() * d3 / this.ititv;
                }
            } else if (model.ispR()) {
                if (string.charAt(0) != string.charAt(5) && this.iRa >= d2) {
                    this.aRa += model.getRa() * d3 / this.iRa;
                }
                if (string.charAt(1) != string.charAt(5) && this.iRb >= d2) {
                    this.aRb += model.getRb() * d3 / this.iRb;
                }
                if (string.charAt(2) != string.charAt(5) && this.iRc >= d2) {
                    this.aRc += model.getRc() * d3 / this.iRc;
                }
                if (string.charAt(3) != string.charAt(5) && this.iRd >= d2) {
                    this.aRd += model.getRd() * d3 / this.iRd;
                }
                if (string.charAt(4) != string.charAt(5) && this.iRe >= d2) {
                    this.aRe += model.getRe() * d3 / this.iRe;
                }
                if (this.iRf >= d2) {
                    this.aRf += model.getRf() * d3 / this.iRf;
                }
            }
            if (!model.ispI() && model.ispG()) {
                if (!(this.ishapeG > d2)) continue;
                this.ashapeG += model.getShape() * d3 / this.ishapeG;
                continue;
            }
            if (model.ispI() && !model.ispG()) {
                if (!(this.ipinvI > d2)) continue;
                this.apinvI += model.getPinv() * d3 / this.ipinvI;
                continue;
            }
            if (!model.ispI() || !model.ispG()) continue;
            if (this.ishapeIG > d2) {
                this.ashapeIG += model.getShape() * d3 / this.ishapeIG;
            }
            if (!(this.ipinvIG > d2)) continue;
            this.apinvIG += model.getPinv() * d3 / this.ipinvIG;
        }
        if (this.ifA < d2) {
            this.afA = d;
        }
        if (this.ifC < d2) {
            this.afC = d;
        }
        if (this.ifG < d2) {
            this.afG = d;
        }
        if (this.ifT < d2) {
            this.afT = d;
        }
        if (this.ikappa < d2) {
            this.akappa = d;
        }
        if (this.ititv < d2) {
            this.atitv = d;
        }
        if (this.iRa < d2) {
            this.aRa = d;
        }
        if (this.iRb < d2) {
            this.aRb = d;
        }
        if (this.iRc < d2) {
            this.aRc = d;
        }
        if (this.iRd < d2) {
            this.aRd = d;
        }
        if (this.iRe < d2) {
            this.aRe = d;
        }
        if (this.iRf < d2) {
            this.aRf = d;
        }
        if (this.ishapeG < d2) {
            this.ashapeG = d;
        }
        if (this.ipinvI < d2) {
            this.apinvI = d;
        }
        if (this.ishapeIG < d2) {
            this.ashapeIG = d;
        }
        if (this.ipinvIG < d2) {
            this.apinvIG = d;
        }
    }

    public double getAfA() {
        return this.afA;
    }

    public double getIfA() {
        return this.ifA;
    }

    public double getIfG() {
        return this.ifG;
    }

    public double getIshapeIG() {
        return this.ishapeIG;
    }

    public double getIpinvIG() {
        return this.ipinvIG;
    }

    public double getIshapeG() {
        return this.ishapeG;
    }

    public double getIpinvI() {
        return this.ipinvI;
    }

    public double getiRf() {
        return this.iRf;
    }

    public double getiRe() {
        return this.iRe;
    }

    public double getiRd() {
        return this.iRd;
    }

    public double getiRc() {
        return this.iRc;
    }

    public double getiRb() {
        return this.iRb;
    }

    public double getiRa() {
        return this.iRa;
    }

    public double getIkappa() {
        return this.ikappa;
    }

    public double getItitv() {
        return this.ititv;
    }

    public double getIfT() {
        return this.ifT;
    }

    public double getIfC() {
        return this.ifC;
    }

    public double getAfG() {
        return this.afG;
    }

    public double getAshapeIG() {
        return this.ashapeIG;
    }

    public double getApinvIG() {
        return this.apinvIG;
    }

    public double getAshapeG() {
        return this.ashapeG;
    }

    public double getApinvI() {
        return this.apinvI;
    }

    public double getaRf() {
        return this.aRf;
    }

    public double getaRe() {
        return this.aRe;
    }

    public double getaRd() {
        return this.aRd;
    }

    public double getaRc() {
        return this.aRc;
    }

    public double getaRb() {
        return this.aRb;
    }

    public double getaRa() {
        return this.aRa;
    }

    public double getAkappa() {
        return this.akappa;
    }

    public double getAtitv() {
        return this.atitv;
    }

    public double getAfT() {
        return this.afT;
    }

    public double getAfC() {
        return this.afC;
    }

    public Model getMinModel() {
        return this.minModel;
    }

    public String toString() {
        switch (this.getType()) {
            case 1: {
                return "AIC";
            }
            case 3: {
                return "BIC";
            }
            case 2: {
                return "AICc";
            }
            case 4: {
                return "DT";
            }
        }
        return null;
    }

    public Model getModel(int n) {
        return this.models[this.order[n]];
    }

    public void print(TextOutputStream textOutputStream) {
        String string = names[this.getType()];
        this.printHeader(textOutputStream);
        textOutputStream.println(" ");
        textOutputStream.println(" Model selected: ");
        this.getMinModel().print(textOutputStream);
        if (this.writePAUPblock) {
            ModelTest.WritePaupBlock(textOutputStream, string, this.minModel);
        }
        textOutputStream.println(" ");
        textOutputStream.println("Tree for the best " + string + " model = " + this.minModel.getTreeString());
        if (this.unconstrainedModel != null) {
            this.unconstrainedModel.setLnL(this.minModel.getUnconstrainedLnL());
        }
        textOutputStream.println(" ");
        textOutputStream.println(" ");
        textOutputStream.println("* " + string + " MODEL SELECTION : Selection uncertainty");
        textOutputStream.println(" ");
        textOutputStream.printf("Model             -lnL    K        %4s      delta      weight cumWeight", string);
        if (this.doCheckAgainstULK && this.minModel.getUnconstrainedLnL() > 1.0E-10) {
            textOutputStream.println("       uDelta");
        } else {
            textOutputStream.println("");
        }
        textOutputStream.print("------------------------------------------------------------------------");
        if (this.doCheckAgainstULK && this.minModel.getUnconstrainedLnL() > 1.0E-10) {
            textOutputStream.print("-------------");
        }
        for (int i = 0; i < this.numModels; ++i) {
            int n = this.order[i];
            textOutputStream.println(" ");
            textOutputStream.printf("%-10s", this.models[n].getName());
            textOutputStream.printf("  %10.4f", this.models[n].getLnL());
            if (this.options.countBLasParameters) {
                textOutputStream.printf("   %2d", this.models[n].getK());
            } else {
                textOutputStream.printf("  %2d", this.models[n].getK() - this.options.getNumBranches());
            }
            textOutputStream.printf("  %10.4f", this.getValue(this.models[n]));
            textOutputStream.printf("  %9.4f", this.getDelta(this.models[n]));
            if (this.getWeight(this.models[n]) > 1.0E-4) {
                textOutputStream.printf("   %9.4f", this.getWeight(this.models[n]));
            } else {
                textOutputStream.printf("   %4.2e", this.getWeight(this.models[n]));
            }
            textOutputStream.printf("   %7.4f", this.getCumWeight(this.models[n]));
            if (!this.doCheckAgainstULK || !(this.minModel.getUnconstrainedLnL() > 1.0E-10)) continue;
            if (!this.options.isAmbiguous()) {
                textOutputStream.printf("   %10.4f", this.getUDelta(this.models[n]));
                continue;
            }
            if (i == 0) {
                textOutputStream.printf("   %10.4f", this.setUDelta(this.models[n]));
                continue;
            }
            textOutputStream.print("            -");
        }
        textOutputStream.print("\n------------------------------------------------------------------------");
        if (this.doCheckAgainstULK && this.minModel.getUnconstrainedLnL() > 1.0E-10) {
            textOutputStream.print("-------------");
        }
        textOutputStream.println("");
        this.printFooter(textOutputStream);
        Utilities.toConsoleEnd();
        if (ModelTest.buildGUI) {
            textOutputStream.println("\nModel selection results also available at the \"Model > Show model table\" menu");
            Utilities.toConsoleEnd();
        }
        textOutputStream.println(" ");
        textOutputStream.println(" ");
        textOutputStream.println("* " + string + " MODEL SELECTION : Confidence interval");
        textOutputStream.println(" ");
        textOutputStream.print("There are " + this.confidenceModels.size() + " models in the ");
        textOutputStream.printf("%.0f% ", this.confidenceInterval * 100.0);
        textOutputStream.print("confidence interval: [ ");
        for (Model model : this.confidenceModels) {
            textOutputStream.print(model.getName() + " ");
        }
        textOutputStream.println("] ");
        if (this.doImportances) {
            textOutputStream.println(" ");
            textOutputStream.println(" ");
            textOutputStream.println("* " + string + " MODEL SELECTION : Parameter importance");
            textOutputStream.println(" ");
            textOutputStream.println("Parameter   Importance");
            textOutputStream.print("----------------------");
            if (this.options.doF) {
                textOutputStream.printf("\nfA\t%10.4f", this.ifA);
                textOutputStream.printf("\nfC\t%10.4f", this.ifC);
                textOutputStream.printf("\nfG\t%10.4f", this.ifG);
                textOutputStream.printf("\nfT\t%10.4f", this.ifT);
            }
            textOutputStream.printf("\nkappa\t%10.4f", this.ikappa);
            textOutputStream.printf("\ntitv\t%10.4f", this.ititv);
            textOutputStream.printf("\nrAC\t%10.4f", this.iRa);
            textOutputStream.printf("\nrAG\t%10.4f", this.iRb);
            textOutputStream.printf("\nrAT\t%10.4f", this.iRc);
            textOutputStream.printf("\nrCG\t%10.4f", this.iRd);
            textOutputStream.printf("\nrCT\t%10.4f", this.iRe);
            textOutputStream.printf("\nrGT\t%10.4f", this.iRf);
            if (this.options.doI) {
                textOutputStream.printf("\npinv(I)\t%10.4f", this.ipinvI);
            }
            if (this.options.doG) {
                textOutputStream.printf("\nalpha(G)\t%10.4f", this.ishapeG);
            }
            if (this.options.doI && this.options.doG) {
                textOutputStream.printf("\npinv(IG)\t%10.4f", this.ipinvIG);
                textOutputStream.printf("\nalpha(IG)\t%10.4f", this.ishapeIG);
            }
            textOutputStream.println("\n----------------------");
            textOutputStream.println("Values have been rounded.");
            textOutputStream.println(" (I):  considers only +I models.");
            textOutputStream.println(" (G):  considers only +G models.");
            textOutputStream.println(" (IG): considers only +I+G models.");
        }
        if (this.doModelAveraging) {
            textOutputStream.println(" ");
            textOutputStream.println(" ");
            textOutputStream.println("* " + string + " MODEL SELECTION : Model averaged estimates");
            textOutputStream.println(" ");
            textOutputStream.println("           Model-averaged");
            textOutputStream.println("Parameter       estimates");
            textOutputStream.print("-------------------------");
            if (this.options.doF) {
                textOutputStream.printf("\nfA\t%13s", Utilities.checkNA(this.afA));
                textOutputStream.printf("\nfC\t%13s", Utilities.checkNA(this.afC));
                textOutputStream.printf("\nfG\t%13s", Utilities.checkNA(this.afG));
                textOutputStream.printf("\nfT\t%13s", Utilities.checkNA(this.afT));
            }
            textOutputStream.printf("\nkappa\t%13s", Utilities.checkNA(this.akappa));
            textOutputStream.printf("\ntitv\t%13s", Utilities.checkNA(this.atitv));
            textOutputStream.printf("\nrAC\t%13s", Utilities.checkNA(this.aRa));
            textOutputStream.printf("\nrAG\t%13s", Utilities.checkNA(this.aRb));
            textOutputStream.printf("\nrAT\t%13s", Utilities.checkNA(this.aRc));
            textOutputStream.printf("\nrCG\t%13s", Utilities.checkNA(this.aRd));
            textOutputStream.printf("\nrCT\t%13s", Utilities.checkNA(this.aRe));
            textOutputStream.printf("\nrGT\t%13s", Utilities.checkNA(this.aRf));
            if (this.options.doI) {
                textOutputStream.printf("\npinv(I)\t%13s", Utilities.checkNA(this.apinvI));
            }
            if (this.options.doG) {
                textOutputStream.printf("\nalpha(G)\t%13s", Utilities.checkNA(this.ashapeG));
            }
            if (this.options.doI && this.options.doG) {
                textOutputStream.printf("\npinv(IG)\t%13s", Utilities.checkNA(this.apinvIG));
                textOutputStream.printf("\nalpha(IG)\t%13s", Utilities.checkNA(this.ashapeIG));
            }
            textOutputStream.println("\n-------------------------");
            textOutputStream.println("Numbers have been rounded.");
            textOutputStream.println(" (I):  considers only +I models.");
            textOutputStream.println(" (G):  considers only +G models.");
            textOutputStream.println(" (IG): considers only +I+G models.");
        }
        textOutputStream.println(" ");
        textOutputStream.println(" ");
        textOutputStream.println("* " + string + " MODEL SELECTION : Best Model's command line");
        textOutputStream.println(" ");
        textOutputStream.println("phyml " + PhymlSingleModel.writePhyml3CommandLine(this.getMinModel(), false, this.options, false, -1));
        if (this.getValue(this.minModel) < 0.0) {
            textOutputStream.println(" ");
            textOutputStream.println("WARNING! Criterion has negative values. Please check whether your sample size is big enough compared to the number of parameters (K)");
        }
    }

    public int getNumModels() {
        return this.numModels;
    }

    public abstract void compute();

    public abstract double computeSingle(Model var1);

    public abstract void buildConfidenceInterval();

    public abstract double getMinModelValue();

    public abstract double getMinModelWeight();

    public abstract double getValue(Model var1);

    public abstract double getDelta(Model var1);

    public abstract double getUDelta(Model var1);

    public abstract double setUDelta(Model var1);

    public abstract double getWeight(Model var1);

    public abstract double getCumWeight(Model var1);

    protected abstract void printHeader(TextOutputStream var1);

    protected abstract void printFooter(TextOutputStream var1);

    public abstract int getType();
}

