/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.selection;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import java.util.Random;

public class BIC
extends InformationCriterion {
    public BIC(boolean bl, boolean bl2, boolean bl3, double d) {
        super(bl, bl2, bl3, d);
    }

    @Override
    public void compute() {
        int n;
        double[] dArray = new double[this.numModels];
        double d = BIC.computeBic(this.models[0], this.options);
        this.minModel = this.models[0];
        if (this.doCheckAgainstULK) {
            this.unconstrainedModel.setBIC(this.computeSingle(this.unconstrainedModel));
        }
        for (Model model : this.models) {
            model.setBIC(BIC.computeBic(model, this.options));
            if (model.getBIC() < d) {
                d = model.getBIC();
                this.minModel = model;
            }
            if (!this.doCheckAgainstULK) continue;
            model.setUBICd(model.getBIC() - this.unconstrainedModel.getBIC());
        }
        double d2 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[n].setBICd(this.models[n].getBIC() - this.minModel.getBIC());
            d2 += Math.exp(-0.5 * this.models[n].getBICd());
        }
        for (n = 0; n < this.numModels; ++n) {
            if (this.models[n].getBICd() > 1000.0) {
                this.models[n].setBICw(0.0);
            } else {
                this.models[n].setBICw(Math.exp(-0.5 * this.models[n].getBICd()) / d2);
            }
            dArray[n] = this.models[n].getBIC();
            this.order[n] = n;
        }
        boolean bl = false;
        int n2 = 1;
        while (!bl) {
            bl = true;
            for (n = 0; n < this.numModels - n2; ++n) {
                if (!(dArray[n] > dArray[n + 1])) continue;
                double d3 = dArray[n + 1];
                dArray[n + 1] = dArray[n];
                dArray[n] = d3;
                int n3 = this.order[n + 1];
                this.order[n + 1] = this.order[n];
                this.order[n] = n3;
                bl = false;
            }
            ++n2;
        }
        double d4 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[this.order[n]].setCumBICw(d4 += this.models[this.order[n]].getBICw());
        }
        this.buildConfidenceInterval();
        if (this.doImportances || this.doModelAveraging) {
            this.parameterImportance();
        }
        if (this.doModelAveraging) {
            this.averageModels();
        }
    }

    @Override
    public double computeSingle(Model model) {
        return BIC.computeBic(model, this.options);
    }

    public static double computeBic(Model model, ApplicationOptions applicationOptions) {
        if (applicationOptions.countBLasParameters) {
            return 2.0 * model.getLnL() + (double)model.getK() * Math.log(applicationOptions.getSampleSize());
        }
        return 2.0 * model.getLnL() + (double)(model.getK() - applicationOptions.getNumBranches()) * Math.log(applicationOptions.getSampleSize());
    }

    public static double computeBic(double d, int n, ApplicationOptions applicationOptions) {
        if (applicationOptions.countBLasParameters) {
            return 2.0 * d + (double)n * Math.log(applicationOptions.getSampleSize());
        }
        return 2.0 * d + (double)(n - applicationOptions.getNumBranches()) * Math.log(applicationOptions.getSampleSize());
    }

    @Override
    protected void printHeader(TextOutputStream textOutputStream) {
        textOutputStream.println("\n\n\n---------------------------------------------------------------");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("*             BAYESIAN INFORMATION CRITERION (BIC)            *");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("---------------------------------------------------------------");
        textOutputStream.println(" ");
        textOutputStream.println(" Sample size: " + this.options.getSampleSize());
    }

    @Override
    protected void printFooter(TextOutputStream textOutputStream) {
        textOutputStream.println("-lnL:\tnegative log likelihod");
        textOutputStream.println("K:\tnumber of estimated parameters");
        textOutputStream.println("BIC:\tBayesian Information Criterion");
        textOutputStream.println("delta:\tBIC difference");
        textOutputStream.println("weight:\tBIC weight");
        textOutputStream.println("cumWeight:\tcumulative BIC weight");
    }

    @Override
    public void buildConfidenceInterval() {
        Model model = this.models[0];
        this.cumWeight = 0.0;
        if (this.confidenceInterval >= 1.0) {
            for (int i = 0; i < this.numModels; ++i) {
                model = this.models[this.order[i]];
                model.setInBICinterval(true);
                this.confidenceModels.add(model);
            }
            this.cumWeight = 1.0;
        } else {
            for (int i = 0; i < this.numModels && (model = this.models[this.order[i]]).getCumBICw() <= this.confidenceInterval; ++i) {
                model.setInBICinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getBICw();
            }
            double d = (model.getCumBICw() - this.confidenceInterval) / model.getBICw();
            double d2 = 1.0 - d;
            Random random = new Random();
            double d3 = random.nextDouble();
            if (d3 <= d2) {
                model.setInBICinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getBICw();
            } else {
                model.setInBICinterval(false);
            }
        }
    }

    @Override
    public double getMinModelValue() {
        return this.minModel.getBIC();
    }

    @Override
    public double getMinModelWeight() {
        return this.minModel.getBICw();
    }

    @Override
    public double getValue(Model model) {
        return model.getBIC();
    }

    @Override
    public double getWeight(Model model) {
        return model.getBICw();
    }

    @Override
    public double getDelta(Model model) {
        return model.getBICd();
    }

    @Override
    public double getUDelta(Model model) {
        return model.getUBICd();
    }

    @Override
    public double setUDelta(Model model) {
        model.setUBICd(BIC.computeBic(model.getLnLIgnoringGaps(), model.getK(), this.options) - BIC.computeBic(this.unconstrainedModel.getLnL(), this.unconstrainedModel.getK(), this.options));
        return model.getUBICd();
    }

    @Override
    public double getCumWeight(Model model) {
        return model.getCumBICw();
    }

    @Override
    public int getType() {
        return 3;
    }
}

