/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.selection;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.io.TextOutputStream;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import java.util.Random;

public class AIC
extends InformationCriterion {
    public AIC(boolean bl, boolean bl2, boolean bl3, double d) {
        super(bl, bl2, bl3, d);
    }

    @Override
    public void compute() {
        int n;
        double[] dArray = new double[this.numModels];
        double d = AIC.computeAic(this.models[0], this.options);
        this.minModel = this.models[0];
        if (this.doCheckAgainstULK) {
            this.unconstrainedModel.setAIC(this.computeSingle(this.unconstrainedModel));
        }
        for (Model model : this.models) {
            model.setAIC(AIC.computeAic(model, this.options));
            if (model.getAIC() < d) {
                d = model.getAIC();
                this.minModel = model;
            }
            if (!this.doCheckAgainstULK) continue;
            model.setUAICd(model.getAIC() - this.unconstrainedModel.getAIC());
        }
        double d2 = 0.0;
        for (Model model : this.models) {
            model.setAICd(model.getAIC() - this.minModel.getAIC());
            d2 += Math.exp(-0.5 * model.getAICd());
        }
        for (n = 0; n < this.numModels; ++n) {
            if (this.models[n].getAICd() > 1000.0) {
                this.models[n].setAICw(0.0);
            } else {
                this.models[n].setAICw(Math.exp(-0.5 * this.models[n].getAICd()) / d2);
            }
            dArray[n] = this.models[n].getAIC();
            this.order[n] = n;
        }
        boolean bl = false;
        int n2 = 1;
        while (!bl) {
            bl = true;
            for (n = 0; n < this.numModels - n2; ++n) {
                if (!(dArray[n] > dArray[n + 1])) continue;
                double d3 = dArray[n + 1];
                dArray[n + 1] = dArray[n];
                dArray[n] = d3;
                int n3 = this.order[n + 1];
                this.order[n + 1] = this.order[n];
                this.order[n] = n3;
                bl = false;
            }
            ++n2;
        }
        double d4 = 0.0;
        for (n = 0; n < this.numModels; ++n) {
            this.models[this.order[n]].setCumAICw(d4 += this.models[this.order[n]].getAICw());
        }
        this.buildConfidenceInterval();
        if (this.doImportances || this.doModelAveraging) {
            this.parameterImportance();
        }
        if (this.doModelAveraging) {
            this.averageModels();
        }
    }

    @Override
    public double computeSingle(Model model) {
        return AIC.computeAic(model, this.options);
    }

    public static double computeAic(Model model, ApplicationOptions applicationOptions) {
        if (applicationOptions.countBLasParameters) {
            return 2.0 * (model.getLnL() + (double)model.getK());
        }
        return 2.0 * (model.getLnL() + (double)model.getK() - (double)applicationOptions.getNumBranches());
    }

    public static double computeAic(double d, int n, ApplicationOptions applicationOptions) {
        if (applicationOptions.countBLasParameters) {
            return 2.0 * (d + (double)n);
        }
        return 2.0 * (d + (double)n - (double)applicationOptions.getNumBranches());
    }

    @Override
    protected void printHeader(TextOutputStream textOutputStream) {
        textOutputStream.println("\n\n\n---------------------------------------------------------------");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("*             AKAIKE INFORMATION CRITERION (AIC)              *");
        textOutputStream.println("*                                                             *");
        textOutputStream.println("---------------------------------------------------------------");
    }

    @Override
    protected void printFooter(TextOutputStream textOutputStream) {
        textOutputStream.println("-lnL:\tnegative log likelihod");
        textOutputStream.println(" K:\tnumber of estimated parameters");
        textOutputStream.println(" AIC:\tAkaike Information Criterion");
        textOutputStream.println(" delta:\tAIC difference");
        textOutputStream.println(" weight:\tAIC weight");
        textOutputStream.println(" cumWeight:\tcumulative AIC weight");
    }

    @Override
    public void buildConfidenceInterval() {
        Model model = this.models[0];
        this.cumWeight = 0.0;
        if (this.confidenceInterval >= 1.0) {
            for (int i = 0; i < this.numModels; ++i) {
                model = this.models[this.order[i]];
                model.setInAICinterval(true);
                this.confidenceModels.add(model);
            }
            this.cumWeight = 1.0;
        } else {
            for (int i = 0; i < this.numModels && (model = this.models[this.order[i]]).getCumAICw() <= this.confidenceInterval; ++i) {
                model.setInAICinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getAICw();
            }
            double d = (model.getCumAICw() - this.confidenceInterval) / model.getAICw();
            double d2 = 1.0 - d;
            Random random = new Random();
            double d3 = random.nextDouble();
            if (d3 <= d2) {
                model.setInAICinterval(true);
                this.confidenceModels.add(model);
                this.cumWeight += model.getAICw();
            } else {
                model.setInAICinterval(false);
            }
        }
    }

    @Override
    public double getMinModelValue() {
        return this.minModel.getAIC();
    }

    @Override
    public double getMinModelWeight() {
        return this.minModel.getAICw();
    }

    @Override
    public double getValue(Model model) {
        return model.getAIC();
    }

    @Override
    public double getWeight(Model model) {
        return model.getAICw();
    }

    @Override
    public double getCumWeight(Model model) {
        return model.getCumAICw();
    }

    @Override
    public double getDelta(Model model) {
        return model.getAICd();
    }

    @Override
    public double getUDelta(Model model) {
        return model.getUAICd();
    }

    @Override
    public double setUDelta(Model model) {
        model.setUAICd(AIC.computeAic(model.getLnLIgnoringGaps(), model.getK(), this.options) - AIC.computeAic(this.unconstrainedModel.getLnL(), this.unconstrainedModel.getK(), this.options));
        return model.getUAICd();
    }

    @Override
    public int getType() {
        return 1;
    }
}

