/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.io;

import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.selection.InformationCriterion;
import es.uvigo.darwin.jmodeltest.tree.TreeDistancesCache;
import es.uvigo.darwin.jmodeltest.tree.TreeEuclideanDistancesCache;
import es.uvigo.darwin.jmodeltest.tree.TreeRFDistancesCache;
import java.util.List;
import java.util.Random;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.IntervalXYDataset;
import pal.tree.Tree;

public class RFHistogram {
    private static JFreeChart buildHistogram(double[] dArray, int n, String string, String string2, String string3) {
        HistogramDataset histogramDataset = new HistogramDataset();
        histogramDataset.setType(HistogramType.RELATIVE_FREQUENCY);
        histogramDataset.addSeries((Comparable)Integer.valueOf(1), dArray, n);
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JFreeChart jFreeChart = ChartFactory.createHistogram((String)string, (String)string2, (String)string3, (IntervalXYDataset)histogramDataset, (PlotOrientation)plotOrientation, (boolean)bl, (boolean)bl2, (boolean)bl3);
        return jFreeChart;
    }

    public static JFreeChart buildDistancesHistogram(InformationCriterion informationCriterion, TreeDistancesCache treeDistancesCache, String string) {
        List<Model> list = informationCriterion.getConfidenceModels();
        Tree tree = informationCriterion.getMinModel().getTree();
        double[] dArray = new double[list.size() - 1];
        int n = 0;
        for (Model object2 : list) {
            double n2;
            if (object2.equals(informationCriterion.getMinModel())) continue;
            dArray[n] = n2 = treeDistancesCache.getDistance(tree, object2.getTree());
            ++n;
        }
        String string2 = "distance";
        String string3 = "count";
        int n2 = 10;
        JFreeChart jFreeChart = RFHistogram.buildHistogram(dArray, n2, string, string2, string3);
        return jFreeChart;
    }

    public static JFreeChart buildRFHistogram(InformationCriterion informationCriterion) {
        return RFHistogram.buildDistancesHistogram(informationCriterion, TreeRFDistancesCache.getInstance(), informationCriterion + " RF distances histogram");
    }

    public static JFreeChart buildEuclideanHistogram(InformationCriterion informationCriterion) {
        return RFHistogram.buildDistancesHistogram(informationCriterion, TreeEuclideanDistancesCache.getInstance(), informationCriterion + " euclidean distances histogram");
    }

    public static JFreeChart buildRandomHistogram() {
        int n;
        Random random = new Random();
        double[] dArray = new double[100];
        for (n = 1; n < 100; ++n) {
            dArray[n] = random.nextDouble();
        }
        n = 10;
        String string = "Histogram";
        String string2 = "number";
        String string3 = "value";
        JFreeChart jFreeChart = RFHistogram.buildHistogram(dArray, n, string, string2, string3);
        return jFreeChart;
    }
}

