/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.statistics.Statistics;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;

public class Frame_LRTcalculator
extends JModelTestFrame {
    private static final long serialVersionUID = 3100651418525568495L;
    private JPanel jPanelLRTsettings = new JPanel();
    private JButton jButtonRunLRT = new JButton();
    private JButton jButtonCancelLRT = new JButton();
    private JButton jButtonDefaultLRT = new JButton();
    private JTextField jTextFieldLRT0 = new JTextField();
    private JTextField jTextFieldLRT1 = new JTextField();
    private JLabel jLabelLRTpvalue = new JLabel();
    private JLabel jLabelLRT = new JLabel();
    private JTextField jTextFieldLRTdf = new JTextField();
    private JPanel PanelChi2Type = new JPanel();
    private JRadioButton ButtonStandardChi = new JRadioButton();
    private JRadioButton ButtonMixedChi = new JRadioButton();
    private ButtonGroup ButtonGroupChi = new ButtonGroup();
    private boolean mShown = false;

    public void initComponents() throws Exception {
        this.jPanelLRTsettings.setSize(new Dimension(480, 270));
        this.jPanelLRTsettings.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Likelihood Ratio Test for Nested Models", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.jPanelLRTsettings.setLocation(new Point(10, 10));
        this.jPanelLRTsettings.setVisible(true);
        this.jPanelLRTsettings.setLayout(null);
        this.jTextFieldLRT0.setToolTipText("Enter here the absolute log likelihood of the simple model");
        this.jTextFieldLRT0.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "-lnL null model", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.jTextFieldLRT0.setVisible(true);
        this.jTextFieldLRT0.setSize(new Dimension(150, 50));
        this.jTextFieldLRT0.setLocation(new Point(30, 30));
        this.jTextFieldLRT1.setToolTipText("Enter here the absolute log likelihood of the complex model");
        this.jTextFieldLRT1.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "-ln alternative model", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.jTextFieldLRT1.setVisible(true);
        this.jTextFieldLRT1.setSize(new Dimension(150, 50));
        this.jTextFieldLRT1.setLocation(new Point(220, 30));
        this.jTextFieldLRTdf.setToolTipText("Enter here the difference in free parameters between the two models");
        this.jTextFieldLRTdf.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "degrees of freedom", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.jTextFieldLRTdf.setVisible(true);
        this.jTextFieldLRTdf.setSize(new Dimension(150, 50));
        this.jTextFieldLRTdf.setLocation(new Point(30, 90));
        this.jLabelLRT.setSize(new Dimension(330, 40));
        this.jLabelLRT.setLocation(new Point(30, 145));
        this.jLabelLRT.setVisible(true);
        this.jLabelLRT.setText("LRT = ");
        this.jLabelLRTpvalue.setSize(new Dimension(330, 40));
        this.jLabelLRTpvalue.setLocation(new Point(30, 175));
        this.jLabelLRTpvalue.setVisible(true);
        this.jLabelLRTpvalue.setText("P-value =");
        this.PanelChi2Type.setSize(new Dimension(210, 50));
        this.PanelChi2Type.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Chi-square distribution", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.PanelChi2Type.setLocation(new Point(220, 90));
        this.PanelChi2Type.setVisible(true);
        this.PanelChi2Type.setLayout(null);
        this.ButtonStandardChi.setVisible(true);
        this.ButtonStandardChi.setSize(new Dimension(100, 20));
        this.ButtonStandardChi.setText("Standard");
        this.ButtonStandardChi.setLocation(new Point(20, 20));
        this.ButtonStandardChi.setToolTipText("Select this if the value of the restricted parameter in the null model is not at the boundary of its range");
        this.ButtonStandardChi.setSelected(true);
        this.ButtonMixedChi.setVisible(true);
        this.ButtonMixedChi.setSize(new Dimension(70, 20));
        this.ButtonMixedChi.setText("Mixed");
        this.ButtonMixedChi.setToolTipText("Select this if the value of the restricted parameter in the null model is at the boundary of its range");
        this.ButtonMixedChi.setLocation(new Point(125, 20));
        this.ButtonGroupChi.add(this.ButtonStandardChi);
        this.ButtonGroupChi.add(this.ButtonMixedChi);
        this.PanelChi2Type.add(this.ButtonStandardChi);
        this.PanelChi2Type.add(this.ButtonMixedChi);
        this.jButtonDefaultLRT.setVisible(true);
        this.jButtonDefaultLRT.setSize(new Dimension(141, 40));
        this.jButtonDefaultLRT.setText("Default Settings");
        this.jButtonDefaultLRT.setLocation(new Point(30, 220));
        this.jButtonCancelLRT.setVisible(true);
        this.jButtonCancelLRT.setSize(new Dimension(110, 40));
        this.jButtonCancelLRT.setText("Cancel");
        this.jButtonCancelLRT.setLocation(new Point(190, 220));
        this.jButtonRunLRT.setVisible(true);
        this.jButtonRunLRT.setSize(new Dimension(110, 40));
        this.jButtonRunLRT.setText("Run");
        this.jButtonRunLRT.setLocation(new Point(320, 220));
        this.jButtonRunLRT.setToolTipText("Remember that models have to be nested!");
        this.setLocation(new Point(281, 80));
        this.getContentPane().setLayout(null);
        this.setTitle("LRT calculator");
        this.jPanelLRTsettings.add(this.jTextFieldLRT0);
        this.jPanelLRTsettings.add(this.jTextFieldLRT1);
        this.jPanelLRTsettings.add(this.jTextFieldLRTdf);
        this.jPanelLRTsettings.add(this.jButtonDefaultLRT);
        this.jPanelLRTsettings.add(this.jButtonCancelLRT);
        this.jPanelLRTsettings.add(this.jButtonRunLRT);
        this.jPanelLRTsettings.add(this.jLabelLRT);
        this.jPanelLRTsettings.add(this.jLabelLRTpvalue);
        this.jPanelLRTsettings.add(this.PanelChi2Type);
        this.getContentPane().add(this.jPanelLRTsettings);
        this.setSize(new Dimension(500, 310));
        this.setResizable(false);
        this.jButtonDefaultLRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_LRTcalculator.this.jButtonDefaultLRTActionPerformed(actionEvent);
            }
        });
        this.jButtonCancelLRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_LRTcalculator.this.jButtonCancelLRTActionPerformed(actionEvent);
            }
        });
        this.jButtonRunLRT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_LRTcalculator.this.jButtonRunLRTActionPerformed(actionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_LRTcalculator.this.thisWindowClosing(windowEvent);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public double LRT(double d, int n) {
        double d2 = d == 0.0 ? 1.0 : Statistics.chiSquareProbability(d, n);
        return d2;
    }

    private static double LRTboundary(double d, int n) {
        double d2 = d == 0.0 ? 1.0 : (n == 1 ? Statistics.chiSquareProbability(d, n) / 2.0 : (Statistics.chiSquareProbability(d, n - 1) + Statistics.chiSquareProbability(d, n)) / 2.0);
        return d2;
    }

    public void jButtonRunLRTActionPerformed(ActionEvent actionEvent) {
        try {
            String string = this.jTextFieldLRT0.getText();
            String string2 = this.jTextFieldLRT1.getText();
            String string3 = this.jTextFieldLRTdf.getText();
            if (string.length() == 0 || !Utilities.isNumber(string)) {
                JOptionPane.showMessageDialog(new JFrame(), "Enter a positive likelihood for the null model (" + string + ")", "jModeltest error", 0);
            } else if (string2.length() == 0 || !Utilities.isNumber(string2)) {
                JOptionPane.showMessageDialog(new JFrame(), "Enter a positive likelihood for the alternative model", "jModeltest error", 0);
            } else if (string3.length() == 0 || !Utilities.isNumber(string3)) {
                JOptionPane.showMessageDialog(new JFrame(), "Enter a positive number of degrees of freedom", "jModeltest error", 0);
            } else {
                double d = Double.parseDouble(string);
                double d2 = Double.parseDouble(string2);
                int n = Integer.parseInt(string3);
                double d3 = 2.0 * (d - d2);
                if (d <= 0.0 || Double.isNaN(d)) {
                    JOptionPane.showMessageDialog(new JFrame(), "Enter a positive likelihood for the null model*", "jModeltest error", 0);
                } else if (d2 <= 0.0 || Double.isNaN(d2)) {
                    JOptionPane.showMessageDialog(new JFrame(), "Enter a positive likelihood for the alternative model*", "jModeltest error", 0);
                } else if (n <= 0 || Double.isNaN(n)) {
                    JOptionPane.showMessageDialog(new JFrame(), "Enter a positive number of degrees of freedom", "jModeltest error", 0);
                } else if (d3 < 0.0) {
                    JOptionPane.showMessageDialog(new JFrame(), "The likelihood of the null model cannot be bigger than the likelihood of the alternative model!", "jModeltest error", 0);
                } else {
                    double d4 = this.ButtonMixedChi.isSelected() ? Frame_LRTcalculator.LRTboundary(d3, n) : this.LRT(d3, n);
                    this.jLabelLRT.setText("LRT = " + Utilities.roundDoubleTo(d3, 6));
                    this.jLabelLRTpvalue.setText("P-value = " + Utilities.roundDoubleTo(d4, 6));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jButtonDefaultLRTActionPerformed(ActionEvent actionEvent) {
        try {
            this.ButtonStandardChi.setSelected(true);
            this.jTextFieldLRT0.setText("");
            this.jTextFieldLRT1.setText("");
            this.jTextFieldLRTdf.setText("");
            this.jLabelLRT.setText("LRT = ");
            this.jLabelLRTpvalue.setText("P-value =");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void jButtonCancelLRTActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

