/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.selection.BIC;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.BorderUIResource;

public class Frame_BIC
extends JModelTestFrame {
    private static final long serialVersionUID = 201104031100L;
    private JPanel PanelBICSettings = new JPanel();
    private JTextField TextFieldTaxaBIC = new JTextField();
    private JTextField TextFieldSizeBIC = new JTextField();
    private JButton RunButtonBIC = new JButton();
    private JButton CancelButtonBIC = new JButton();
    private JButton JButtonDefaultBIC = new JButton();
    private JCheckBox jCheckBoxPAUPblock = new JCheckBox();
    private JCheckBox jCheckBoxAveraging = new JCheckBox();
    private JCheckBox jCheckBoxImportance = new JCheckBox();
    private JSlider JSliderInterval = new JSlider();
    private BIC myBIC;
    private boolean mShown = false;

    public void initComponents() throws Exception {
        this.PanelBICSettings.setSize(490, 240);
        this.PanelBICSettings.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "BIC Settings", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.PanelBICSettings.setLocation(10, 10);
        this.PanelBICSettings.setVisible(true);
        this.PanelBICSettings.setLayout(null);
        this.RunButtonBIC.setVisible(true);
        this.RunButtonBIC.setSize(190, 40);
        this.RunButtonBIC.setText("Do BIC calculations");
        this.RunButtonBIC.setLocation(280, 190);
        this.getRootPane().setDefaultButton(this.RunButtonBIC);
        this.JButtonDefaultBIC.setVisible(true);
        this.JButtonDefaultBIC.setSize(141, 40);
        this.JButtonDefaultBIC.setText("Default Settings");
        this.JButtonDefaultBIC.setLocation(10, 190);
        this.CancelButtonBIC.setVisible(true);
        this.CancelButtonBIC.setSize(110, 40);
        this.CancelButtonBIC.setText("Cancel");
        this.CancelButtonBIC.setLocation(160, 190);
        this.TextFieldSizeBIC.setToolTipText("Enter the sample size you want to use for the BIC and click RETURN. By default this is the number of sites in the alignment");
        this.TextFieldSizeBIC.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Sample size", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.TextFieldSizeBIC.setVisible(true);
        this.TextFieldSizeBIC.setSize(170, 40);
        this.TextFieldSizeBIC.setText(Utilities.format(this.options.getSampleSize(), 10, 4, false));
        this.TextFieldSizeBIC.setHorizontalAlignment(4);
        this.TextFieldSizeBIC.setLocation(30, 20);
        this.TextFieldSizeBIC.setEnabled(false);
        this.jCheckBoxImportance.setVisible(true);
        this.jCheckBoxImportance.setSize(260, 20);
        this.jCheckBoxImportance.setText("Calculate parameter importances");
        this.jCheckBoxImportance.setLocation(30, 70);
        this.jCheckBoxImportance.setSelected(true);
        this.jCheckBoxAveraging.setVisible(true);
        this.jCheckBoxAveraging.setSize(260, 20);
        this.jCheckBoxAveraging.setText("Do model averaging");
        this.jCheckBoxAveraging.setLocation(30, 110);
        this.jCheckBoxAveraging.setSelected(true);
        this.jCheckBoxPAUPblock.setVisible(true);
        this.jCheckBoxPAUPblock.setSize(260, 20);
        this.jCheckBoxPAUPblock.setText("Write PAUP* block");
        this.jCheckBoxPAUPblock.setLocation(30, 150);
        this.jCheckBoxPAUPblock.setSelected(false);
        this.jCheckBoxPAUPblock.setToolTipText("Writes a block of PAUP* commands implementing the selected model");
        this.JSliderInterval.setVisible(true);
        this.JSliderInterval.setToolTipText("Set the confidence interval for model averaging and/or parameter importance");
        this.JSliderInterval.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence interval = 100%", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
        this.JSliderInterval.setSize(170, 70);
        this.JSliderInterval.setLocation(300, 70);
        this.JSliderInterval.setMinimum(0);
        this.JSliderInterval.setMaximum(100);
        this.JSliderInterval.setValue(100);
        this.JSliderInterval.setMajorTickSpacing(20);
        this.JSliderInterval.setMinorTickSpacing(5);
        this.JSliderInterval.setPaintTicks(true);
        this.JSliderInterval.setPaintLabels(true);
        this.JSliderInterval.setEnabled(true);
        this.JSliderInterval.setFont(XManager.FONT_SLIDER);
        this.setLocation(281, 80);
        this.getContentPane().setLayout(null);
        this.setTitle("Bayesian Information Criterion (BIC) Settings");
        this.PanelBICSettings.add(this.TextFieldTaxaBIC);
        this.PanelBICSettings.add(this.TextFieldSizeBIC);
        this.PanelBICSettings.add(this.jCheckBoxAveraging);
        this.PanelBICSettings.add(this.jCheckBoxImportance);
        this.PanelBICSettings.add(this.jCheckBoxPAUPblock);
        this.PanelBICSettings.add(this.JSliderInterval);
        this.PanelBICSettings.add(this.JButtonDefaultBIC);
        this.PanelBICSettings.add(this.CancelButtonBIC);
        this.PanelBICSettings.add(this.RunButtonBIC);
        this.getContentPane().add(this.PanelBICSettings);
        this.setSize(510, 280);
        this.setResizable(false);
        this.jCheckBoxAveraging.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_BIC.this.jCheckBoxAveragingStateChanged(changeEvent);
            }
        });
        this.jCheckBoxImportance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_BIC.this.jCheckBoxImportanceStateChanged(changeEvent);
            }
        });
        this.JSliderInterval.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Frame_BIC.this.JSliderIntervalStateChanged(changeEvent);
            }
        });
        this.JButtonDefaultBIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_BIC.this.JButtonDefaultBICActionPerformed(actionEvent);
            }
        });
        this.CancelButtonBIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_BIC.this.CancelButtonBICActionPerformed(actionEvent);
            }
        });
        this.RunButtonBIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Frame_BIC.this.RunButtonBICActionPerformed(actionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Frame_BIC.this.thisWindowClosing(windowEvent);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
            Component[] componentArray = this.getLayeredPane().getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            for (int i = 0; i < componentArray.length; ++i) {
                Point point = componentArray[i].getLocation();
                point.move(point.x, point.y + n);
                componentArray[i].setLocation(point);
            }
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void jCheckBoxImportanceStateChanged(ChangeEvent changeEvent) {
        if (this.jCheckBoxImportance.isSelected()) {
            this.JSliderInterval.setEnabled(true);
        } else if (!this.jCheckBoxAveraging.isSelected()) {
            this.JSliderInterval.setEnabled(false);
        }
    }

    public void jCheckBoxAveragingStateChanged(ChangeEvent changeEvent) {
        if (this.jCheckBoxAveraging.isSelected()) {
            this.JSliderInterval.setEnabled(true);
        } else if (!this.jCheckBoxImportance.isSelected()) {
            this.JSliderInterval.setEnabled(false);
        }
    }

    public void JSliderIntervalStateChanged(ChangeEvent changeEvent) {
        this.JSliderInterval.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(new Color(153, 153, 153), 1, false), "Confidence interval = " + this.JSliderInterval.getValue() + "%", 4, 2, new Font("Application", 1, 10), new Color(102, 102, 153)));
    }

    public void JButtonDefaultBICActionPerformed(ActionEvent actionEvent) {
        this.TextFieldSizeBIC.setEnabled(false);
        this.TextFieldSizeBIC.setText(Utilities.format(this.options.getSampleSize(), 10, 4, false));
        ApplicationOptions.getInstance().countBLasParameters = true;
        XManager.getInstance().selectedMenuResultsBLasParameters(true);
        this.jCheckBoxPAUPblock.setSelected(false);
        this.jCheckBoxAveraging.setSelected(true);
        this.jCheckBoxImportance.setSelected(true);
        this.JSliderInterval.setValue(100);
    }

    public void CancelButtonBICActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void RunButtonBICActionPerformed(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
            boolean bl = this.jCheckBoxPAUPblock.isSelected();
            boolean bl2 = this.jCheckBoxImportance.isSelected();
            boolean bl3 = this.jCheckBoxAveraging.isSelected();
            double d = (double)this.JSliderInterval.getValue() / 100.0;
            this.myBIC = new BIC(bl, bl2, bl3, d);
            this.myBIC.compute();
            this.myBIC.print(ModelTest.getCurrentOutStream());
            ModelTest.setMyBIC(this.myBIC);
            this.options.doBIC = this.myBIC != null;
            XManager.getInstance().resultsFrame.enablePane(3);
            XManager.getInstance().resultsFrame.populate(3);
            XManager.getInstance().enableMenuAveraging(!this.options.fixedTopology);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

