/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.gui;

import es.uvigo.darwin.jmodeltest.ModelTestConfiguration;
import es.uvigo.darwin.jmodeltest.gui.JModelTestFrame;
import es.uvigo.darwin.jmodeltest.gui.XManager;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;

public class FramePreferences
extends JModelTestFrame {
    private static final int WINDOW_WIDTH = 500;
    private static final int OUTER_MARGIN = 10;
    private static final int MARGIN = 20;
    private static final int COMPONENTS_WIDTH = 480;
    private static final int COMPONENTS_HEIGHT = 20;
    private static final int MAX_INNER_WIDTH = 440;
    private static final int BINARIES_PANEL_HEIGHT = 150;
    private static final int BUTTONS_RESET_WIDTH = 140;
    private static final int BUTTONS_WIDTH = 110;
    private static final int BUTTONS_HEIGHT = 40;
    private static final int BUTTONS_PADDING = 10;
    private static final int BUTTONS_PANEL_WIDTH = 380;
    private static final int BUTTONS_VLOC = 150;
    private static final int BUTTONS_HLOC = 50;
    private static final int WINDOW_HEIGHT = 250;
    private static final long serialVersionUID = 1L;
    private static final String BACKUP_FILE = "conf/jmodeltest.conf.bk";
    private static final String BINARIES_COMMENT = "Set the phyml binary directory. The selected directory should exist and contain a valid phyml binary (\"phyml\" or \"" + Utilities.getBinaryVersion() + "\"). If Global " + "Phyml checkbox is selected, \"phyml\" should exist in the path.";
    private static final String PROPERTIES_COMMENT = "This properties file was modified from jModelTest 2 GUI. A backup of the original configuration file has been stored in conf/jmodeltest.conf.bk. Replace this file with the backup for restoring the original format.";
    private JTextArea tfBinaryDescription = new JTextArea();
    private JCheckBox cbGlobalPhyml = new JCheckBox();
    private JLabel lbPathToPhyml = new JLabel();
    private JTextField tfPathToPhyml = new JTextField();
    private JPanel binarySettingsPanel = new JPanel();
    private JPanel buttonsPanel = new JPanel();
    private JPanel preferencesPanel = new JPanel();
    private JButton btnSetDefault = new JButton();
    private JButton btnAccept = new JButton();
    private JButton btnCancel = new JButton();
    private JButton btnOpen;

    public FramePreferences() {
        this.initComponents();
    }

    public void initComponents() {
        this.preferencesPanel.setLocation(0, 0);
        this.preferencesPanel.setSize(500, 250);
        this.preferencesPanel.setVisible(true);
        this.preferencesPanel.setLayout(null);
        this.binarySettingsPanel.setLocation(10, 10);
        this.binarySettingsPanel.setSize(480, 150);
        this.binarySettingsPanel.setBorder(new BorderUIResource.TitledBorderUIResource(new LineBorder(XManager.PANEL_BORDER_COLOR, 1, false), "PhyML Binaries Settings", 1, 2, XManager.FONT_LABEL, XManager.LABEL_BLUE_COLOR));
        this.binarySettingsPanel.setVisible(true);
        this.binarySettingsPanel.setLayout(null);
        this.buttonsPanel.setLocation(50, 150);
        this.buttonsPanel.setSize(480, 150);
        this.buttonsPanel.setVisible(true);
        this.buttonsPanel.setLayout(null);
        this.tfBinaryDescription.setVisible(true);
        this.tfBinaryDescription.setEditable(false);
        this.tfBinaryDescription.setOpaque(false);
        this.tfBinaryDescription.setForeground(XManager.DARK_GRAY_COLOR);
        this.tfBinaryDescription.setSize(440, 60);
        this.tfBinaryDescription.setLocation(20, 20);
        this.tfBinaryDescription.setText(BINARIES_COMMENT);
        this.tfBinaryDescription.setFont(XManager.FONT_LABEL);
        this.tfBinaryDescription.setLineWrap(true);
        this.tfBinaryDescription.setWrapStyleWord(true);
        this.cbGlobalPhyml.setVisible(true);
        this.cbGlobalPhyml.setSize(440, 20);
        this.cbGlobalPhyml.setText("Use global PhyML binary");
        this.cbGlobalPhyml.setLocation(20, 80);
        this.cbGlobalPhyml.setFont(XManager.FONT_LABEL);
        this.lbPathToPhyml.setVisible(true);
        this.lbPathToPhyml.setSize(120, 20);
        this.lbPathToPhyml.setText("PhyML binary path:");
        this.lbPathToPhyml.setLocation(40, 100);
        this.lbPathToPhyml.setFont(XManager.FONT_LABEL);
        this.tfPathToPhyml.setVisible(true);
        this.tfPathToPhyml.setSize(280, 20);
        this.tfPathToPhyml.setLocation(160, 100);
        this.tfPathToPhyml.setFont(XManager.FONT_LABEL);
        this.btnOpen = XManager.makeIconButton("Open16", "Explore", "...");
        this.btnOpen.setLocation(440, 100);
        this.btnSetDefault.setText("Default Settings");
        this.btnSetDefault.setLocation(0, 20);
        this.btnSetDefault.setSize(140, 40);
        this.btnSetDefault.setVisible(true);
        this.btnCancel.setText("Cancel");
        this.btnCancel.setLocation(150, 20);
        this.btnCancel.setSize(110, 40);
        this.btnCancel.setVisible(true);
        this.btnAccept.setText("Accept");
        this.btnAccept.setLocation(270, 20);
        this.btnAccept.setSize(110, 40);
        this.btnAccept.setVisible(true);
        this.setSize(500, 250);
        this.setResizable(false);
        this.binarySettingsPanel.add(this.tfBinaryDescription);
        this.binarySettingsPanel.add(this.tfPathToPhyml);
        this.binarySettingsPanel.add(this.btnOpen);
        this.binarySettingsPanel.add(this.cbGlobalPhyml);
        this.binarySettingsPanel.add(this.lbPathToPhyml);
        this.buttonsPanel.add(this.btnSetDefault);
        this.buttonsPanel.add(this.btnAccept);
        this.buttonsPanel.add(this.btnCancel);
        this.preferencesPanel.add(this.binarySettingsPanel);
        this.preferencesPanel.add(this.buttonsPanel);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(this.preferencesPanel);
        this.setTitle("Preferences");
        this.setDefaultCloseOperation(0);
        this.setLocation(XManager.MAIN_LOCATION);
        this.getRootPane().setDefaultButton(this.btnAccept);
        this.setStatus();
        this.cbGlobalPhyml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePreferences.this.globalPhymlActionPerformed(actionEvent);
            }
        });
        this.btnSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePreferences.this.cbGlobalPhyml.setSelected(false);
                FramePreferences.this.tfPathToPhyml.setText(ModelTestConfiguration.DEFAULT_EXE_DIR);
                FramePreferences.this.tfPathToPhyml.setEnabled(!FramePreferences.this.cbGlobalPhyml.isSelected());
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePreferences.this.cancelActionPerformed(actionEvent);
            }
        });
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePreferences.this.acceptActionPerformed(actionEvent);
            }
        });
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FramePreferences.this.exploreActionPerformed(actionEvent);
            }
        });
    }

    private void setStatus() {
        this.cbGlobalPhyml.setSelected(ModelTestConfiguration.isGlobalPhymlBinary());
        this.tfPathToPhyml.setText(ModelTestConfiguration.getExeDir());
        this.tfPathToPhyml.setEnabled(!this.cbGlobalPhyml.isSelected());
    }

    private void cancelActionPerformed(ActionEvent actionEvent) {
        try {
            this.setStatus();
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void acceptActionPerformed(ActionEvent actionEvent) {
        try {
            Serializable serializable;
            boolean bl = true;
            if (!this.cbGlobalPhyml.isSelected() && (bl = ((File)(serializable = new File(this.tfPathToPhyml.getText()))).exists() && ((File)serializable).isDirectory())) {
                String string = this.tfPathToPhyml.getText();
                if (!string.endsWith(File.separator)) {
                    string = string + File.separator;
                }
                File file = new File(string + Utilities.getBinaryVersion());
                File file2 = new File(string + "phyml");
                boolean bl2 = bl = file.exists() && file.isFile() && file.canExecute() || file2.exists() && file2.isFile() && file2.canExecute();
            }
            if (!bl) {
                JOptionPane.showMessageDialog(this, "There is no phyml binary in the selected location. \nPlease make sure that exists an executable file named\n\"phyml\" or " + Utilities.getBinaryVersion() + ".", "jModelTest error", 0);
                return;
            }
            serializable = ModelTestConfiguration.getProperties();
            ((Properties)serializable).setProperty("exe-dir", this.tfPathToPhyml.getText());
            ((Properties)serializable).setProperty("global-phyml-exe", this.cbGlobalPhyml.isSelected() ? "true" : "false");
            this.writeProperties();
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void globalPhymlActionPerformed(ActionEvent actionEvent) {
        try {
            this.tfPathToPhyml.setEnabled(!this.cbGlobalPhyml.isSelected());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void exploreActionPerformed(ActionEvent actionEvent) {
        try {
            FileDialog fileDialog;
            try {
                fileDialog = new FileDialog((Frame)this, "Select PhyML binaries directory", 0);
                fileDialog.setDirectory(ModelTestConfiguration.DEFAULT_EXE_DIR);
                fileDialog.setVisible(true);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            this.tfPathToPhyml.setText(fileDialog.getDirectory());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeProperties() {
        Properties properties = ModelTestConfiguration.getProperties();
        try {
            Object object;
            File file = new File(BACKUP_FILE);
            if (!file.exists()) {
                int n;
                object = new File("conf/jmodeltest.conf");
                FileInputStream fileInputStream = new FileInputStream((File)object);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
            }
            object = new FileOutputStream("conf/jmodeltest.conf".replace("\\", "/"));
            properties.store((OutputStream)object, PROPERTIES_COMMENT);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }
}

