/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ApplicationOptions;
import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.exe.GuidedSearchManager;
import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.exe.ProcessManager;
import es.uvigo.darwin.jmodeltest.exe.RunPhyml;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.selection.AIC;
import es.uvigo.darwin.jmodeltest.selection.AICc;
import es.uvigo.darwin.jmodeltest.selection.BIC;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RunPhymlClustering
extends RunPhyml {
    private ExecutorService threadPool;
    private int currentStage;
    private int numModelsInStage;

    public RunPhymlClustering(Observer observer, ApplicationOptions applicationOptions, Model[] modelArray) {
        super(observer, applicationOptions, modelArray);
        this.threadPool = Executors.newFixedThreadPool(applicationOptions.getNumberOfThreads());
    }

    @Override
    protected Object doPhyml() {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        arrayList.add(this.gtrModel);
        Model model = this.gtrModel;
        if (this.gtrModel == null) {
            model = this.models[this.models.length - 1];
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        for (int i = 6; i > 0; --i) {
            String string = model == null ? "012345" : model.getPartition();
            Model[] modelArray = GuidedSearchManager.getModelsSubset(this.models, string, i);
            this.currentStage = 7 - i;
            this.numModelsInStage = modelArray.length;
            if (modelArray.length <= 0) continue;
            Model model2 = modelArray[0];
            for (Model model3 : modelArray) {
                PhymlSingleModel phymlSingleModel = new PhymlSingleModel(model3, 0, false, false, this.options);
                phymlSingleModel.addObserver(this);
                phymlSingleModel.run();
                double d3 = Double.MAX_VALUE;
                switch (this.options.getHeuristicInformationCriterion()) {
                    case 1: {
                        d3 = AIC.computeAic(model3, this.options);
                        break;
                    }
                    case 3: {
                        d3 = BIC.computeBic(model3, this.options);
                        break;
                    }
                    case 2: {
                        d3 = AICc.computeAicc(model3, this.options);
                    }
                }
                if (!(d3 < d)) continue;
                model2 = model3;
                d = d3;
            }
            if (model.getLnL() > 0.0 && d > d2) break;
            model = model2;
            d2 = d;
        }
        ModelTest.purgeModels();
        System.out.println("Global best model: " + model.getName());
        return "All Done";
    }

    @Override
    public void interruptThread() {
        super.interruptThread();
        ProcessManager.getInstance().killAll();
        this.threadPool.shutdownNow();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object != null) {
            ProgressInfo progressInfo = (ProgressInfo)object;
            if (progressInfo.getType() == 21) {
                this.interruptThread();
            } else {
                progressInfo.setHeuristicStage(this.currentStage);
                progressInfo.setNumModelsInStage(this.numModelsInStage);
            }
        }
        super.update(observable, object);
    }
}

