/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.exe.PhymlSingleModel;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PhymlParallelModel
extends Observable
implements Observer {
    private Runtime runtime = Runtime.getRuntime();
    private int maxNumberOfTasks;
    private List<PhymlSingleModel> estimatorList;
    private ExecutorService threadPool;
    private Collection<Callable<Object>> c = new ArrayList<Callable<Object>>();

    public PhymlParallelModel() {
        this(-1);
    }

    public PhymlParallelModel(int n) {
        if (n < 0) {
            n = this.runtime.availableProcessors();
        }
        this.maxNumberOfTasks = n;
        this.estimatorList = new ArrayList<PhymlSingleModel>(this.maxNumberOfTasks);
        this.threadPool = Executors.newFixedThreadPool(this.maxNumberOfTasks);
    }

    public boolean execute(PhymlSingleModel phymlSingleModel) {
        phymlSingleModel.addObserver(this);
        boolean bl = this.estimatorList.add(phymlSingleModel);
        this.c.add(Executors.callable(phymlSingleModel));
        this.threadPool.execute(phymlSingleModel);
        return bl;
    }

    protected void notifyObservers(int n, int n2, Model model, String string) {
        this.setChanged();
        this.notifyObservers(new ProgressInfo(n, n2, model, string));
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public boolean hasMoreTasks() {
        for (PhymlSingleModel phymlSingleModel : this.estimatorList) {
            if (phymlSingleModel.getModel().getTree() != null) continue;
            return true;
        }
        return false;
    }
}

