/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.ModelTest;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.model.ModelConstants;
import java.util.ArrayList;
import java.util.Arrays;

public class GuidedSearchManager {
    private static final int RATE_PAIRS = 15;
    private static final int RATES = 6;
    private static final double MIN_GAMMA_FILTER = 50.0;
    private static final double MAX_INV_FILTER = 0.1;
    private static final double MIN_GAMMA_INV_FILTER = 0.5;
    private static double GVALUE = 0.0;
    private static double Y0 = 4.0;
    private static double X1 = 150.0;
    private double guidedSearchThreshold;
    private Model gtrModel;
    private boolean doFilterFrequencies;
    private boolean doFilterRateMatrix;
    private boolean doFilterRateVariation;
    private boolean invFilter = false;
    private boolean gammaFilter = false;
    private boolean gammaInvFilter = false;
    private boolean freqsFilter = false;
    private boolean[] ratesFilter = new boolean[15];

    public GuidedSearchManager(double d, Model model, boolean bl, boolean bl2, boolean bl3) {
        this.guidedSearchThreshold = d;
        this.gtrModel = model;
        this.doFilterFrequencies = bl;
        this.doFilterRateMatrix = bl2;
        this.doFilterRateVariation = bl3;
        ModelTest.getMainConsole().println("[Heuristic search] Set up model filter...");
        model.print(ModelTest.getMainConsole());
        this.setUpFilter(this.guidedSearchThreshold, this.gtrModel);
    }

    public Model[] filterModels(Model[] modelArray) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (Model model : modelArray) {
            boolean bl = true;
            int n = 0;
            for (int i = 0; i < 5; ++i) {
                for (int j = i + 1; j < 6; ++j) {
                    if (GuidedSearchManager.checkRates(model.getPartition(), i, j) && this.ratesFilter[n]) {
                        bl = false;
                    }
                    ++n;
                }
            }
            if (!model.ispF()) {
                bl &= !this.freqsFilter;
            }
            if (model.ispI()) {
                bl = model.ispG() ? (bl &= !this.gammaInvFilter) : (bl &= !this.invFilter);
            } else if (model.ispG()) {
                bl &= !this.gammaFilter;
            }
            if (!bl) continue;
            arrayList.add(model);
        }
        if (arrayList.size() < modelArray.length) {
            ModelTest.getMainConsole().println("[Heuristic search] Candidate models set reduced to " + arrayList.size() + " models");
        } else {
            ModelTest.getMainConsole().println("[Heuristic search] Candidate models set is not reduced (" + arrayList.size() + " models)");
        }
        return arrayList.toArray(new Model[0]);
    }

    public static String[] getPartitions(String string, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n > 0 && n < 6) {
            boolean[] blArray = new boolean[]{GuidedSearchManager.checkRates(string, 0, 1), GuidedSearchManager.checkRates(string, 0, 2), GuidedSearchManager.checkRates(string, 0, 3), GuidedSearchManager.checkRates(string, 0, 4), GuidedSearchManager.checkRates(string, 0, 5), GuidedSearchManager.checkRates(string, 1, 2), GuidedSearchManager.checkRates(string, 1, 3), GuidedSearchManager.checkRates(string, 1, 4), GuidedSearchManager.checkRates(string, 1, 5), GuidedSearchManager.checkRates(string, 2, 3), GuidedSearchManager.checkRates(string, 2, 4), GuidedSearchManager.checkRates(string, 2, 5), GuidedSearchManager.checkRates(string, 3, 4), GuidedSearchManager.checkRates(string, 3, 5), GuidedSearchManager.checkRates(string, 4, 5)};
            for (String string2 : ModelConstants.fullModelSet.get(n)) {
                boolean bl = true;
                int n2 = 0;
                block1: for (int i = 0; i < 5; ++i) {
                    for (int j = i + 1; j < 6; ++j) {
                        if (blArray[n2] && !GuidedSearchManager.checkRates(string2, i, j)) {
                            bl = false;
                            continue block1;
                        }
                        ++n2;
                    }
                }
                if (!bl) continue;
                arrayList.add(string2);
            }
        } else {
            return new String[]{"012345"};
        }
        return arrayList.toArray(new String[0]);
    }

    public static Model[] getModelsSubset(Model[] modelArray, String string, int n) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (String string2 : GuidedSearchManager.getPartitions(string, n)) {
            for (Model model : modelArray) {
                if (!model.getPartition().equals(string2)) continue;
                arrayList.add(model);
            }
        }
        if (n < 6) {
            ModelTest.getMainConsole().println("[Clustering search] Obtain next step models from partition " + string + "...");
        }
        ModelTest.getMainConsole().println("[Clustering search] Step " + (7 - n) + "/6: " + arrayList.size() + " models.");
        return arrayList.toArray(new Model[0]);
    }

    private static boolean checkRates(String string, int n, int n2) {
        return string.charAt(n) == string.charAt(n2);
    }

    private void setUpFilter(double d, Model model) {
        int n;
        int n2;
        double d2 = GuidedSearchManager.adjustThreshold(d, model.getLnL());
        double d3 = (model.getRa() + model.getRb() + model.getRc() + model.getRd() + model.getRe() + model.getRf()) / 6.0;
        double d4 = (model.getRa() * model.getRa() + model.getRb() * model.getRb() + model.getRc() * model.getRc() + model.getRd() * model.getRd() + model.getRe() * model.getRe() + model.getRf() * model.getRf()) / 6.0 - d3 * d3;
        boolean bl = d4 > 1.0;
        double[] dArray = new double[]{(model.getRa() - d3) / d4, (model.getRb() - d3) / d4, (model.getRc() - d3) / d4, (model.getRd() - d3) / d4, (model.getRe() - d3) / d4, (model.getRf() - d3) / d4};
        double[] dArray2 = new double[15];
        int n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = n2 + 1; n < 6; ++n) {
                dArray2[n3] = GuidedSearchManager.computeRates(dArray[n2], dArray[n]);
                ++n3;
            }
        }
        if (this.doFilterFrequencies) {
            double[] dArray3 = new double[]{model.getfA(), model.getfC(), model.getfG(), model.getfT()};
            if (GuidedSearchManager.computeFreqs(dArray3) < 1.0 - d2) {
                ModelTest.getMainConsole().println("[Heuristic search] Filtering models with equal frequencies");
                this.freqsFilter = true;
            } else {
                this.freqsFilter = false;
            }
        } else {
            this.freqsFilter = false;
        }
        if (this.doFilterRateMatrix) {
            n2 = 0;
            for (n = 0; n < 15; ++n) {
                this.ratesFilter[n] = dArray2[n] > d2 && bl;
                n2 |= this.ratesFilter[n];
            }
            if (n2 != 0) {
                ModelTest.getMainConsole().println("[Heuristic search] Filtering models with certain equal rates");
            }
        }
        this.gammaFilter = this.doFilterRateVariation && model.getShape() > 50.0;
        this.invFilter = this.doFilterRateVariation && model.getPinv() < 0.1 && model.getShape() > 0.5;
        boolean bl2 = this.gammaInvFilter = this.doFilterRateVariation && model.getShape() > 50.0 && model.getPinv() < 0.1;
        if (this.invFilter) {
            ModelTest.getMainConsole().println("[Heuristic search] Filtering +I models");
        }
        if (this.gammaFilter) {
            ModelTest.getMainConsole().println("[Heuristic search] Filtering +G models");
        }
        if (this.gammaInvFilter) {
            ModelTest.getMainConsole().println("[Heuristic search] Filtering +I+G models");
        }
    }

    private static double computeRates(double d, double d2) {
        return Math.abs(d - d2);
    }

    private static double computeFreqs(double[] dArray) {
        Arrays.sort(dArray);
        return Math.abs(dArray[0] / dArray[3]);
    }

    private static double adjustThreshold(double d, double d2) {
        if (d2 > X1 * 1000.0) {
            return d;
        }
        return GuidedSearchManager.adjustThresholdLog(d, d2);
    }

    private static double adjustThresholdLog(double d, double d2) {
        double d3 = ((1.0 - Y0) * Math.log(GVALUE + d2 / 1000.0 + 1.0) + Y0 * Math.log(GVALUE + X1 + 1.0) - Math.log(GVALUE + 1.0)) / (Math.log(GVALUE + X1 + 1.0) - Math.log(GVALUE + 1.0));
        return d * d3;
    }
}

