/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.jmodeltest.exe;

import es.uvigo.darwin.jmodeltest.exe.RunPhymlMPJ;
import es.uvigo.darwin.jmodeltest.model.Model;
import es.uvigo.darwin.jmodeltest.observer.ProgressInfo;
import es.uvigo.darwin.jmodeltest.utilities.Utilities;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import javax.management.RuntimeErrorException;
import mpi.MPI;
import mpi.Request;
import mpi.Status;

public class Distributor
extends Observable
implements Runnable {
    public static final int TAG_SEND_REQUEST = 1;
    public static final int TAG_SEND_MODEL = 2;
    private List<Model> models;
    private RunPhymlMPJ caller;
    private int mpjMe;
    private int mpjSize;
    private int[] itemsPerProc;
    private int[] displs;

    public Distributor(List<Model> list, RunPhymlMPJ runPhymlMPJ, int n, int n2) {
        this.mpjMe = n;
        this.mpjSize = n2;
        this.models = list;
        this.caller = runPhymlMPJ;
        this.itemsPerProc = new int[n2];
        this.displs = new int[n2];
        Collections.sort(this.models, new ModelComparator());
    }

    public void distribute(List<Model> list) throws InterruptedException {
        int n;
        Status status;
        Status status2;
        Model[] modelArray;
        Request request;
        int n2 = 0;
        for (Model modelArray2 : list) {
            if (this.caller.rootModelRequest || this.mpjSize == 1) {
                while (!this.caller.rootModelRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new ProtTestInternalException("Thread interrupted");
                    }
                }
                if (this.caller.rootModel != null) {
                    this.notifyObservers(5, n2, this.caller.rootModel, Utilities.displayRuntime(this.caller.rootModel.getComputationTime()));
                }
                this.notifyObservers(4, n2, modelArray2, null);
                this.caller.rootModel = modelArray2;
                this.caller.rootModelRequest = false;
                int n3 = this.mpjMe;
                this.itemsPerProc[n3] = this.itemsPerProc[n3] + 1;
            } else {
                request = new Model[1];
                modelArray = MPI.COMM_WORLD.Irecv((Object)request, 0, 1, MPI.OBJECT, MPI.ANY_SOURCE, 1);
                status2 = new Status[]{modelArray2};
                status = modelArray.Wait();
                if (request[0] != null) {
                    int n4 = list.indexOf(request[0]);
                    this.notifyObservers(5, n2, (Model)request[0], Utilities.displayRuntime(request[0].getComputationTime()));
                    list.set(n4, (Model)request[0]);
                }
                Request request2 = MPI.COMM_WORLD.Isend((Object)status2, 0, 1, MPI.OBJECT, status.source, 2);
                this.notifyObservers(4, n2, modelArray2, null);
                int n5 = status.source;
                this.itemsPerProc[n5] = this.itemsPerProc[n5] + 1;
                request2.Wait();
            }
            ++n2;
        }
        this.displs[0] = 0;
        for (n = 1; n < this.mpjSize; ++n) {
            this.displs[n] = this.displs[n - 1] + this.itemsPerProc[n - 1];
        }
        for (n = 1; n < this.mpjSize; ++n) {
            Model[] modelArray2 = new Model[1];
            request = MPI.COMM_WORLD.Irecv((Object)modelArray2, 0, 1, MPI.OBJECT, MPI.ANY_SOURCE, 1);
            modelArray = new Model[]{null};
            status2 = request.Wait();
            if (modelArray2[0] != null) {
                int n6 = list.indexOf(modelArray2[0]);
                this.notifyObservers(5, n2, modelArray2[0], Utilities.displayRuntime(modelArray2[0].getComputationTime()));
                list.set(n6, modelArray2[0]);
            }
            status = MPI.COMM_WORLD.Isend((Object)modelArray, 0, 1, MPI.OBJECT, status2.source, 2);
            status.Wait();
        }
        while (!this.caller.rootModelRequest) {
            Thread.sleep(200L);
        }
        if (this.caller.rootModel != null) {
            this.notifyObservers(5, n2, this.caller.rootModel, Utilities.displayRuntime(this.caller.rootModel.getComputationTime()));
        }
        this.caller.rootModel = null;
        this.caller.rootModelRequest = false;
    }

    public int[] getItemsPerProc() {
        return this.itemsPerProc;
    }

    public int[] getDispls() {
        return this.displs;
    }

    @Override
    public void run() {
        try {
            this.distribute(this.models);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeErrorException(new Error(interruptedException));
        }
    }

    private void notifyObservers(int n, int n2, Model model, String string) {
        this.setChanged();
        this.notifyObservers(new ProgressInfo(n, n2, model, string));
    }

    private class ModelComparator
    implements Comparator<Model> {
        private ModelComparator() {
        }

        @Override
        public int compare(Model model, Model model2) {
            int n = 0;
            if (model != null && model2 != null) {
                n = this.getWeight(model2) - this.getWeight(model);
            }
            return n;
        }

        private int getWeight(Model model) {
            int n = 0;
            if (model.ispG()) {
                n += 4;
            }
            if (model.ispI()) {
                n += 2;
            }
            if (model.ispF()) {
                ++n;
            }
            return n;
        }
    }
}

