/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.algorithmics.GeneralObjectState;
import pal.algorithmics.ProbabilityIterator;
import pal.algorithmics.Ranker;
import pal.algorithmics.SearchEngine;
import pal.algorithmics.StoppingCriteria;
import pal.algorithmics.UndoableAction;
import pal.alignment.Alignment;
import pal.alignment.DataTranslator;
import pal.datatype.MolecularDataType;
import pal.eval.SimpleModelFastFourStateLHCalculator;
import pal.eval.SimpleMolecularClockLikelihoodModel;
import pal.math.ConjugateDirectionSearch;
import pal.math.MinimiserMonitor;
import pal.math.OrthogonalSearch;
import pal.substmodel.SubstitutionModel;
import pal.tree.Tree;
import pal.treesearch.GeneralLikelihoodSearcher;
import pal.treesearch.GlobalClockModel;
import pal.treesearch.SearchMonitor;
import pal.treesearch.UnrootedMLSearcher;
import pal.util.AlgorithmCallback;

public final class TreeSearchTool {
    public Tree basicUnrootedTreeMLSearch(Tree baseTree, Alignment a, SubstitutionModel sm, boolean optimiseModel) {
        return this.basicUnrootedTreeMLSearch(baseTree, a, sm, optimiseModel, AlgorithmCallback.Utils.getNullCallback());
    }

    public Tree basicUnrootedTreeMLSearch(Tree baseTree, Alignment a, SubstitutionModel sm, boolean optimiseModel, AlgorithmCallback callback) {
        UnrootedMLSearcher ut = new UnrootedMLSearcher(baseTree.getRoot(), a, sm, SimpleModelFastFourStateLHCalculator.getFactory());
        return TreeSearchTool.doBasicMLSearch(ut, optimiseModel, callback);
    }

    public Tree basicUnrootedTreeMLSearch(Alignment a, SubstitutionModel sm, boolean optimiseModel) {
        return this.basicUnrootedTreeMLSearch(a, sm, optimiseModel, AlgorithmCallback.Utils.getNullCallback());
    }

    public Tree basicUnrootedTreeMLSearch(Alignment a, SubstitutionModel sm, boolean optimiseModel, AlgorithmCallback callback) {
        UnrootedMLSearcher ut = new UnrootedMLSearcher(a, sm, SimpleModelFastFourStateLHCalculator.getFactory());
        return TreeSearchTool.doBasicMLSearch(ut, optimiseModel, callback);
    }

    public static final Tree optimiseUnrootedFixed(Tree tree, Alignment alignment, SubstitutionModel model, boolean optimiseModel) {
        return TreeSearchTool.optimiseUnrootedFixed(tree, alignment, model, optimiseModel, AlgorithmCallback.Utils.getNullCallback());
    }

    public static final Tree optimiseUnrootedFixed(Tree tree, Alignment alignment, SubstitutionModel model, boolean optimiseModel, AlgorithmCallback callback) {
        UnrootedMLSearcher ut = new UnrootedMLSearcher(tree, alignment, model);
        SearchEngine searcher = new SearchEngine(ProbabilityIterator.Utils.getHillClimb());
        Ranker r = new Ranker(1);
        UndoableAction action = optimiseModel ? UndoableAction.Utils.getCombined(new UndoableAction[]{ut.getBranchLengthOptimiseAction(StoppingCriteria.Utils.getIterationCount(2)), ut.getModelOptimiseAction(new OrthogonalSearch(), MinimiserMonitor.Utils.createSystemOuptutMonitor(), 6, 6)}) : ut.getBranchLengthOptimiseAction(StoppingCriteria.Utils.getIterationCount(1));
        GeneralObjectState gos = new GeneralObjectState(action, ut, true);
        searcher.run(callback, Double.NEGATIVE_INFINITY, gos, StoppingCriteria.Utils.getNonExactUnchangedScore(3, false, 1.0E-5), r);
        return ut.buildPALTree();
    }

    public static final Tree optimiseClockConstrainedFixed(Tree tree, Alignment alignment, SubstitutionModel model, boolean optimiseModel, AlgorithmCallback callback) {
        GeneralLikelihoodSearcher gls = new GeneralLikelihoodSearcher(tree.getRoot(), alignment, new GlobalClockModel(SimpleMolecularClockLikelihoodModel.createInstance(SimpleModelFastFourStateLHCalculator.getFactory(), model)));
        StoppingCriteria stopper = StoppingCriteria.Utils.getNonExactUnchangedScore(10, false, 1.0E-4).newInstance();
        if (optimiseModel) {
            gls.optimiseAllPlusSubstitutionModel(stopper, new ConjugateDirectionSearch(), new ConjugateDirectionSearch(), 6, 6, callback, SearchMonitor.Utils.createNullMonitor(), 3, MinimiserMonitor.Utils.createNullMonitor(), MinimiserMonitor.Utils.createNullMonitor());
        } else {
            gls.optimiseAllSimple(stopper, new ConjugateDirectionSearch(), 6, 6, callback, SearchMonitor.Utils.createNullMonitor(), MinimiserMonitor.Utils.createNullMonitor());
        }
        return gls.buildPALTreeES();
    }

    private static final Tree doBasicMLSearch(UnrootedMLSearcher ut, boolean optimiseModel, AlgorithmCallback callback) {
        double[] proportions;
        UndoableAction[] actions;
        SearchEngine searcher = new SearchEngine(ProbabilityIterator.Utils.getHillClimb());
        Ranker r = new Ranker(1);
        if (optimiseModel) {
            actions = new UndoableAction[]{ut.getNNIBranchLengthOptimiseAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getSPRAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getSweepSPRAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getBranchLengthOptimiseAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getModelOptimiseAction(new OrthogonalSearch(), MinimiserMonitor.Utils.createNullMonitor(), 5, 5)};
            proportions = new double[]{30.0, 20.0, 10.0, 10.0, 10.0};
        } else {
            actions = new UndoableAction[]{ut.getNNIBranchLengthOptimiseAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getSPRAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getSweepSPRAction(StoppingCriteria.Utils.getIterationCount(1)), ut.getBranchLengthOptimiseAction(StoppingCriteria.Utils.getIterationCount(1))};
            proportions = new double[]{30.0, 20.0, 20.0, 10.0};
        }
        GeneralObjectState gos = new GeneralObjectState(UndoableAction.Utils.getDistributedSelection(actions, proportions), ut, true);
        searcher.run(callback, Double.NEGATIVE_INFINITY, gos, StoppingCriteria.Utils.getNonExactUnchangedScore(10, false, 1.0E-4), r);
        return ut.buildPALTree();
    }

    public static final Alignment getMatchingDataType(Alignment alignment, SubstitutionModel model) {
        DataTranslator dt = new DataTranslator(alignment);
        return dt.toAlignment(MolecularDataType.Utils.getMolecularDataType(model.getDataType()), 0);
    }

    public static final double calculateLogLikelihood(Tree tree, Alignment alignment, SubstitutionModel model) {
        UnrootedMLSearcher uml = new UnrootedMLSearcher(tree, alignment, model);
        return uml.calculateLogLikelihood();
    }
}

