/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.NeoParameterized;
import pal.misc.SampleInformation;
import pal.treesearch.ConstraintModel;

public class SRDTGlobalClockModel
implements ConstraintModel,
ConstraintModel.GroupManager,
NeoParameterized,
MolecularClockLikelihoodModel.HeightConverter {
    private final SampleInformation sampleInformation_;
    private final MolecularClockLikelihoodModel.Instance likelihoodModel_;
    private final PrimaryParameters primaryParameters_;
    private final SecondaryParameters secondaryParameters_;
    private double rate_;
    private double upperRate_ = 1.0;
    private double metaRate_ = 1.0;
    private final boolean allowMetaRate_;
    private static final double RATE_LOWER_LIMIT = 0.0;
    private static final double RATE_UPPER_LIMIT = 10.0;
    private static final double[] DEFAULTS = new double[]{0.1, 1.0, 1.0};
    private final double maxLeafHeight_;

    public SRDTGlobalClockModel(SampleInformation sampleInformation, MolecularClockLikelihoodModel.Instance likelihoodModel) {
        this(sampleInformation, likelihoodModel, false);
    }

    public SRDTGlobalClockModel(SampleInformation sampleInformation, MolecularClockLikelihoodModel.Instance likelihoodModel, boolean allowMetaRate) {
        this.sampleInformation_ = sampleInformation;
        this.maxLeafHeight_ = sampleInformation.getMaxHeight();
        this.likelihoodModel_ = likelihoodModel;
        this.primaryParameters_ = new PrimaryParameters();
        this.secondaryParameters_ = new SecondaryParameters();
        this.allowMetaRate_ = allowMetaRate;
    }

    public String getRateModelSummary() {
        return "Single Rate Dated Tips, rate = " + this.getSubstitutionRate();
    }

    public ConstraintModel.GroupManager getGlobalClockConstraintGrouping(String[] leafLabelSet) {
        return this;
    }

    public String[][] getCladeConstraints(String[] allLabelSet) {
        return new String[][]{allLabelSet};
    }

    public UnconstrainedLikelihoodModel.Leaf createNewFreeLeaf(int[] patternStateMatchup, int numberOfPatterns) {
        return null;
    }

    public UnconstrainedLikelihoodModel.External createNewFreeExternal() {
        return null;
    }

    public UnconstrainedLikelihoodModel.Internal createNewFreeInternal() {
        return null;
    }

    public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
        return this.likelihoodModel_.createAppropriateConditionalProbabilityStore(isForLeaf);
    }

    public double getSubstitutionRate() {
        return this.rate_;
    }

    public void setSubstitutionRate(double rate) {
        this.upperRate_ /= this.metaRate_;
        this.rate_ = rate;
        this.metaRate_ = 1.0;
    }

    private final void setBaseRate(double value) {
        this.rate_ = this.allowMetaRate_ ? value * this.metaRate_ : value;
    }

    private final void setBaseUpperRate(double value) {
        this.upperRate_ = this.allowMetaRate_ ? value * this.metaRate_ : value;
    }

    private final double getBaseRate() {
        return this.allowMetaRate_ ? this.rate_ / this.metaRate_ : this.rate_;
    }

    private final double getBaseUpperRate() {
        return this.allowMetaRate_ ? this.upperRate_ / this.metaRate_ : this.upperRate_;
    }

    private final void setMetaRate(double value) {
        if (!this.allowMetaRate_) {
            throw new RuntimeException("Assertion error : should be calling meta rate stuff as meta rate not allowed");
        }
        this.rate_ = this.getBaseRate() * value;
        this.upperRate_ = this.getBaseUpperRate() * value;
        this.metaRate_ = value;
    }

    private final void setBaseUpperRateAndMetaRate(double upperValue, double metaValue) {
        if (!this.allowMetaRate_) {
            throw new RuntimeException("Assertion error : should be calling meta rate stuff as meta rate not allowed");
        }
        this.rate_ = this.getBaseRate() * metaValue;
        this.upperRate_ = upperValue * metaValue;
        this.metaRate_ = metaValue;
    }

    private final double getMetaRate() {
        if (!this.allowMetaRate_) {
            throw new RuntimeException("Assertion error : should be calling meta rate stuff as meta rate not allowed");
        }
        return this.metaRate_;
    }

    public NeoParameterized getGlobalParameterAccess() {
        return this.likelihoodModel_.getParameterAccess();
    }

    public double getLeafBaseHeight(String leafLabel) {
        return this.sampleInformation_.getHeight(this.sampleInformation_.getSampleOrdinal(leafLabel));
    }

    public double getBaseHeight(double originalExpectSubstitutionHeight) {
        double esMaxLeafHeight = this.maxLeafHeight_ * this.rate_;
        if (originalExpectSubstitutionHeight < esMaxLeafHeight) {
            return originalExpectSubstitutionHeight / this.rate_;
        }
        return this.maxLeafHeight_ + (originalExpectSubstitutionHeight - esMaxLeafHeight) / this.upperRate_;
    }

    public int getBaseHeightUnits() {
        return this.sampleInformation_.getHeightUnits();
    }

    public void initialiseParameters(String[] leafNames, double[] leafHeights) {
        double rateTotal = 0.0;
        int count = 0;
        int i = 0;
        while (i < leafNames.length) {
            int sample = this.sampleInformation_.getSampleOrdinal(leafNames[i]);
            double sampleHeight = this.sampleInformation_.getHeight(sample);
            if (sampleHeight > 0.0) {
                double rate = leafHeights[i] / sampleHeight;
                rateTotal += rate;
                ++count;
            }
            ++i;
        }
        this.rate_ = count == 0 ? 0.0 : Math.min(1.0, rateTotal / (double)count);
        this.upperRate_ = this.rate_;
        this.metaRate_ = 1.0;
        System.out.println("Inferered rate:" + this.rate_);
    }

    public NeoParameterized getAllGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getPrimaryGroupRelatedParameterAccess() {
        return this.primaryParameters_;
    }

    public NeoParameterized getSecondaryGroupRelatedParameterAccess() {
        return this.secondaryParameters_;
    }

    public MolecularClockLikelihoodModel.Leaf createNewClockLeaf(PatternInfo pattern, int[] patternStateMatchup) {
        return this.likelihoodModel_.createNewLeaf(this, pattern, patternStateMatchup);
    }

    public MolecularClockLikelihoodModel.External createNewClockExternal() {
        return this.likelihoodModel_.createNewExternal(this);
    }

    public MolecularClockLikelihoodModel.Internal createNewClockInternal() {
        return this.likelihoodModel_.createNewInternal(this);
    }

    public double getExpectedSubstitutionHeight(double baseHeight) {
        if (baseHeight > this.maxLeafHeight_) {
            return this.maxLeafHeight_ * this.rate_ + (baseHeight - this.maxLeafHeight_) * this.upperRate_;
        }
        return baseHeight * this.rate_;
    }

    public double getExpectedSubstitutionDistance(double lowerBaseHeight, double upperBaseHeight) {
        if (upperBaseHeight < this.maxLeafHeight_) {
            return (upperBaseHeight - lowerBaseHeight) * this.rate_;
        }
        if (lowerBaseHeight > this.maxLeafHeight_) {
            return (upperBaseHeight - lowerBaseHeight) * this.upperRate_;
        }
        return this.getExpectedSubstitutionHeight(upperBaseHeight) - this.getExpectedSubstitutionHeight(lowerBaseHeight);
    }

    public int getNumberOfParameters() {
        return this.allowMetaRate_ ? 3 : 2;
    }

    public void setParameters(double[] parameters, int startIndex) {
        if (this.allowMetaRate_) {
            this.metaRate_ = parameters[2 + startIndex];
            this.rate_ = parameters[startIndex] * this.metaRate_;
            this.upperRate_ = parameters[1 + startIndex] * this.metaRate_;
        } else {
            this.rate_ = parameters[startIndex];
            this.upperRate_ = parameters[1 + startIndex];
        }
    }

    public void getParameters(double[] store, int startIndex) {
        if (this.allowMetaRate_) {
            store[startIndex] = this.rate_ / this.metaRate_;
            store[1 + startIndex] = this.upperRate_ / this.metaRate_;
            store[2 + startIndex] = this.metaRate_;
        } else {
            store[startIndex] = this.rate_;
            store[1 + startIndex] = this.upperRate_;
        }
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return 10.0;
    }

    public void getDefaultValues(double[] store, int startIndex) {
        System.arraycopy(DEFAULTS, 0, store, startIndex, this.allowMetaRate_ ? 3 : 2);
    }

    private final class SecondaryParameters
    implements NeoParameterized {
        private SecondaryParameters() {
        }

        public int getNumberOfParameters() {
            return SRDTGlobalClockModel.this.allowMetaRate_ ? 2 : 1;
        }

        public void setParameters(double[] parameters, int startIndex) {
            if (SRDTGlobalClockModel.this.allowMetaRate_) {
                SRDTGlobalClockModel.this.setBaseUpperRateAndMetaRate(parameters[startIndex], parameters[startIndex + 1]);
            } else {
                SRDTGlobalClockModel.this.setBaseUpperRate(parameters[startIndex]);
            }
        }

        public void getParameters(double[] parameterStore, int startIndex) {
            parameterStore[startIndex] = SRDTGlobalClockModel.this.getBaseUpperRate();
            if (SRDTGlobalClockModel.this.allowMetaRate_) {
                parameterStore[startIndex + 1] = SRDTGlobalClockModel.this.getMetaRate();
            }
        }

        public double getLowerLimit(int n) {
            return 0.0;
        }

        public double getUpperLimit(int n) {
            return 10.0;
        }

        public void getDefaultValues(double[] store, int startIndex) {
            store[startIndex] = 1.0;
            if (SRDTGlobalClockModel.this.allowMetaRate_) {
                store[startIndex + 1] = 1.0;
            }
        }
    }

    private final class PrimaryParameters
    implements NeoParameterized {
        private PrimaryParameters() {
        }

        public int getNumberOfParameters() {
            return 1;
        }

        public void setParameters(double[] parameters, int startIndex) {
            SRDTGlobalClockModel.this.setBaseRate(parameters[startIndex]);
        }

        public void getParameters(double[] parameterStore, int startIndex) {
            parameterStore[startIndex] = SRDTGlobalClockModel.this.getBaseRate();
        }

        public double getLowerLimit(int n) {
            return 0.0;
        }

        public double getUpperLimit(int n) {
            return 10.0;
        }

        public void getDefaultValues(double[] store, int startIndex) {
            store[startIndex] = 0.1;
        }
    }
}

