/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.math.MathUtils;
import pal.math.UnivariateFunction;
import pal.math.UnivariateMinimum;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.treesearch.AbstractParentableConstrainedNode;
import pal.treesearch.ConstrainedNode;
import pal.treesearch.ConstraintModel;
import pal.treesearch.FreeBranch;
import pal.treesearch.FreeNode;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.GeneralOptimisable;
import pal.treesearch.GroupLeader;
import pal.treesearch.ParentableConstrainedNode;
import pal.treesearch.RootAccess;

public class PivotNode
extends AbstractParentableConstrainedNode
implements GeneralOptimisable,
ParentableConstrainedNode,
FreeNode,
RootAccess,
GroupLeader {
    private FreeBranch freeConnection_;
    private final UnconstrainedLikelihoodModel.Internal freeInternal_;
    private final GeneralConstraintGroupManager constraintGroupManager_;
    private final PatternInfo leftAscendedentPattern_;
    private boolean leftAscendentPatternValid_;
    private final PatternInfo rightAscendedentPattern_;
    private boolean rightAscendentPatternValid_;
    private final NonRootOptimisationHandler nonRootOptimistaionHandler_;
    private final RootOptimisationHandler rootOptimistaionHandler_;
    private final RootSubTreeShiftOptimisationHandler subTreeShiftOptimisationHandler_;
    private final RootPartialSubTreeShiftOptimisationHandler partialSubTreeShiftOptimisationHandler_;
    private final OptimisationHandler optimistaionHandler_;

    public PivotNode(Node tree, FreeBranch parentConnection, GeneralConstructionTool tool, GeneralConstraintGroupManager constraintGroupManager, GeneralConstraintGroupManager.Store store) {
        super(tree, tool, store, constraintGroupManager);
        this.freeConnection_ = parentConnection;
        this.freeInternal_ = parentConnection != null ? tool.allocateNewFreeInternalCalculator() : null;
        this.constraintGroupManager_ = constraintGroupManager;
        this.leftAscendedentPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.leftAscendentPatternValid_ = false;
        this.rightAscendedentPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.rightAscendentPatternValid_ = false;
        if (this.freeConnection_ == null) {
            this.nonRootOptimistaionHandler_ = null;
            this.rootOptimistaionHandler_ = new RootOptimisationHandler(tool, this.getConstrainedInternal());
            this.optimistaionHandler_ = this.rootOptimistaionHandler_;
            this.partialSubTreeShiftOptimisationHandler_ = new RootPartialSubTreeShiftOptimisationHandler(tool, this.getConstrainedInternal());
            this.subTreeShiftOptimisationHandler_ = new RootSubTreeShiftOptimisationHandler(tool, this.getConstrainedInternal());
        } else {
            this.nonRootOptimistaionHandler_ = new NonRootOptimisationHandler(tool, this.getConstrainedInternal());
            this.rootOptimistaionHandler_ = null;
            this.optimistaionHandler_ = this.nonRootOptimistaionHandler_;
            this.partialSubTreeShiftOptimisationHandler_ = null;
            this.subTreeShiftOptimisationHandler_ = null;
        }
        this.recursivelySetChildrenParentPivot(this);
        this.constraintGroupManager_.addGroupLeader(this);
    }

    public void postSetupNotify(ConstraintModel.GroupManager groupConstraints) {
        this.setupInternalNodeHeights(groupConstraints);
    }

    public PivotNode(Node subTree, GeneralConstructionTool tool, GeneralConstraintGroupManager groupManager, GeneralConstraintGroupManager.Store store) {
        this(subTree, null, tool, groupManager, store);
    }

    public Node buildPALNodeBase() {
        Node n = this.buildDescendentPALNodeBase();
        NodeUtils.heights2Lengths(n);
        if (this.freeConnection_ != null) {
            Node free = this.freeConnection_.buildPALNodeBase(this);
            free.setBranchLength(this.freeConnection_.getBranchLength());
            n.addChild(free);
            NodeUtils.lengths2Heights(free);
        }
        return n;
    }

    public Node buildPALNodeES() {
        Node n = this.buildDescendentPALNodeES(this.constraintGroupManager_.getRelatedGroup());
        NodeUtils.heights2Lengths(n);
        if (this.freeConnection_ != null) {
            Node free = this.freeConnection_.buildPALNodeES(this);
            free.setBranchLength(this.freeConnection_.getBranchLength());
            n.addChild(free);
            NodeUtils.lengths2Heights(free);
        }
        return n;
    }

    public String toString() {
        return this.toStringLengths(this.getNodeHeight());
    }

    public ConditionalProbabilityStore getAscendentExtended(double baseHeight, ConstrainedNode childCaller, GeneralConstructionTool tool, boolean allowCaching) {
        double height = this.getNodeHeight();
        if (this.isLeftChild(childCaller)) {
            ConditionalProbabilityStore right = this.getRightDescendentExtendedConditionals(tool, allowCaching);
            if (this.freeConnection_ == null) {
                this.obtainConstrainedExternalCalculator().calculateSingleAscendentExtendedConditionalsDirect(height, baseHeight, this.getAscendentPatternInfo(childCaller, tool), right);
                return right;
            }
            ConditionalProbabilityStore top = this.freeConnection_.getExtendedConditionalProbabilities(this, tool);
            return this.getConstrainedInternal().calculateAscendentExtendedConditionals(height, baseHeight, this.getAscendentPatternInfo(childCaller, tool), top, right);
        }
        ConditionalProbabilityStore left = this.getLeftDescendentExtendedConditionals(tool, allowCaching);
        if (this.freeConnection_ == null) {
            this.obtainConstrainedExternalCalculator().calculateSingleAscendentExtendedConditionalsDirect(height, baseHeight, this.getAscendentPatternInfo(childCaller, tool), left);
            return left;
        }
        ConditionalProbabilityStore top = this.freeConnection_.getExtendedConditionalProbabilities(this, tool);
        return this.getConstrainedInternal().calculateAscendentExtendedConditionals(height, baseHeight, this.getAscendentPatternInfo(childCaller, tool), top, left);
    }

    public ConditionalProbabilityStore getAscendentFlat(ConstrainedNode childCaller, GeneralConstructionTool tool, boolean allowCaching) {
        if (this.isLeftChild(childCaller)) {
            ConditionalProbabilityStore right = this.getRightDescendentExtendedConditionals(tool, allowCaching);
            if (this.freeConnection_ == null) {
                return right;
            }
            ConditionalProbabilityStore top = this.freeConnection_.getExtendedConditionalProbabilities(this, tool);
            return this.freeInternal_.calculateFlat(this.getAscendentPatternInfo(childCaller, tool), top, right);
        }
        ConditionalProbabilityStore left = this.getLeftDescendentExtendedConditionals(tool, allowCaching);
        if (this.freeConnection_ == null) {
            return left;
        }
        ConditionalProbabilityStore top = this.freeConnection_.getExtendedConditionalProbabilities(this, tool);
        return this.freeInternal_.calculateFlat(this.getAscendentPatternInfo(childCaller, tool), top, left);
    }

    public PatternInfo getAscendentPatternInfo(ConstrainedNode childCaller, GeneralConstructionTool tool) {
        if (this.isLeftChild(childCaller)) {
            if (this.freeConnection_ == null) {
                return this.getRightChildPatternInfo(tool);
            }
            if (!this.leftAscendentPatternValid_) {
                tool.build(this.leftAscendedentPattern_, this.freeConnection_.getPatternInfo(tool, this), this.getRightChildPatternInfo(tool));
                this.leftAscendentPatternValid_ = true;
            }
            return this.leftAscendedentPattern_;
        }
        if (this.freeConnection_ == null) {
            return this.getLeftChildPatternInfo(tool);
        }
        if (!this.rightAscendentPatternValid_) {
            tool.build(this.rightAscendedentPattern_, this.freeConnection_.getPatternInfo(tool, this), this.getLeftChildPatternInfo(tool));
            this.rightAscendentPatternValid_ = true;
        }
        return this.rightAscendedentPattern_;
    }

    public double calculateLogLikelihood(GeneralConstructionTool tool) {
        if (this.freeConnection_ == null) {
            return this.getDescendentLogLikelihood(tool, false);
        }
        return this.freeConnection_.calculateLogLikelihood(tool);
    }

    private final void checkCaller(FreeBranch caller) {
        if (caller != this.freeConnection_) {
            throw new RuntimeException("Assertion error : caller is not free connection!");
        }
    }

    public PatternInfo getPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        this.checkCaller(caller);
        return this.getDescendentPatternInfo(tool);
    }

    public boolean hasConnection(FreeBranch c, FreeBranch caller) {
        this.checkCaller(caller);
        return c == this.freeConnection_;
    }

    public FreeBranch getLeftBranch(FreeBranch caller) {
        this.checkCaller(caller);
        return null;
    }

    public FreeBranch getRightBranch(FreeBranch caller) {
        this.checkCaller(caller);
        return null;
    }

    public void getAllComponents(ArrayList store, Class componentType, FreeBranch caller) {
        this.checkCaller(caller);
        this.getSubTreeComponents(store, componentType);
    }

    public void testLikelihood(FreeBranch caller, GeneralConstructionTool tool) {
        this.checkCaller(caller);
        this.testLikelihood(tool);
    }

    public void testLikelihood(GeneralConstructionTool tool) {
        System.out.println("Test1 (Pivot)" + this.calculateLogLikelihood(tool));
        this.getLeftChild().testLikelihood(tool);
        this.getRightChild().testLikelihood(tool);
    }

    public PatternInfo getLeftPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        return this.getLeftChildPatternInfo(tool);
    }

    public PatternInfo getRightPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        return this.getRightChildPatternInfo(tool);
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, FreeBranch caller, GeneralConstructionTool tool) {
        this.checkCaller(caller);
        throw new RuntimeException("Finish me!");
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, FreeBranch caller, UnconstrainedLikelihoodModel.External external, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        this.checkCaller(caller);
        throw new RuntimeException("Finish me!");
    }

    public FreeBranch extract(FreeBranch caller) {
        this.checkCaller(caller);
        return null;
    }

    public Node buildPALNodeES(double branchLength_, FreeBranch caller) {
        this.checkCaller(caller);
        throw new RuntimeException("Finish me!");
    }

    public Node buildPALNodeBase(double branchLength_, FreeBranch caller) {
        this.checkCaller(caller);
        throw new RuntimeException("Finish me!");
    }

    public ConditionalProbabilityStore getFlatConditionalProbabilities(FreeBranch caller, GeneralConstructionTool tool) {
        this.checkCaller(caller);
        throw new RuntimeException("Finish me!");
    }

    public String toString(FreeBranch caller) {
        this.checkCaller(caller);
        throw new RuntimeException("Finish me!");
    }

    public void setConnectingBranches(FreeBranch[] store, int number) {
        if (number != 1) {
            throw new IllegalArgumentException("Invalid number of branches, must be 1");
        }
        this.freeConnection_ = store[0];
    }

    public boolean hasDirectConnection(FreeBranch query) {
        return query == query;
    }

    public void swapConnection(FreeBranch original, FreeBranch newConnection) {
        if (original != this.freeConnection_) {
            throw new IllegalArgumentException("Unknown original node!");
        }
        this.freeConnection_ = newConnection;
    }

    public void swapConnection(FreeBranch original, FreeNode nodeToReplace, FreeBranch newConnection) {
        throw new RuntimeException("Finish me!");
    }

    public void getNonSubTreeComponents(ArrayList store, Class componentType) {
        if (this.freeConnection_ != null) {
            this.freeConnection_.getAllComponents(store, componentType, this);
        }
    }

    public int getNumberOfOptimisationTypes() {
        return this.freeConnection_ == null ? 3 : 1;
    }

    public double optimise(int optimisationType, UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        switch (optimisationType) {
            case 0: {
                return this.optimiseLocalShift(minimiser, tool, fracDigits);
            }
            case 1: {
                return this.optimisePartialSubTreeShift(minimiser, tool, fracDigits);
            }
        }
        return this.optimiseSubTreeShift(minimiser, tool, fracDigits);
    }

    private final double optimiseSubTreeShift(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        double minOffset = this.getMinimumLeafChildSeperation();
        double baseHeight = this.getNodeHeight();
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        this.subTreeShiftOptimisationHandler_.setup(this.getLeftChild(), this.getRightChild(), this.getDescendentPatternInfo(tool), baseHeight, -minOffset, 100.0 - minOffset, this.obtainConstrainedExternalCalculator(), fracDigits);
        this.subTreeShiftOptimisationHandler_.optimise(minimiser);
        this.recursivelyAdjustNodeHeight(this.subTreeShiftOptimisationHandler_);
        return this.subTreeShiftOptimisationHandler_.getLogLikelihood();
    }

    private final double optimisePartialSubTreeShift(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        double minOffset = this.getMinimumLeafChildSeperation();
        double baseHeight = this.getNodeHeight();
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        this.partialSubTreeShiftOptimisationHandler_.setup(this.getLeftChild(), this.getRightChild(), this.getDescendentPatternInfo(tool), baseHeight, -minOffset, baseHeight * 2.0 + 100.0 - minOffset, this.obtainConstrainedExternalCalculator(), fracDigits);
        this.partialSubTreeShiftOptimisationHandler_.optimise(minimiser);
        this.recursivelyAdjustNodeHeight(this.partialSubTreeShiftOptimisationHandler_);
        return this.partialSubTreeShiftOptimisationHandler_.getLogLikelihood();
    }

    private final double optimiseLocalShift(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        double maxChildHeight = this.getMaxChildHeight();
        ConditionalProbabilityStore leftDescendentBaseExtended = this.getLeftDescendentExtendedConditionals(maxChildHeight, tool, false);
        ConditionalProbabilityStore rightDescendentBaseExtended = this.getRightDescendentExtendedConditionals(maxChildHeight, tool, false);
        MolecularClockLikelihoodModel.External external = this.obtainConstrainedExternalCalculator();
        double height = this.getNodeHeight();
        if (this.freeConnection_ == null) {
            this.rootOptimistaionHandler_.setup(leftDescendentBaseExtended, rightDescendentBaseExtended, this.getDescendentPatternInfo(tool), height, maxChildHeight, this.obtainConstrainedExternalCalculator(), fracDigits);
        } else {
            ConditionalProbabilityStore parentFlat = this.freeConnection_.getExtendedConditionalProbabilities(this, tool);
            this.nonRootOptimistaionHandler_.setup(parentFlat, this.freeConnection_.getPatternInfo(tool, this), leftDescendentBaseExtended, rightDescendentBaseExtended, this.getDescendentPatternInfo(tool), height, maxChildHeight, this.obtainConstrainedExternalCalculator(), fracDigits);
        }
        this.optimistaionHandler_.optimise(minimiser);
        double heightDifference = this.optimistaionHandler_.getHeight() - height;
        this.setNodeHeight(this.optimistaionHandler_.getHeight());
        return this.optimistaionHandler_.getLogLikelihood();
    }

    private final class RootPartialSubTreeShiftOptimisationHandler
    implements UnivariateFunction,
    ConstrainedNode.HeightAdjustment {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private PatternInfo descendentPattern_;
        private ConstrainedNode leftChild_;
        private ConstrainedNode rightChild_;
        private double baseHeight_;
        private double offset_;
        private double minimumOffset_;
        private double maximumOffset_;
        private int fracDigits_;
        private ConstrainedNode[] affectedNodes_;
        private int numberOfAffectedNodes_ = 0;

        public RootPartialSubTreeShiftOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public double getAdjustedHeight(Object relatedNode, double baseHeightToAdjust) {
            int i = 0;
            while (i < this.numberOfAffectedNodes_) {
                if (relatedNode == this.affectedNodes_[i]) {
                    return baseHeightToAdjust + this.offset_;
                }
                ++i;
            }
            return baseHeightToAdjust;
        }

        public int getNumberOfAffected() {
            return this.numberOfAffectedNodes_;
        }

        public void addMultification(ConstrainedNode base) {
            this.addAffectedNode(base);
            ConstrainedNode left = base.getLeftChild();
            ConstrainedNode right = base.getRightChild();
            double baseHeight = base.getNodeHeight();
            if (left != null) {
                if (baseHeight - left.getNodeHeight() < 1.0E-6) {
                    this.addMultification(left);
                }
                if (baseHeight - right.getNodeHeight() < 1.0E-6) {
                    this.addMultification(right);
                }
            }
        }

        public double getMinimumAffectedChildDistance() {
            double distance = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < this.numberOfAffectedNodes_) {
                distance = Math.min(distance, this.affectedNodes_[i].getMinimumDirectChildDistance());
                ++i;
            }
            return distance;
        }

        public void resetAffectedNodes() {
            this.numberOfAffectedNodes_ = 0;
        }

        public void addAffectedNode(ConstrainedNode node) {
            if (this.affectedNodes_ == null) {
                this.affectedNodes_ = new ConstrainedNode[10];
            } else if (this.numberOfAffectedNodes_ == this.affectedNodes_.length) {
                ConstrainedNode[] newAffected = new ConstrainedNode[this.numberOfAffectedNodes_ + 5];
                System.arraycopy(this.affectedNodes_, 0, newAffected, 0, this.numberOfAffectedNodes_);
                this.affectedNodes_ = newAffected;
            }
            this.affectedNodes_[this.numberOfAffectedNodes_++] = node;
        }

        public void setup(ConstrainedNode leftChild, ConstrainedNode rightChild, PatternInfo descendentPattern, double baseHeight, double minimumOffset, double maximumOffset, MolecularClockLikelihoodModel.External external, int fracDigits) {
            this.baseHeight_ = baseHeight;
            this.descendentPattern_ = descendentPattern;
            this.leftChild_ = leftChild;
            this.rightChild_ = rightChild;
            this.minimumOffset_ = minimumOffset;
            this.maximumOffset_ = maximumOffset;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.offset_ = 0.0;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(0.0, this, this.fracDigits_);
            this.offset_ = MathUtils.ensureBounded(minimiser.minx, this.minimumOffset_, this.maximumOffset_);
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.baseHeight_ + this.offset_;
        }

        public double getOffset() {
            return this.offset_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double offset) {
            this.offset_ = offset;
            double adjustedHeight = this.baseHeight_ + offset;
            ConditionalProbabilityStore left = this.leftChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            ConditionalProbabilityStore right = this.rightChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            double result = -this.external_.calculateLogLikelihood(adjustedHeight, this.descendentPattern_, left, right);
            return result;
        }

        public double getLowerBound() {
            return this.minimumOffset_;
        }

        public double getUpperBound() {
            return this.maximumOffset_;
        }
    }

    private static final class RootSubTreeShiftOptimisationHandler
    implements UnivariateFunction,
    ConstrainedNode.HeightAdjustment {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private PatternInfo descendentPattern_;
        private ConstrainedNode leftChild_;
        private ConstrainedNode rightChild_;
        private double baseHeight_;
        private double offset_;
        private double minimumOffset_;
        private double maximumOffset_;
        private int fracDigits_;

        public RootSubTreeShiftOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public double getAdjustedHeight(Object relatedNode, double baseHeightToAdjust) {
            return baseHeightToAdjust + this.offset_;
        }

        public void setup(ConstrainedNode leftChild, ConstrainedNode rightChild, PatternInfo descendentPattern, double baseHeight, double minimumOffset, double maximumOffset, MolecularClockLikelihoodModel.External external, int fracDigits) {
            this.baseHeight_ = baseHeight;
            this.descendentPattern_ = descendentPattern;
            this.leftChild_ = leftChild;
            this.rightChild_ = rightChild;
            this.minimumOffset_ = minimumOffset;
            this.maximumOffset_ = maximumOffset;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.offset_ = 0.0;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(0.0, this, this.fracDigits_);
            this.offset_ = MathUtils.ensureBounded(minimiser.minx, this.minimumOffset_, this.maximumOffset_);
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.baseHeight_ + this.offset_;
        }

        public double getOffset() {
            return this.offset_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double offset) {
            this.offset_ = offset;
            double adjustedHeight = this.baseHeight_ + offset;
            ConditionalProbabilityStore left = this.leftChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            ConditionalProbabilityStore right = this.rightChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, this.tool_, this, false);
            double result = -this.external_.calculateLogLikelihood(adjustedHeight, this.descendentPattern_, left, right);
            return result;
        }

        public double getLowerBound() {
            return this.minimumOffset_;
        }

        public double getUpperBound() {
            return this.maximumOffset_;
        }
    }

    private static final class RootOptimisationHandler
    implements UnivariateFunction,
    OptimisationHandler {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private double height_;
        private ConditionalProbabilityStore leftBaseExtended_;
        private ConditionalProbabilityStore rightBaseExtended_;
        private PatternInfo descendentPattern_;
        private double maxChildHeight_;
        private double maxHeight_;
        private double baseHeight_;
        private int fracDigits_;

        public RootOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public void setup(ConditionalProbabilityStore leftBaseExtended, ConditionalProbabilityStore rightBaseExtended, PatternInfo descendentPattern, double startingHeight, double maxChildHeight, MolecularClockLikelihoodModel.External external, int fracDigits) {
            this.height_ = startingHeight;
            this.leftBaseExtended_ = leftBaseExtended;
            this.rightBaseExtended_ = rightBaseExtended;
            this.descendentPattern_ = descendentPattern;
            this.baseHeight_ = startingHeight;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.maxChildHeight_ = maxChildHeight;
            this.maxHeight_ = this.maxChildHeight_ + 100.0;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(this.height_, this, this.fracDigits_);
            this.height_ = minimiser.minx;
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.height_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double height) {
            ConditionalProbabilityStore descendentExtended = this.internal_.calculatePostExtendedFlatConditionals(height, this.maxChildHeight_, this.descendentPattern_, this.leftBaseExtended_, this.rightBaseExtended_);
            double result = -this.external_.calculateLogLikelihoodSingle(height, this.descendentPattern_, descendentExtended);
            return result;
        }

        public double getLowerBound() {
            return this.maxChildHeight_;
        }

        public double getUpperBound() {
            return this.maxHeight_;
        }
    }

    private static final class NonRootOptimisationHandler
    implements UnivariateFunction,
    OptimisationHandler {
        private final GeneralConstructionTool tool_;
        private final MolecularClockLikelihoodModel.Internal internal_;
        private MolecularClockLikelihoodModel.External external_;
        private double logLikelihood_;
        private double height_;
        private ConditionalProbabilityStore ascendentFlat_;
        private ConditionalProbabilityStore leftBaseExtended_;
        private ConditionalProbabilityStore rightBaseExtended_;
        private PatternInfo descendentPattern_;
        private PatternInfo ascendentPattern_;
        private PatternInfo centerPattern_;
        private double maxChildHeight_;
        private double maxHeight_;
        private int fracDigits_;

        public NonRootOptimisationHandler(GeneralConstructionTool tool, MolecularClockLikelihoodModel.Internal internal) {
            this.tool_ = tool;
            this.internal_ = internal;
        }

        public void setup(ConditionalProbabilityStore ascendentFlat, PatternInfo ascendentPattern, ConditionalProbabilityStore leftBaseExtended, ConditionalProbabilityStore rightBaseExtended, PatternInfo descendentPattern, double startingHeight, double maxChildHeight, MolecularClockLikelihoodModel.External external, int fracDigits) {
            this.height_ = startingHeight;
            this.ascendentFlat_ = ascendentFlat;
            this.ascendentPattern_ = ascendentPattern;
            this.leftBaseExtended_ = leftBaseExtended;
            this.rightBaseExtended_ = rightBaseExtended;
            this.descendentPattern_ = descendentPattern;
            this.external_ = external;
            this.fracDigits_ = fracDigits;
            this.maxChildHeight_ = maxChildHeight;
            this.maxHeight_ = this.maxChildHeight_ + maxChildHeight * 2.0 + 100.0;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(this.height_, this, this.fracDigits_);
            this.height_ = minimiser.minx;
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double getHeight() {
            return this.height_;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double evaluate(double height) {
            ConditionalProbabilityStore descendentExtended = this.internal_.calculatePostExtendedFlatConditionals(height, this.maxChildHeight_, this.descendentPattern_, this.leftBaseExtended_, this.rightBaseExtended_);
            double result = -this.external_.calculateLogLikelihoodNonRoot(height, this.centerPattern_, this.ascendentFlat_, descendentExtended);
            return result;
        }

        public double getLowerBound() {
            return this.maxChildHeight_;
        }

        public double getUpperBound() {
            return this.maxHeight_;
        }
    }

    private static interface OptimisationHandler {
        public double getHeight();

        public double getLogLikelihood();

        public void optimise(UnivariateMinimum var1);
    }
}

