/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.NeoParameterized;
import pal.misc.SampleInformation;
import pal.misc.Utils;
import pal.treesearch.ConstraintModel;

public class MRDTGlobalClockModel
implements ConstraintModel,
ConstraintModel.GroupManager,
NeoParameterized,
MolecularClockLikelihoodModel.HeightConverter {
    private final SampleInformation sampleInformation_;
    private final MolecularClockLikelihoodModel.Instance likelihoodModel_;
    private final double[] rateChangeTimes_;
    private final double[] rateChangeIntervalSizes_;
    private final double[] heightTotals_;
    private final double[] rates_;
    private static final double RATE_LOWER_LIMIT = 0.0;
    private static final double RATE_UPPER_LIMIT = 1.0;
    private final double[] defaults_;
    private final double maxLeafHeight_;
    private final int numberOfBaseRates_;

    public MRDTGlobalClockModel(SampleInformation sampleInformation, MolecularClockLikelihoodModel.Instance likelihoodModel) {
        this(sampleInformation, likelihoodModel, MRDTGlobalClockModel.createSimpleTimes(sampleInformation));
    }

    public MRDTGlobalClockModel(SampleInformation sampleInformation, MolecularClockLikelihoodModel.Instance likelihoodModel, double[] rateChangeTimes) {
        this.sampleInformation_ = sampleInformation;
        this.rateChangeTimes_ = Utils.getCopy(rateChangeTimes);
        this.numberOfBaseRates_ = rateChangeTimes.length;
        this.rateChangeIntervalSizes_ = new double[this.numberOfBaseRates_];
        this.heightTotals_ = new double[this.numberOfBaseRates_];
        this.rates_ = new double[this.numberOfBaseRates_ + 1];
        this.defaults_ = new double[this.numberOfBaseRates_ + 1];
        double lastTime = 0.0;
        int i = 0;
        while (i < this.numberOfBaseRates_) {
            this.rateChangeIntervalSizes_[i] = rateChangeTimes[i] - lastTime;
            lastTime = rateChangeTimes[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.defaults_.length) {
            this.defaults_[i2] = 0.1;
            ++i2;
        }
        this.maxLeafHeight_ = sampleInformation.getMaxHeight();
        this.likelihoodModel_ = likelihoodModel;
    }

    private static final double[] createSimpleTimes(SampleInformation si) {
        int numberOfBaseRates = si.getNumberOfSamples() - 1;
        double[] rateChangeTimes = new double[numberOfBaseRates];
        int i = 0;
        while (i < numberOfBaseRates) {
            rateChangeTimes[i] = si.getHeight(i + 1);
            ++i;
        }
        return rateChangeTimes;
    }

    public String getRateModelSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append("Multiple Rates Dated Tips");
        sb.append("<UL>");
        int i = 0;
        while (i < this.rateChangeTimes_.length) {
            sb.append("<LI>");
            sb.append(i == 0 ? 0.0 : this.rateChangeTimes_[i - 1]);
            sb.append(" - ");
            sb.append(this.rateChangeTimes_[i]);
            sb.append(" : ");
            sb.append(this.rates_[i]);
            sb.append("</LI>");
            ++i;
        }
        sb.append("<LI>");
        sb.append(this.rateChangeTimes_[this.rateChangeTimes_.length - 1]);
        sb.append(" - INFINITY");
        sb.append(" : ");
        sb.append(this.rates_[this.rateChangeTimes_.length]);
        sb.append(" (not meaningful if rate change times match sampling times!) ");
        sb.append("</LI>");
        sb.append("</UL>");
        return sb.toString();
    }

    public ConstraintModel.GroupManager getGlobalClockConstraintGrouping(String[] leafLabelSet) {
        return this;
    }

    public String[][] getCladeConstraints(String[] allLabelSet) {
        return new String[][]{allLabelSet};
    }

    public UnconstrainedLikelihoodModel.Leaf createNewFreeLeaf(int[] patternStateMatchup, int numberOfPatterns) {
        return null;
    }

    public UnconstrainedLikelihoodModel.External createNewFreeExternal() {
        return null;
    }

    public UnconstrainedLikelihoodModel.Internal createNewFreeInternal() {
        return null;
    }

    public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
        return this.likelihoodModel_.createAppropriateConditionalProbabilityStore(isForLeaf);
    }

    public NeoParameterized getGlobalParameterAccess() {
        return this.likelihoodModel_.getParameterAccess();
    }

    public double getLeafBaseHeight(String leafLabel) {
        return this.sampleInformation_.getHeight(this.sampleInformation_.getSampleOrdinal(leafLabel));
    }

    public double getBaseHeight(double originalExpectSubstitutionHeight) {
        double total = 0.0;
        int i = 0;
        while (i < this.rateChangeIntervalSizes_.length) {
            double next = total + this.rates_[i] * this.rateChangeIntervalSizes_[i];
            if (originalExpectSubstitutionHeight < next) {
                return (originalExpectSubstitutionHeight - total) / this.rates_[i] + this.rateChangeTimes_[i];
            }
            total = next;
            ++i;
        }
        return (originalExpectSubstitutionHeight - total) / this.rates_[this.numberOfBaseRates_] + this.maxLeafHeight_;
    }

    public int getBaseHeightUnits() {
        return this.sampleInformation_.getHeightUnits();
    }

    public void initialiseParameters(String[] leafNames, double[] leafHeights) {
        double rateTotal = 0.0;
        int count = 0;
        int i = 0;
        while (i < leafNames.length) {
            int sample = this.sampleInformation_.getSampleOrdinal(leafNames[i]);
            double sampleHeight = this.sampleInformation_.getHeight(sample);
            if (sampleHeight > 0.0) {
                double rate = leafHeights[i] / sampleHeight;
                rateTotal += rate;
                ++count;
            }
            ++i;
        }
        double intervalRate = count == 0 ? 0.0 : Math.min(1.0, rateTotal / (double)count);
        if (intervalRate <= 1.0E-11) {
            intervalRate = 1.0E-4;
        }
        int i2 = 0;
        while (i2 < this.rates_.length) {
            this.rates_[i2] = intervalRate;
            ++i2;
        }
        this.updateHeightTotals();
    }

    public NeoParameterized getAllGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getPrimaryGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getSecondaryGroupRelatedParameterAccess() {
        return null;
    }

    public MolecularClockLikelihoodModel.Leaf createNewClockLeaf(PatternInfo pattern, int[] patternStateMatchup) {
        return this.likelihoodModel_.createNewLeaf(this, pattern, patternStateMatchup);
    }

    public MolecularClockLikelihoodModel.External createNewClockExternal() {
        return this.likelihoodModel_.createNewExternal(this);
    }

    public MolecularClockLikelihoodModel.Internal createNewClockInternal() {
        return this.likelihoodModel_.createNewInternal(this);
    }

    public double getExpectedSubstitutionHeight(double baseHeight) {
        int rate = this.rateChangeTimes_.length;
        int i = 0;
        while (i < this.rateChangeTimes_.length) {
            if (baseHeight < this.rateChangeTimes_[i]) {
                rate = i;
                break;
            }
            ++i;
        }
        if (rate == 0) {
            return baseHeight * this.rates_[0];
        }
        return (baseHeight - this.rateChangeTimes_[rate - 1]) * this.rates_[rate] + this.heightTotals_[rate - 1];
    }

    public double getExpectedSubstitutionDistance(double lowerBaseHeight, double upperBaseHeight) {
        return this.getExpectedSubstitutionHeight(upperBaseHeight) - this.getExpectedSubstitutionHeight(lowerBaseHeight);
    }

    public int getNumberOfParameters() {
        return this.rates_.length;
    }

    public void setParameters(double[] parameters, int startIndex) {
        System.arraycopy(parameters, startIndex, this.rates_, 0, this.rates_.length);
        this.updateHeightTotals();
    }

    private final void updateHeightTotals() {
        double total = 0.0;
        int i = 0;
        while (i < this.numberOfBaseRates_) {
            this.heightTotals_[i] = total += this.rateChangeIntervalSizes_[i] * this.rates_[i];
            ++i;
        }
    }

    public void getParameters(double[] store, int startIndex) {
        System.arraycopy(this.rates_, 0, store, startIndex, this.rates_.length);
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return 1.0;
    }

    public void getDefaultValues(double[] store, int startIndex) {
        System.arraycopy(this.defaults_, 0, store, startIndex, this.defaults_.length);
    }
}

