/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.NeoParameterized;
import pal.treesearch.ConstraintModel;

public class GlobalClockModel
implements ConstraintModel,
ConstraintModel.GroupManager,
MolecularClockLikelihoodModel.HeightConverter,
NeoParameterized {
    private final MolecularClockLikelihoodModel.Instance likelihoodModel_;
    private double rate_;
    private static final double[] DEFAULTS = new double[]{1.0};
    private final boolean includeScaling_ = true;

    public GlobalClockModel(MolecularClockLikelihoodModel.Instance likelihoodModel) {
        this.likelihoodModel_ = likelihoodModel;
    }

    public String getRateModelSummary() {
        return "Molecular clock assumed (Single Rate model)";
    }

    public ConstraintModel.GroupManager getGlobalClockConstraintGrouping(String[] leafLabelSet) {
        return this;
    }

    public String[][] getCladeConstraints(String[] allLabelSet) {
        return new String[][]{allLabelSet};
    }

    public UnconstrainedLikelihoodModel.Leaf createNewFreeLeaf(int[] patternStateMatchup, int numberOfPatterns) {
        return null;
    }

    public UnconstrainedLikelihoodModel.External createNewFreeExternal() {
        return null;
    }

    public UnconstrainedLikelihoodModel.Internal createNewFreeInternal() {
        return null;
    }

    public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
        return this.likelihoodModel_.createAppropriateConditionalProbabilityStore(isForLeaf);
    }

    public NeoParameterized getGlobalParameterAccess() {
        return this.likelihoodModel_.getParameterAccess();
    }

    public double getLeafBaseHeight(String leafLabel) {
        return 0.0;
    }

    public double getBaseHeight(double originalExpectSubstitutionHeight) {
        return originalExpectSubstitutionHeight / this.rate_;
    }

    public int getBaseHeightUnits() {
        return 0;
    }

    public void initialiseParameters(String[] leafNames, double[] leafHeights) {
        this.rate_ = 1.0;
    }

    public NeoParameterized getAllGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getPrimaryGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getSecondaryGroupRelatedParameterAccess() {
        return null;
    }

    public MolecularClockLikelihoodModel.Leaf createNewClockLeaf(PatternInfo pattern, int[] patternStateMatchup) {
        return this.likelihoodModel_.createNewLeaf(this, pattern, patternStateMatchup);
    }

    public MolecularClockLikelihoodModel.External createNewClockExternal() {
        return this.likelihoodModel_.createNewExternal(this);
    }

    public MolecularClockLikelihoodModel.Internal createNewClockInternal() {
        return this.likelihoodModel_.createNewInternal(this);
    }

    public double getExpectedSubstitutionHeight(double baseHeight) {
        return this.rate_ * baseHeight;
    }

    public double getExpectedSubstitutionDistance(double lowerBaseHeight, double upperBaseHeight) {
        return (upperBaseHeight - lowerBaseHeight) * this.rate_;
    }

    public int getNumberOfParameters() {
        return 1;
    }

    public void setParameters(double[] parameters, int startIndex) {
        this.rate_ = parameters[0 + startIndex];
    }

    public void getParameters(double[] store, int startIndex) {
        store[startIndex] = this.rate_;
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return 100.0;
    }

    public void getDefaultValues(double[] store, int startIndex) {
        System.arraycopy(DEFAULTS, 0, store, startIndex, DEFAULTS.length);
    }
}

