/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.algorithmics.StoppingCriteria;
import pal.alignment.Alignment;
import pal.math.MersenneTwisterFast;
import pal.math.MinimiserMonitor;
import pal.math.MultivariateFunction;
import pal.math.MultivariateMinimum;
import pal.math.OrthogonalHints;
import pal.math.UnivariateMinimum;
import pal.misc.NeoParameterized;
import pal.tree.Node;
import pal.tree.SimpleTree;
import pal.tree.Tree;
import pal.treesearch.ConstraintModel;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.GeneralOptimisable;
import pal.treesearch.RootAccess;
import pal.treesearch.SearchMonitor;
import pal.util.AlgorithmCallback;

public class GeneralLikelihoodSearcher {
    public static final int OPTIMISE_ALL = 0;
    public static final int OPTIMISE_PRIMARY = 1;
    public static final int OPTIMISE_SECONDARY = 2;
    public static final int NO_OPTIMISE = 3;
    private final ConstraintModel constraintModel_;
    private final RootAccess rootAccess_;
    private final GeneralConstraintGroupManager[] constraintGroupManagers_;
    private final GeneralConstructionTool tool_;
    private final ModelFunction modelFunction_;
    private final RootAccessScorer rootAccessScorer_;
    private final GeneralOptimiser generalOptimiser_;
    private static final boolean FREQUENT_SEARCH_UPDATES = true;
    static /* synthetic */ Class class$pal$treesearch$GeneralOptimisable;

    public GeneralLikelihoodSearcher(Node baseTopology, Alignment baseAlignment, ConstraintModel constraintModel) {
        this.constraintModel_ = constraintModel;
        this.tool_ = new GeneralConstructionTool(constraintModel, baseAlignment);
        GeneralConstraintGroupManager.Store store = new GeneralConstraintGroupManager.Store();
        this.rootAccess_ = this.tool_.createRootAccess(baseTopology, store);
        store.setupConstraintGroupManagers();
        this.constraintGroupManagers_ = store.getConstraintGroupManagers();
        NeoParameterized np = constraintModel.getGlobalParameterAccess();
        this.modelFunction_ = np != null && np.getNumberOfParameters() > 0 ? new ModelFunction(np, this.rootAccess_, this.tool_) : null;
        this.generalOptimiser_ = new GeneralOptimiser(this.tool_, this.rootAccess_);
        this.rootAccessScorer_ = new RootAccessScorer(this.rootAccess_, this.tool_);
    }

    public double optimiseGeneral(StoppingCriteria stopper, int fracDigits, AlgorithmCallback callback) {
        return this.optimiseGeneral(stopper, fracDigits, callback, null);
    }

    public double optimiseGeneral(StoppingCriteria stopper, int fracDigits, AlgorithmCallback callback, SearchMonitor monitor) {
        stopper.reset();
        double logLikelihood = 0.0;
        do {
            logLikelihood = this.generalOptimiser_.generalOptimiseRound(fracDigits, monitor);
            if (monitor != null) {
                monitor.searchStepComplete(logLikelihood);
            }
            callback.updateStatus("Round likelihood:" + logLikelihood);
            stopper.newIteration(logLikelihood, logLikelihood, true, true, callback);
        } while (!stopper.isTimeToStop() && !callback.isPleaseStop());
        return logLikelihood;
    }

    public double optimiseConstraintRateModels(MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor rateMonitor) {
        return this.optimiseConstraintRateModels(minimiser, fxFracDigits, xFracDigits, this.rootAccessScorer_, rateMonitor);
    }

    private double optimiseConstraintRateModels(MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, GeneralConstraintGroupManager.LikelihoodScoreAccess scoreAccess, MinimiserMonitor rateMonitor) {
        return this.optimiseConstraintRateModels(minimiser, fxFracDigits, xFracDigits, scoreAccess, rateMonitor, 0);
    }

    private double optimiseConstraintRateModels(MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, GeneralConstraintGroupManager.LikelihoodScoreAccess scoreAccess, MinimiserMonitor rateMonitor, int optimisationType) {
        double logLikelihood = 1.0;
        int i = 0;
        while (i < this.constraintGroupManagers_.length) {
            double l;
            switch (optimisationType) {
                case 0: {
                    l = this.constraintGroupManagers_[i].optimiseAllGlobalClockConstraints(minimiser, scoreAccess, fxFracDigits, xFracDigits, rateMonitor);
                    break;
                }
                case 1: {
                    l = this.constraintGroupManagers_[i].optimisePrimaryGlobalClockConstraints(minimiser, scoreAccess, fxFracDigits, xFracDigits, rateMonitor);
                    break;
                }
                case 2: {
                    l = this.constraintGroupManagers_[i].optimiseSecondaryGlobalClockConstraints(minimiser, scoreAccess, fxFracDigits, xFracDigits, rateMonitor);
                    break;
                }
                case 3: {
                    l = 1.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown optimisation type:" + optimisationType);
                }
            }
            if (l < 0.0) {
                logLikelihood = l;
            }
            ++i;
        }
        return logLikelihood;
    }

    private final boolean isAnyConstraingGroupOptimisable() {
        int i = 0;
        while (i < this.constraintGroupManagers_.length) {
            if (this.constraintGroupManagers_[i].isOptimisable()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double optimiseSubstitutionModels(MultivariateMinimum minimiser, int fxFracDigits, int xFracDigits, MinimiserMonitor monitor) {
        double logLikelihood = 1.0;
        if (this.modelFunction_ != null) {
            logLikelihood = -minimiser.findMinimum(this.modelFunction_, this.modelFunction_.getArgumentStore(), fxFracDigits, xFracDigits, monitor);
            this.modelFunction_.synchronizeModel();
        }
        return logLikelihood;
    }

    public double optimiseAllSimple(StoppingCriteria stopper, MultivariateMinimum rateMinimiser, int fxFracDigits, int xFracDigits, AlgorithmCallback callback) {
        return this.optimiseAllSimple(stopper, rateMinimiser, fxFracDigits, xFracDigits, callback, null, null);
    }

    public double optimiseAllSimple(StoppingCriteria stopper, MultivariateMinimum rateMinimiser, int fxFracDigits, int xFracDigits, AlgorithmCallback callback, SearchMonitor monitor, MinimiserMonitor rateMonitor) {
        return this.optimiseAllSimple(stopper, rateMinimiser, fxFracDigits, xFracDigits, callback, monitor, rateMonitor, 0);
    }

    public double optimiseAllSimple(StoppingCriteria stopper, MultivariateMinimum rateMinimiser, int fxFracDigits, int xFracDigits, AlgorithmCallback callback, SearchMonitor monitor, MinimiserMonitor rateMonitor, int groupOptimistionType) {
        boolean foundResult;
        stopper.reset();
        double logLikelihood = 0.0;
        do {
            foundResult = false;
            double roundValue = this.generalOptimiser_.generalOptimiseRound(fxFracDigits, monitor);
            callback.updateStatus("Round likelihood:" + roundValue);
            if (roundValue < 0.0) {
                logLikelihood = roundValue;
                foundResult = true;
                if (monitor != null) {
                    monitor.searchStepComplete(logLikelihood);
                }
            }
            if (this.constraintGroupManagers_.length > 0) {
                roundValue = this.optimiseConstraintRateModels(rateMinimiser, fxFracDigits, xFracDigits, this.rootAccessScorer_, rateMonitor, groupOptimistionType);
            }
            if (roundValue < 0.0) {
                logLikelihood = roundValue;
                foundResult = true;
                if (monitor != null) {
                    monitor.searchStepComplete(logLikelihood);
                }
            }
            stopper.newIteration(logLikelihood, logLikelihood, true, true, callback);
        } while (foundResult && !stopper.isTimeToStop());
        return logLikelihood;
    }

    public double optimiseAllSimpleHeirarchy(StoppingCriteria stopper, MultivariateMinimum rateMinimiser, int fxFracDigits, int xFracDigits, AlgorithmCallback callback, SearchMonitor monitor, MinimiserMonitor rateMonitor) {
        boolean foundResult;
        if (!this.isAnyConstraingGroupOptimisable()) {
            return this.optimiseGeneral(stopper, fxFracDigits, callback, monitor);
        }
        stopper.reset();
        double logLikelihood = 0.0;
        GeneralRoundScorer grs = new GeneralRoundScorer(this.generalOptimiser_, fxFracDigits, monitor);
        do {
            foundResult = false;
            double roundValue = this.optimiseConstraintRateModels(rateMinimiser, fxFracDigits, xFracDigits, grs, rateMonitor);
            if (!(roundValue < 0.0)) continue;
            logLikelihood = roundValue;
            foundResult = true;
            stopper.newIteration(logLikelihood, logLikelihood, true, true, callback);
            if (monitor == null) continue;
            monitor.searchStepComplete(logLikelihood);
        } while (foundResult && !stopper.isTimeToStop());
        return logLikelihood;
    }

    public double optimiseAllFullHeirarchy(StoppingCriteria mainStopper, StoppingCriteria subStopper, MultivariateMinimum rateMinimiser, int fxFracDigits, int xFracDigits, AlgorithmCallback callback, SearchMonitor monitor, MinimiserMonitor rateMonitor) {
        boolean foundResult;
        if (!this.isAnyConstraingGroupOptimisable()) {
            return this.optimiseGeneral(mainStopper, fxFracDigits, callback, monitor);
        }
        mainStopper.reset();
        double logLikelihood = 0.0;
        System.out.println("Optimising heirachy");
        FullGeneralRoundScorer grs = new FullGeneralRoundScorer(rateMinimiser, fxFracDigits, xFracDigits, monitor, subStopper, callback, rateMonitor, 2);
        do {
            if (callback.isPleaseStop()) {
                return 0.0;
            }
            foundResult = false;
            double roundValue = this.optimiseConstraintRateModels(rateMinimiser, fxFracDigits, xFracDigits, grs, rateMonitor, 1);
            if (!(roundValue < 0.0)) continue;
            logLikelihood = roundValue;
            foundResult = true;
            mainStopper.newIteration(logLikelihood, logLikelihood, true, true, callback);
            if (monitor == null) continue;
            monitor.searchStepComplete(logLikelihood);
        } while (foundResult && !mainStopper.isTimeToStop() && !callback.isPleaseStop());
        return logLikelihood;
    }

    public double optimiseAllPlusSubstitutionModel(StoppingCriteria stopper, MultivariateMinimum rateMinimiser, MultivariateMinimum substitutionModelMinimiser, int fxFracDigits, int xFracDigits, AlgorithmCallback callback, SearchMonitor monitor, int substitutionModelOptimiseFrequency, MinimiserMonitor substitutionModelMonitor, MinimiserMonitor rateMonitor) {
        boolean foundResult;
        stopper.reset();
        double logLikelihood = 0.0;
        int substitutionModelCount = substitutionModelOptimiseFrequency;
        boolean justOptimisedModel = false;
        do {
            foundResult = false;
            double roundValue = this.generalOptimiser_.generalOptimiseRound(fxFracDigits, monitor);
            callback.updateStatus("Round likelihood:" + roundValue);
            if (roundValue < 0.0) {
                logLikelihood = roundValue;
                foundResult = true;
                if (monitor != null) {
                    monitor.searchStepComplete(logLikelihood);
                }
            }
            if ((roundValue = this.optimiseConstraintRateModels(rateMinimiser, fxFracDigits, xFracDigits, rateMonitor)) < 0.0) {
                logLikelihood = roundValue;
                foundResult = true;
                if (monitor != null) {
                    monitor.searchStepComplete(logLikelihood);
                }
            }
            if (substitutionModelCount == 0) {
                roundValue = this.optimiseSubstitutionModels(substitutionModelMinimiser, fxFracDigits, xFracDigits, substitutionModelMonitor);
                if (roundValue < 0.0) {
                    logLikelihood = roundValue;
                    foundResult = true;
                }
                justOptimisedModel = true;
                substitutionModelCount = substitutionModelOptimiseFrequency;
            } else {
                substitutionModelCount = stopper.isTimeToStop() ? 0 : --substitutionModelCount;
                justOptimisedModel = false;
            }
            stopper.newIteration(logLikelihood, logLikelihood, true, true, callback);
        } while (foundResult && !callback.isPleaseStop() && (!stopper.isTimeToStop() || !justOptimisedModel));
        return logLikelihood;
    }

    public Node buildPALNodeBase() {
        return this.rootAccess_.buildPALNodeBase();
    }

    public Tree buildPALTreeBase() {
        SimpleTree st = new SimpleTree(this.rootAccess_.buildPALNodeBase());
        st.setUnits(0);
        return st;
    }

    public Node buildPALNodeES() {
        return this.rootAccess_.buildPALNodeES();
    }

    public Tree buildPALTreeES() {
        SimpleTree st = new SimpleTree(this.rootAccess_.buildPALNodeES());
        st.setUnits(0);
        return st;
    }

    public double calculatedLogLikelihood() {
        return this.rootAccess_.calculateLogLikelihood(this.tool_);
    }

    public void testLikelihood() {
        this.rootAccess_.testLikelihood(this.tool_);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class FullGeneralRoundScorer
    implements GeneralConstraintGroupManager.LikelihoodScoreAccess {
        private final int fxFracDigits_;
        private final int xFracDigits_;
        private final SearchMonitor monitor_;
        private final StoppingCriteria stopper_;
        private final AlgorithmCallback callback_;
        private final int groupOptimisationType_;
        private final MultivariateMinimum rateMinimiser_;
        private final MinimiserMonitor rateMonitor_;

        public FullGeneralRoundScorer(MultivariateMinimum rateMinimiser, int fxFracDigits, int xFracDigits, SearchMonitor monitor, StoppingCriteria stopper, AlgorithmCallback callback, MinimiserMonitor rateMonitor, int groupOptimisationType) {
            this.stopper_ = stopper;
            this.callback_ = callback;
            this.xFracDigits_ = xFracDigits;
            this.fxFracDigits_ = fxFracDigits;
            this.rateMonitor_ = rateMonitor;
            this.rateMinimiser_ = rateMinimiser;
            this.monitor_ = monitor;
            this.groupOptimisationType_ = groupOptimisationType;
        }

        public double calculateLikelihoodScore() {
            return GeneralLikelihoodSearcher.this.optimiseAllSimple(this.stopper_, this.rateMinimiser_, this.fxFracDigits_, this.xFracDigits_, this.callback_, this.monitor_, this.rateMonitor_, this.groupOptimisationType_);
        }
    }

    private static final class GeneralRoundScorer
    implements GeneralConstraintGroupManager.LikelihoodScoreAccess {
        private final GeneralOptimiser optimisation_;
        private final int fracDigits_;
        private final SearchMonitor monitor_;

        public GeneralRoundScorer(GeneralOptimiser optimisation, int fracDigits, SearchMonitor monitor) {
            this.optimisation_ = optimisation;
            this.fracDigits_ = fracDigits;
            this.monitor_ = monitor;
        }

        public double calculateLikelihoodScore() {
            return this.optimisation_.generalOptimiseRound(this.fracDigits_, this.monitor_);
        }
    }

    private static final class RootAccessScorer
    implements GeneralConstraintGroupManager.LikelihoodScoreAccess {
        private final RootAccess rootAccess_;
        private final GeneralConstructionTool tool_;

        public RootAccessScorer(RootAccess rootAccess, GeneralConstructionTool tool) {
            this.rootAccess_ = rootAccess;
            this.tool_ = tool;
        }

        public double calculateLikelihoodScore() {
            return this.rootAccess_.calculateLogLikelihood(this.tool_);
        }
    }

    private final class GeneralOptimiser {
        private final OptimisationHandler[] optimisations_;
        private final MersenneTwisterFast random_;
        private final UnivariateMinimum minimiser_;
        private final GeneralConstructionTool tool_;

        public GeneralOptimiser(GeneralConstructionTool tool, RootAccess rootAccess) {
            ArrayList<OptimisationHandler> al = new ArrayList<OptimisationHandler>();
            rootAccess.getAllComponents(al, class$pal$treesearch$GeneralOptimisable == null ? (class$pal$treesearch$GeneralOptimisable = GeneralLikelihoodSearcher.class$("pal.treesearch.GeneralOptimisable")) : class$pal$treesearch$GeneralOptimisable);
            GeneralOptimisable[] generalOptimisables = new GeneralOptimisable[al.size()];
            al.toArray(generalOptimisables);
            al.clear();
            int i = 0;
            while (i < generalOptimisables.length) {
                int numberOfTypes = generalOptimisables[i].getNumberOfOptimisationTypes();
                int j = 0;
                while (j < numberOfTypes) {
                    al.add(new OptimisationHandler(generalOptimisables[i], j));
                    ++j;
                }
                ++i;
            }
            this.optimisations_ = new OptimisationHandler[al.size()];
            al.toArray(this.optimisations_);
            this.random_ = new MersenneTwisterFast();
            this.tool_ = tool;
            this.minimiser_ = new UnivariateMinimum();
        }

        public boolean isHasOptimisations() {
            return this.optimisations_.length > 0;
        }

        public double generalOptimiseRound(int fracDigits, SearchMonitor searchMonitor) {
            this.random_.shuffle(this.optimisations_);
            double logLikelihood = 1.0;
            int i = 0;
            while (i < this.optimisations_.length) {
                double l = this.optimisations_[i].optimise(this.minimiser_, this.tool_, fracDigits);
                if (l < 0.0) {
                    logLikelihood = l;
                    if (searchMonitor != null) {
                        searchMonitor.searchStepComplete(logLikelihood);
                    }
                }
                ++i;
            }
            return logLikelihood;
        }

        private final class OptimisationHandler {
            private final GeneralOptimisable baseOptimisation_;
            private final int optimisationType_;

            public OptimisationHandler(GeneralOptimisable baseOptimisation, int optimisationType) {
                this.baseOptimisation_ = baseOptimisation;
                this.optimisationType_ = optimisationType;
            }

            public double optimise(UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
                return this.baseOptimisation_.optimise(this.optimisationType_, minimiser, tool, fracDigits);
            }

            public String toString() {
                return "(" + this.optimisationType_ + ", " + this.baseOptimisation_ + ")";
            }
        }
    }

    private static final class ModelFunction
    implements MultivariateFunction {
        private final NeoParameterized parameters_;
        private final RootAccess rootAccess_;
        private final GeneralConstructionTool tool_;
        private final double[] argumentStore_;

        public ModelFunction(NeoParameterized parameters, RootAccess rootAccess, GeneralConstructionTool tool) {
            this.parameters_ = parameters;
            this.rootAccess_ = rootAccess;
            this.tool_ = tool;
            this.argumentStore_ = new double[parameters.getNumberOfParameters()];
        }

        public double[] getArgumentStore() {
            this.parameters_.getParameters(this.argumentStore_, 0);
            return this.argumentStore_;
        }

        public void synchronizeModel() {
            this.parameters_.setParameters(this.argumentStore_, 0);
        }

        public double evaluate(double[] argument) {
            this.parameters_.setParameters(argument, 0);
            return -this.rootAccess_.calculateLogLikelihood(this.tool_);
        }

        public int getNumArguments() {
            return this.parameters_.getNumberOfParameters();
        }

        public double getLowerBound(int n) {
            return this.parameters_.getLowerLimit(n);
        }

        public double getUpperBound(int n) {
            return this.parameters_.getUpperLimit(n);
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }
    }
}

