/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.treesearch.AbstractLeafNode;
import pal.treesearch.FreeBranch;
import pal.treesearch.FreeNode;
import pal.treesearch.GeneralConstructionTool;

public class FreeLeafNode
extends AbstractLeafNode
implements FreeNode {
    private FreeBranch parentFreeBranch_ = null;
    private FreeBranch markedParentFreeBranch_ = null;
    private final UnconstrainedLikelihoodModel.Leaf leafCalculator_;

    public FreeLeafNode(FreeBranch parentBranch, String id, GeneralConstructionTool tool) {
        super(id, tool);
        this.parentFreeBranch_ = parentBranch;
        this.leafCalculator_ = this.createNewFreeLeafCalculator(tool);
    }

    public boolean hasDirectConnection(FreeBranch fb) {
        return this.parentFreeBranch_ == fb;
    }

    public void mark() {
        this.markedParentFreeBranch_ = this.parentFreeBranch_;
    }

    public void undoToMark() {
        this.parentFreeBranch_ = this.markedParentFreeBranch_;
    }

    public boolean hasConnection(FreeBranch fb, FreeBranch caller) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown caller!");
        }
        return this.parentFreeBranch_ == fb;
    }

    public FreeBranch extract(FreeBranch caller) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown caller!");
        }
        return null;
    }

    public ConditionalProbabilityStore getLeftExtendedConditionalProbabilities(FreeBranch caller, UnconstrainedLikelihoodModel.External externalCalculator, ConditionalProbabilityStore resultStore) {
        throw new RuntimeException("Assertion error : Not applicable for leaf nodes!");
    }

    public ConditionalProbabilityStore getRightExtendedConditionalProbabilities(FreeBranch caller, UnconstrainedLikelihoodModel.External externalCalculator, ConditionalProbabilityStore resultStore) {
        throw new RuntimeException("Assertion error : Not applicable for leaf nodes!");
    }

    public PatternInfo getLeftPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        return null;
    }

    public PatternInfo getRightPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        return null;
    }

    public void setConnectingBranches(FreeBranch[] store, int number) {
        if (number != 1) {
            throw new IllegalArgumentException("Must be one connection not:" + number);
        }
        this.parentFreeBranch_ = store[0];
    }

    public void testLikelihood(FreeBranch caller, GeneralConstructionTool tool) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown caller!");
        }
    }

    public void swapConnection(FreeBranch original, FreeBranch newConnection) {
        if (original != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown original");
        }
        this.parentFreeBranch_ = newConnection;
    }

    public void swapConnection(FreeBranch original, FreeNode nodeToReplace, FreeBranch newConnection) {
        this.swapConnection(original, newConnection);
        newConnection.swapNode(nodeToReplace, this);
        original.swapNode(this, nodeToReplace);
    }

    public FreeBranch getLeftBranch(FreeBranch caller) {
        return null;
    }

    public FreeBranch getRightBranch(FreeBranch caller) {
        return null;
    }

    public void getAllConnections(ArrayList store, FreeBranch caller) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown caller!");
        }
    }

    public PatternInfo getPatternInfo(GeneralConstructionTool tool, FreeBranch caller) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown caller!");
        }
        return this.getPatternInfo();
    }

    public void rebuildConnectionPatterns(GeneralConstructionTool tool, FreeBranch caller) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown caller!");
        }
    }

    public int redirectRebuildPattern(GeneralConstructionTool tool) {
        return this.getNumberOfPatterns();
    }

    public final ConditionalProbabilityStore getFlatConditionalProbabilities(FreeBranch callingBranch, UnconstrainedLikelihoodModel.External external, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        if (callingBranch != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown calling connection");
        }
        return this.leafCalculator_.getFlatConditionalProbabilities();
    }

    public final ConditionalProbabilityStore getFlatConditionalProbabilities(FreeBranch caller, GeneralConstructionTool tool) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown calling connection");
        }
        return this.leafCalculator_.getFlatConditionalProbabilities();
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, FreeBranch callingBranch, UnconstrainedLikelihoodModel.External external, ConditionalProbabilityStore resultStore, GeneralConstructionTool tool) {
        if (callingBranch != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown calling connection");
        }
        return this.leafCalculator_.getExtendedConditionalProbabilities(distance);
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(double distance, FreeBranch callingBranch, GeneralConstructionTool tool) {
        if (callingBranch != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown calling connection");
        }
        return this.leafCalculator_.getExtendedConditionalProbabilities(distance);
    }

    public final Node buildPALNode(double branchLength, FreeBranch caller) {
        if (caller != this.parentFreeBranch_) {
            throw new IllegalArgumentException("Unknown calling connection");
        }
        return NodeFactory.createNodeBranchLength(branchLength, new Identifier(this.getLabel()));
    }

    public final Node buildPALNodeES(double branchLength, FreeBranch caller) {
        return this.buildPALNode(branchLength, caller);
    }

    public final Node buildPALNodeBase(double branchLength, FreeBranch caller) {
        return this.buildPALNode(branchLength, caller);
    }

    public String toString(FreeBranch caller) {
        return this.getLabel();
    }

    public void getAllComponents(ArrayList store, Class componentType, FreeBranch caller) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
        if (caller != this.parentFreeBranch_) {
            throw new RuntimeException("Assertion error : unexpected caller");
        }
    }

    public final void getAllComponents(ArrayList store, Class componentType) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
        this.parentFreeBranch_.getAllComponents(store, componentType, this);
    }
}

