/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.PatternInfo;
import pal.eval.SiteDetails;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.math.MersenneTwisterFast;
import pal.math.UnivariateFunction;
import pal.math.UnivariateMinimum;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.tree.NodeUtils;
import pal.treesearch.FreeNode;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.GeneralOptimisable;
import pal.treesearch.RootAccess;

public final class FreeBranch
implements RootAccess,
GeneralOptimisable {
    private FreeNode leftNode_;
    private FreeNode rightNode_;
    private double branchLength_;
    private final PatternInfo centerPattern_;
    private boolean centerPatternValid_;
    private final OptimisationHandler optimisationHandler_;
    private final int index_;
    private FreeNode markLeftNode_ = null;
    private FreeNode markRightNode_ = null;
    private double markBranchLength_;
    private Object annotation_ = null;

    public FreeBranch(Node n, GeneralConstructionTool tool, GeneralConstraintGroupManager.Store store) {
        if (n.getChildCount() != 2) {
            throw new IllegalArgumentException("Base tree must be bificating");
        }
        this.index_ = tool.allocateNextConnectionIndex();
        Node l = n.getChild(0);
        Node r = n.getChild(1);
        this.branchLength_ = l.getBranchLength() + r.getBranchLength();
        this.leftNode_ = tool.createFreeNode(l, this, store);
        this.rightNode_ = tool.createFreeNode(r, this, store);
        this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.centerPatternValid_ = false;
        this.optimisationHandler_ = new OptimisationHandler(tool);
    }

    public FreeBranch(Node n, FreeNode parent, GeneralConstructionTool tool, GeneralConstraintGroupManager.Store store) {
        this.index_ = tool.allocateNextConnectionIndex();
        this.branchLength_ = n.getBranchLength();
        this.rightNode_ = parent;
        this.leftNode_ = tool.createFreeNode(n, this, store);
        this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.centerPatternValid_ = false;
        this.optimisationHandler_ = new OptimisationHandler(tool);
    }

    public FreeBranch(FreeNode left, FreeNode right, double branchLength, GeneralConstructionTool tool) {
        this.index_ = tool.allocateNextConnectionIndex();
        this.branchLength_ = branchLength;
        this.rightNode_ = right;
        this.leftNode_ = left;
        this.centerPattern_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.centerPatternValid_ = false;
        this.optimisationHandler_ = new OptimisationHandler(tool);
    }

    public void setAnnotation(Object annotation) {
        this.annotation_ = annotation;
    }

    public final FreeNode getLeft() {
        return this.leftNode_;
    }

    public final FreeNode getRight() {
        return this.rightNode_;
    }

    public final void mark() {
        this.markBranchLength_ = this.branchLength_;
        this.markLeftNode_ = this.leftNode_;
        this.markRightNode_ = this.rightNode_;
    }

    public final PatternInfo getLeftPatternInfo(GeneralConstructionTool tool) {
        return this.leftNode_.getPatternInfo(tool, this);
    }

    public final PatternInfo getRightPatternInfo(GeneralConstructionTool tool) {
        return this.rightNode_.getPatternInfo(tool, this);
    }

    public final PatternInfo getPatternInfo(GeneralConstructionTool tool, FreeNode caller) {
        if (caller == this.leftNode_) {
            return this.rightNode_.getPatternInfo(tool, this);
        }
        if (caller == this.rightNode_) {
            return this.leftNode_.getPatternInfo(tool, this);
        }
        throw new IllegalArgumentException("Unknown caller!");
    }

    public final PatternInfo getCenterPatternInfo(GeneralConstructionTool tool) {
        if (!this.centerPatternValid_) {
            tool.build(this.centerPattern_, this.getLeftPatternInfo(tool), this.getRightPatternInfo(tool));
            this.centerPatternValid_ = true;
        }
        return this.centerPattern_;
    }

    public final void undoToMark() {
        if (this.markLeftNode_ == null) {
            throw new RuntimeException("Assertion error : undo to mark when no mark made");
        }
        this.branchLength_ = this.markBranchLength_;
        this.leftNode_ = this.markLeftNode_;
        this.rightNode_ = this.markRightNode_;
    }

    public String toString() {
        return "(" + this.leftNode_ + ", " + this.rightNode_ + ")";
    }

    public boolean hasConnection(FreeBranch c, FreeNode caller) {
        if (c == this) {
            return true;
        }
        if (caller == this.leftNode_) {
            return this.rightNode_.hasConnection(c, this);
        }
        if (caller == this.rightNode_) {
            return this.leftNode_.hasConnection(c, this);
        }
        throw new IllegalArgumentException("Unknown caller");
    }

    public FreeBranch getLeftLeftBranch() {
        return this.leftNode_.getLeftBranch(this);
    }

    public FreeBranch getLeftRightBranch() {
        return this.leftNode_.getRightBranch(this);
    }

    public FreeBranch getRightLeftBranch() {
        return this.rightNode_.getLeftBranch(this);
    }

    public FreeBranch getRightRightBranch() {
        return this.rightNode_.getRightBranch(this);
    }

    public FreeBranch attachTo(FreeBranch attachmentPoint, FreeBranch[] store) {
        FreeBranch reattachment;
        FreeNode used;
        FreeNode freeNode = used = this.leftNode_.hasConnection(attachmentPoint, this) ? this.leftNode_ : this.rightNode_;
        if (used.hasDirectConnection(attachmentPoint)) {
            return null;
        }
        FreeBranch redundant = used.extract(this);
        FreeBranch leftUsed = used.getLeftBranch(this);
        FreeBranch rightUsed = used.getRightBranch(this);
        if (leftUsed == redundant) {
            reattachment = rightUsed;
        } else if (rightUsed == redundant) {
            reattachment = leftUsed;
        } else {
            throw new IllegalArgumentException("Assertion error");
        }
        if (redundant == null) {
            throw new RuntimeException("Assertion error : I should be able to extract from one of my nodes!");
        }
        FreeNode attachmentOldRight = attachmentPoint.rightNode_;
        attachmentPoint.swapNode(attachmentOldRight, used);
        redundant.swapNode(redundant.getOther(used), attachmentOldRight);
        attachmentOldRight.swapConnection(attachmentPoint, redundant);
        store[0] = this;
        store[1] = redundant;
        store[2] = attachmentPoint;
        used.setConnectingBranches(store, 3);
        return reattachment;
    }

    public Node buildPALNodeBase() {
        Node[] children = new Node[]{this.leftNode_.buildPALNodeBase(this.branchLength_ / 2.0, this), this.rightNode_.buildPALNodeBase(this.branchLength_ / 2.0, this)};
        return NodeFactory.createNode(children);
    }

    public Node buildPALNodeES() {
        Node[] children = new Node[]{this.leftNode_.buildPALNodeES(this.branchLength_ / 2.0, this), this.rightNode_.buildPALNodeES(this.branchLength_ / 2.0, this)};
        Node n = NodeFactory.createNode(children);
        NodeUtils.lengths2Heights(n);
        return n;
    }

    public Node buildPALNodeBase(FreeNode caller) {
        if (this.leftNode_ == caller) {
            return this.rightNode_.buildPALNodeBase(this.branchLength_, this);
        }
        if (this.rightNode_ == caller) {
            return this.leftNode_.buildPALNodeBase(this.branchLength_, this);
        }
        throw new IllegalArgumentException("Unknown caller!");
    }

    public Node buildPALNodeES(FreeNode caller) {
        if (this.leftNode_ == caller) {
            return this.rightNode_.buildPALNodeES(this.branchLength_, this);
        }
        if (this.rightNode_ == caller) {
            return this.leftNode_.buildPALNodeES(this.branchLength_, this);
        }
        throw new IllegalArgumentException("Unknown caller!");
    }

    private static final int getIndex(FreeBranch c) {
        if (c == null) {
            return -1;
        }
        return c.index_;
    }

    public void setNodes(FreeNode left, FreeNode right) {
        this.leftNode_ = left;
        this.rightNode_ = right;
    }

    public void swapNode(FreeNode nodeToReplace, FreeNode replacement) {
        if (nodeToReplace == this.leftNode_) {
            this.leftNode_ = replacement;
        } else if (nodeToReplace == this.rightNode_) {
            this.rightNode_ = replacement;
        } else {
            throw new RuntimeException("Unknown node to replace");
        }
    }

    public final ConditionalProbabilityStore getLeftFlatConditionalProbabilities(GeneralConstructionTool tool) {
        return this.leftNode_.getFlatConditionalProbabilities(this, tool);
    }

    public final ConditionalProbabilityStore getRightFlatConditionalProbabilities(GeneralConstructionTool tool) {
        return this.rightNode_.getFlatConditionalProbabilities(this, tool);
    }

    public final double getBranchLength() {
        return this.branchLength_;
    }

    public final void setBranchLength(double x) {
        this.branchLength_ = x;
    }

    public String toString(FreeNode caller) {
        if (caller == this.leftNode_) {
            return this.rightNode_.toString(this);
        }
        if (caller != this.rightNode_) {
            throw new RuntimeException("Unknown caller");
        }
        return this.leftNode_.toString(this);
    }

    public void testLikelihood(GeneralConstructionTool tool) {
        this.testLikelihood(null, tool);
    }

    public void testLikelihood(FreeNode caller, GeneralConstructionTool tool) {
        System.out.println("Test Free Branch:" + this.calculateLogLikelihood(tool));
        if (caller != this.leftNode_) {
            this.leftNode_.testLikelihood(this, tool);
        }
        if (caller != this.rightNode_) {
            this.rightNode_.testLikelihood(this, tool);
        }
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(FreeNode caller, GeneralConstructionTool tool) {
        FreeNode other = this.getOther(caller);
        return other.getExtendedConditionalProbabilities(this.branchLength_, this, tool);
    }

    public ConditionalProbabilityStore getExtendedConditionalProbabilities(FreeNode caller, UnconstrainedLikelihoodModel.External externalCalculator, ConditionalProbabilityStore extendedStore, GeneralConstructionTool tool) {
        FreeNode other = this.getOther(caller);
        return other.getExtendedConditionalProbabilities(this.branchLength_, this, externalCalculator, extendedStore, tool);
    }

    public final int getNumberOfOptimisationTypes() {
        return 1;
    }

    public double optimise(int optimisationType, UnivariateMinimum minimiser, GeneralConstructionTool tool, int fracDigits) {
        ConditionalProbabilityStore leftFlat = this.getLeftFlatConditionalProbabilities(tool);
        ConditionalProbabilityStore rightFlat = this.getRightFlatConditionalProbabilities(tool);
        this.optimisationHandler_.setup(leftFlat, rightFlat, this.getCenterPatternInfo(tool), this.branchLength_, fracDigits, tool.obtainTempConditionalProbabilityStore());
        this.optimisationHandler_.optimise(minimiser);
        this.branchLength_ = this.optimisationHandler_.getBranchLength();
        return this.optimisationHandler_.getLogLikelihood();
    }

    public void getAllComponents(ArrayList store, Class componentType) {
        this.getAllComponents(store, componentType, null);
    }

    public void getAllComponents(ArrayList store, Class componentType, FreeNode caller) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
        if (caller != this.leftNode_) {
            this.leftNode_.getAllComponents(store, componentType, this);
        }
        if (caller != this.rightNode_) {
            this.rightNode_.getAllComponents(store, componentType, this);
        }
    }

    public void getCenterPatternInfo(GeneralConstructionTool tool, PatternInfo store) {
        PatternInfo left = this.leftNode_.getPatternInfo(tool, this);
        PatternInfo right = this.rightNode_.getPatternInfo(tool, this);
        tool.build(store, left, right);
    }

    public FreeNode getOther(FreeNode caller) {
        if (this.leftNode_ == caller) {
            return this.rightNode_;
        }
        if (this.rightNode_ == caller) {
            return this.leftNode_;
        }
        throw new RuntimeException("Unknown caller!");
    }

    public final void doNNI(MersenneTwisterFast r) {
        this.doNNI(r.nextBoolean(), r.nextBoolean());
    }

    public boolean doNNI(boolean leftSwapLeft, boolean rightSwapLeft) {
        FreeBranch second;
        FreeBranch first;
        FreeBranch freeBranch = first = leftSwapLeft ? this.leftNode_.getLeftBranch(this) : this.leftNode_.getRightBranch(this);
        if (first == null) {
            return false;
        }
        FreeBranch freeBranch2 = second = rightSwapLeft ? this.rightNode_.getLeftBranch(this) : this.rightNode_.getRightBranch(this);
        if (second == null) {
            return false;
        }
        this.leftNode_.swapConnection(first, this.rightNode_, second);
        return true;
    }

    public double calculateLogLikelihood(GeneralConstructionTool tool) {
        UnconstrainedLikelihoodModel.External calculator = tool.obtainFreeExternalCalculator();
        PatternInfo pi = this.getCenterPatternInfo(tool);
        ConditionalProbabilityStore leftConditionalProbabilityProbabilties = this.leftNode_.getFlatConditionalProbabilities(this, tool);
        ConditionalProbabilityStore rightConditionalProbabilityProbabilties = this.rightNode_.getExtendedConditionalProbabilities(this.branchLength_, this, tool);
        return calculator.calculateLogLikelihood(pi, leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties);
    }

    public double calculateLogLikelihood2(GeneralConstructionTool tool) {
        UnconstrainedLikelihoodModel.External calculator = tool.obtainFreeExternalCalculator();
        PatternInfo pi = this.getCenterPatternInfo(tool);
        ConditionalProbabilityStore left = this.leftNode_.getFlatConditionalProbabilities(this, tool);
        ConditionalProbabilityStore right = this.rightNode_.getFlatConditionalProbabilities(this, tool);
        return calculator.calculateLogLikelihood(this.branchLength_, pi, left, right, tool.newConditionalProbabilityStore(false));
    }

    public SiteDetails calculateSiteDetails(UnconstrainedLikelihoodModel.External calculator, GeneralConstructionTool tool) {
        PatternInfo pi = this.getCenterPatternInfo(tool);
        ConditionalProbabilityStore left = this.leftNode_.getFlatConditionalProbabilities(this, tool);
        ConditionalProbabilityStore right = this.rightNode_.getFlatConditionalProbabilities(this, tool);
        return calculator.calculateSiteDetailsUnrooted(this.branchLength_, pi, left, right, tool.newConditionalProbabilityStore(false));
    }

    private static final class OptimisationHandler
    implements UnivariateFunction {
        private ConditionalProbabilityStore leftFlatConditionals_;
        private ConditionalProbabilityStore rightFlatConditionals_;
        private ConditionalProbabilityStore tempConditionals_;
        private PatternInfo centerPattern_;
        private final UnconstrainedLikelihoodModel.External external_;
        private double branchLength_;
        private double logLikelihood_;
        private int fracDigits_;

        public OptimisationHandler(GeneralConstructionTool tool) {
            this.external_ = tool.obtainFreeExternalCalculator();
        }

        public void setup(ConditionalProbabilityStore leftFlatConditionals, ConditionalProbabilityStore rightFlatConditionals, PatternInfo centerPattern, double branchLength, int fracDigits, ConditionalProbabilityStore tempConditionals) {
            this.leftFlatConditionals_ = leftFlatConditionals;
            this.tempConditionals_ = tempConditionals;
            this.rightFlatConditionals_ = rightFlatConditionals;
            this.centerPattern_ = centerPattern;
            this.branchLength_ = branchLength;
            this.fracDigits_ = fracDigits;
        }

        public void optimise(UnivariateMinimum minimiser) {
            minimiser.findMinimum(this.branchLength_, this, this.fracDigits_);
            this.branchLength_ = minimiser.minx;
            this.logLikelihood_ = -minimiser.fminx;
        }

        public double evaluate(double argument) {
            return -this.external_.calculateLogLikelihood(argument, this.centerPattern_, this.leftFlatConditionals_, this.rightFlatConditionals_, this.tempConditionals_);
        }

        public double getLowerBound() {
            return 0.0;
        }

        public double getUpperBound() {
            return 1.0;
        }

        public double getLogLikelihood() {
            return this.logLikelihood_;
        }

        public double getBranchLength() {
            return this.branchLength_;
        }
    }
}

