/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.NeoParameterized;
import pal.misc.SampleInformation;
import pal.treesearch.ConstraintModel;

public class FixedSRDTGlobalClockModel
implements ConstraintModel,
ConstraintModel.GroupManager,
MolecularClockLikelihoodModel.HeightConverter {
    private final SampleInformation sampleInformation_;
    private final MolecularClockLikelihoodModel.Instance likelihoodModel_;
    private final double rate_;
    private final double maxLeafHeight_;

    public FixedSRDTGlobalClockModel(SampleInformation sampleInformation, MolecularClockLikelihoodModel.Instance likelihoodModel, double rate) {
        this.sampleInformation_ = sampleInformation;
        this.rate_ = rate;
        this.likelihoodModel_ = likelihoodModel;
        this.maxLeafHeight_ = sampleInformation.getMaxHeight();
        System.out.println("Fixed created:" + this.rate_);
    }

    public String getRateModelSummary() {
        return "Fixed Single Rate Dated Tips, fixed rate = " + this.getSubstitutionRate();
    }

    public ConstraintModel.GroupManager getGlobalClockConstraintGrouping(String[] leafLabelSet) {
        return this;
    }

    public String[][] getCladeConstraints(String[] allLabelSet) {
        return new String[][]{allLabelSet};
    }

    public UnconstrainedLikelihoodModel.Leaf createNewFreeLeaf(int[] patternStateMatchup, int numberOfPatterns) {
        return null;
    }

    public UnconstrainedLikelihoodModel.External createNewFreeExternal() {
        return null;
    }

    public UnconstrainedLikelihoodModel.Internal createNewFreeInternal() {
        return null;
    }

    public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
        return this.likelihoodModel_.createAppropriateConditionalProbabilityStore(isForLeaf);
    }

    public double getSubstitutionRate() {
        return this.rate_;
    }

    public NeoParameterized getGlobalParameterAccess() {
        return this.likelihoodModel_.getParameterAccess();
    }

    public double getLeafBaseHeight(String leafLabel) {
        return this.sampleInformation_.getHeight(this.sampleInformation_.getSampleOrdinal(leafLabel));
    }

    public double getBaseHeight(double originalExpectSubstitutionHeight) {
        double esMaxLeafHeight = this.maxLeafHeight_ * this.rate_;
        if (originalExpectSubstitutionHeight < esMaxLeafHeight) {
            return originalExpectSubstitutionHeight / this.rate_;
        }
        return this.maxLeafHeight_ + (originalExpectSubstitutionHeight - esMaxLeafHeight);
    }

    public int getBaseHeightUnits() {
        return this.sampleInformation_.getHeightUnits();
    }

    public void initialiseParameters(String[] leafNames, double[] leafHeights) {
    }

    public NeoParameterized getAllGroupRelatedParameterAccess() {
        return null;
    }

    public NeoParameterized getPrimaryGroupRelatedParameterAccess() {
        return null;
    }

    public NeoParameterized getSecondaryGroupRelatedParameterAccess() {
        return null;
    }

    public MolecularClockLikelihoodModel.Leaf createNewClockLeaf(PatternInfo pattern, int[] patternStateMatchup) {
        return this.likelihoodModel_.createNewLeaf(this, pattern, patternStateMatchup);
    }

    public MolecularClockLikelihoodModel.External createNewClockExternal() {
        return this.likelihoodModel_.createNewExternal(this);
    }

    public MolecularClockLikelihoodModel.Internal createNewClockInternal() {
        return this.likelihoodModel_.createNewInternal(this);
    }

    public double getExpectedSubstitutionHeight(double baseHeight) {
        if (baseHeight > this.maxLeafHeight_) {
            return this.maxLeafHeight_ * this.rate_ + (baseHeight - this.maxLeafHeight_);
        }
        return baseHeight * this.rate_;
    }

    public double getExpectedSubstitutionDistance(double lowerBaseHeight, double upperBaseHeight) {
        if (upperBaseHeight < this.maxLeafHeight_) {
            return (upperBaseHeight - lowerBaseHeight) * this.rate_;
        }
        if (lowerBaseHeight > this.maxLeafHeight_) {
            return upperBaseHeight - lowerBaseHeight;
        }
        return upperBaseHeight - this.maxLeafHeight_ + (this.maxLeafHeight_ - lowerBaseHeight) * this.rate_;
    }
}

