/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.eval.UnconstrainedLikelihoodModel;
import pal.misc.NeoParameterized;
import pal.misc.SampleInformation;
import pal.treesearch.ConstraintModel;

public class FixedBSRDTGlobalClockModel
implements ConstraintModel,
ConstraintModel.GroupManager,
NeoParameterized,
MolecularClockLikelihoodModel.HeightConverter {
    private final SampleInformation sampleInformation_;
    private final MolecularClockLikelihoodModel.Instance likelihoodModel_;
    private final double rate_;
    private double upperRate_ = 1.0;
    private static final double RATE_LOWER_LIMIT = 0.0;
    private static final double RATE_UPPER_LIMIT = 10.0;
    private static final double[] DEFAULTS = new double[]{1.0};
    private final double maxLeafHeight_;

    public FixedBSRDTGlobalClockModel(SampleInformation sampleInformation, MolecularClockLikelihoodModel.Instance likelihoodModel, double rate) {
        this.sampleInformation_ = sampleInformation;
        this.maxLeafHeight_ = sampleInformation.getMaxHeight();
        this.likelihoodModel_ = likelihoodModel;
        this.rate_ = rate;
    }

    public String getRateModelSummary() {
        return "Fixed (b) Single Rate Dated Tips, fixed rate = " + this.getSubstitutionRate();
    }

    public ConstraintModel.GroupManager getGlobalClockConstraintGrouping(String[] leafLabelSet) {
        return this;
    }

    public String[][] getCladeConstraints(String[] allLabelSet) {
        return new String[][]{allLabelSet};
    }

    public UnconstrainedLikelihoodModel.Leaf createNewFreeLeaf(int[] patternStateMatchup, int numberOfPatterns) {
        return null;
    }

    public UnconstrainedLikelihoodModel.External createNewFreeExternal() {
        return null;
    }

    public UnconstrainedLikelihoodModel.Internal createNewFreeInternal() {
        return null;
    }

    public ConditionalProbabilityStore createAppropriateConditionalProbabilityStore(boolean isForLeaf) {
        return this.likelihoodModel_.createAppropriateConditionalProbabilityStore(isForLeaf);
    }

    public double getSubstitutionRate() {
        return this.rate_;
    }

    public NeoParameterized getGlobalParameterAccess() {
        return this.likelihoodModel_.getParameterAccess();
    }

    public double getLeafBaseHeight(String leafLabel) {
        return this.sampleInformation_.getHeight(this.sampleInformation_.getSampleOrdinal(leafLabel));
    }

    public double getBaseHeight(double originalExpectSubstitutionHeight) {
        double esMaxLeafHeight = this.maxLeafHeight_ * this.rate_;
        if (originalExpectSubstitutionHeight < esMaxLeafHeight) {
            return originalExpectSubstitutionHeight / this.rate_;
        }
        return this.maxLeafHeight_ + (originalExpectSubstitutionHeight - esMaxLeafHeight) / this.upperRate_;
    }

    public int getBaseHeightUnits() {
        return this.sampleInformation_.getHeightUnits();
    }

    public void initialiseParameters(String[] leafNames, double[] leafHeights) {
    }

    public NeoParameterized getAllGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getPrimaryGroupRelatedParameterAccess() {
        return this;
    }

    public NeoParameterized getSecondaryGroupRelatedParameterAccess() {
        return null;
    }

    public MolecularClockLikelihoodModel.Leaf createNewClockLeaf(PatternInfo pattern, int[] patternStateMatchup) {
        return this.likelihoodModel_.createNewLeaf(this, pattern, patternStateMatchup);
    }

    public MolecularClockLikelihoodModel.External createNewClockExternal() {
        return this.likelihoodModel_.createNewExternal(this);
    }

    public MolecularClockLikelihoodModel.Internal createNewClockInternal() {
        return this.likelihoodModel_.createNewInternal(this);
    }

    public double getExpectedSubstitutionHeight(double baseHeight) {
        if (baseHeight > this.maxLeafHeight_) {
            return this.maxLeafHeight_ * this.rate_ + (baseHeight - this.maxLeafHeight_) * this.upperRate_;
        }
        return baseHeight * this.rate_;
    }

    public double getExpectedSubstitutionDistance(double lowerBaseHeight, double upperBaseHeight) {
        if (upperBaseHeight < this.maxLeafHeight_) {
            return (upperBaseHeight - lowerBaseHeight) * this.rate_;
        }
        if (lowerBaseHeight > this.maxLeafHeight_) {
            return (upperBaseHeight - lowerBaseHeight) * this.upperRate_;
        }
        return this.getExpectedSubstitutionHeight(upperBaseHeight) - this.getExpectedSubstitutionHeight(lowerBaseHeight);
    }

    public int getNumberOfParameters() {
        return 1;
    }

    public void setParameters(double[] parameters, int startIndex) {
        this.upperRate_ = parameters[startIndex];
    }

    public void getParameters(double[] store, int startIndex) {
        store[startIndex] = this.upperRate_;
    }

    public double getLowerLimit(int n) {
        return 0.0;
    }

    public double getUpperLimit(int n) {
        return 10.0;
    }

    public void getDefaultValues(double[] store, int startIndex) {
        System.arraycopy(DEFAULTS, 0, store, startIndex, DEFAULTS.length);
    }
}

