/*
 * Decompiled with CFR 0.152.
 */
package pal.treesearch;

import java.util.ArrayList;
import pal.eval.ConditionalProbabilityStore;
import pal.eval.MolecularClockLikelihoodModel;
import pal.eval.PatternInfo;
import pal.tree.Node;
import pal.tree.NodeFactory;
import pal.treesearch.ConstrainedNode;
import pal.treesearch.ConstraintModel;
import pal.treesearch.GeneralConstraintGroupManager;
import pal.treesearch.GeneralConstructionTool;
import pal.treesearch.HeightInformationUser;
import pal.treesearch.ParentableConstrainedNode;
import pal.treesearch.PivotNode;

public abstract class AbstractParentableConstrainedNode
implements ParentableConstrainedNode {
    private ConstrainedNode leftChild_;
    private ConstrainedNode rightChild_;
    private final PatternInfo descendentPatternInfo_;
    private boolean descendentPatternValid_;
    private final double originalPeerHeight_;
    private final double minOriginalDescendentLeafHeight_;
    private final double maxOriginalDescendentLeafHeight_;
    private double nodeHeight_;
    private final MolecularClockLikelihoodModel.Internal constrainedInternal_;
    private final GeneralConstraintGroupManager groupManager_;

    protected AbstractParentableConstrainedNode(Node peer, GeneralConstructionTool tool, GeneralConstraintGroupManager.Store store, GeneralConstraintGroupManager groupManager) {
        this.groupManager_ = groupManager;
        this.descendentPatternInfo_ = new PatternInfo(tool.getNumberOfSites(), true);
        this.descendentPatternValid_ = false;
        this.originalPeerHeight_ = peer.getNodeHeight();
        Node palLeft = peer.getChild(0);
        Node palRight = peer.getChild(1);
        ConstraintModel.GroupManager parentGroup = groupManager.getRelatedGroup();
        this.leftChild_ = tool.createConstrainedNode(palLeft, this, store, groupManager);
        this.rightChild_ = tool.createConstrainedNode(palRight, this, store, groupManager);
        this.constrainedInternal_ = parentGroup.createNewClockInternal();
        this.minOriginalDescendentLeafHeight_ = Math.min(this.leftChild_.getMinOriginalDescendentLeafHeight(), this.rightChild_.getMinOriginalDescendentLeafHeight());
        this.maxOriginalDescendentLeafHeight_ = Math.max(this.leftChild_.getMaxOriginalDescendentLeafHeight(), this.rightChild_.getMaxOriginalDescendentLeafHeight());
    }

    public MolecularClockLikelihoodModel.External obtainConstrainedExternalCalculator() {
        return this.groupManager_.obtainConstrainedExternalCalculator();
    }

    public double getMinOriginalDescendentLeafHeight() {
        return this.minOriginalDescendentLeafHeight_;
    }

    public double getMaxOriginalDescendentLeafHeight() {
        return this.maxOriginalDescendentLeafHeight_;
    }

    public double getMinimumDirectChildDistance() {
        return this.nodeHeight_ - Math.max(this.leftChild_.getNodeHeight(), this.rightChild_.getNodeHeight());
    }

    public final String toStringHeights() {
        return "(" + this.leftChild_.toStringHeights() + ", " + this.rightChild_.toStringHeights() + "):" + this.getNodeHeight();
    }

    protected final String toStringLengths() {
        return this.toStringLengths(this.nodeHeight_);
    }

    public final String toStringLengths(double parentHeight) {
        return "(" + this.leftChild_.toStringLengths(this.nodeHeight_) + ", " + this.rightChild_.toStringLengths(this.nodeHeight_) + "):" + (parentHeight - this.nodeHeight_);
    }

    public final double getNodeHeight() {
        return this.nodeHeight_;
    }

    public double getMinimumChildSeperation() {
        double currentSeparation = Math.min(this.nodeHeight_ - this.leftChild_.getNodeHeight(), this.nodeHeight_ - this.rightChild_.getNodeHeight());
        currentSeparation = this.leftChild_.getMinimumChildSeperation(currentSeparation);
        currentSeparation = this.rightChild_.getMinimumChildSeperation(currentSeparation);
        return currentSeparation;
    }

    public double getMinimumChildSeperation(double currentSeparation) {
        currentSeparation = this.leftChild_.getMinimumChildSeperation(currentSeparation);
        currentSeparation = this.rightChild_.getMinimumChildSeperation(currentSeparation);
        double mySeperation = Math.min(this.nodeHeight_ - this.leftChild_.getNodeHeight(), this.nodeHeight_ - this.rightChild_.getNodeHeight());
        return Math.min(currentSeparation, mySeperation);
    }

    protected final double getMinimumLeafChildSeperation() {
        return Math.min(this.leftChild_.getMinimumLeafChildSeperation(this.nodeHeight_), this.rightChild_.getMinimumLeafChildSeperation(this.nodeHeight_));
    }

    public final double getMinimumLeafChildSeperation(double parentHeight) {
        return this.getMinimumLeafChildSeperation();
    }

    public final void setupInternalNodeHeights(ConstraintModel.GroupManager groupConstraints) {
        this.leftChild_.setupInternalNodeHeights(groupConstraints);
        this.rightChild_.setupInternalNodeHeights(groupConstraints);
        this.nodeHeight_ = groupConstraints.getBaseHeight(this.originalPeerHeight_);
        double leftHeight = this.leftChild_.getNodeHeight();
        double rightHeight = this.rightChild_.getNodeHeight();
        if (leftHeight > this.nodeHeight_) {
            this.nodeHeight_ = leftHeight;
        }
        if (rightHeight > this.nodeHeight_) {
            this.nodeHeight_ = rightHeight;
        }
        System.out.println(this.nodeHeight_ + "   " + this.originalPeerHeight_);
    }

    public final PatternInfo getDescendentPatternInfo(GeneralConstructionTool tool) {
        if (!this.descendentPatternValid_) {
            tool.build(this.descendentPatternInfo_, this.leftChild_.getDescendentPatternInfo(tool), this.rightChild_.getDescendentPatternInfo(tool));
            this.descendentPatternValid_ = true;
        }
        return this.descendentPatternInfo_;
    }

    public final void rebuildDescendentPattern(GeneralConstructionTool tool) {
        tool.build(this.descendentPatternInfo_, this.leftChild_.getDescendentPatternInfo(tool), this.rightChild_.getDescendentPatternInfo(tool));
        this.descendentPatternValid_ = true;
    }

    protected final PatternInfo getRightChildPatternInfo(GeneralConstructionTool tool) {
        return this.rightChild_.getDescendentPatternInfo(tool);
    }

    protected final PatternInfo getLeftChildPatternInfo(GeneralConstructionTool tool) {
        return this.leftChild_.getDescendentPatternInfo(tool);
    }

    protected final void setNodeHeight(double nodeHeight) {
        this.nodeHeight_ = nodeHeight;
    }

    protected final void adjustNodeHeight(double heightDelta) {
        this.nodeHeight_ += heightDelta;
        double childMax = this.getMaxChildHeight();
        if (this.nodeHeight_ < childMax) {
            this.nodeHeight_ = childMax;
        }
    }

    public void recursivelyAdjustNodeHeight(ConstrainedNode.HeightAdjustment height) {
        this.leftChild_.recursivelyAdjustNodeHeight(height);
        this.rightChild_.recursivelyAdjustNodeHeight(height);
        double before = this.nodeHeight_;
        this.nodeHeight_ = height.getAdjustedHeight(this, this.nodeHeight_);
    }

    public final ConstrainedNode getLeftChild() {
        return this.leftChild_;
    }

    public final ConstrainedNode getRightChild() {
        return this.rightChild_;
    }

    protected final Node buildLeftDecendentPALNodeBase() {
        return this.leftChild_.buildDescendentPALNodeBase();
    }

    protected final Node buildRightDecendentPALNodeBase() {
        return this.rightChild_.buildDescendentPALNodeBase();
    }

    public final Node buildDescendentPALNodeBase() {
        Node l = this.leftChild_.buildDescendentPALNodeBase();
        Node r = this.rightChild_.buildDescendentPALNodeBase();
        return NodeFactory.createNode(new Node[]{l, r}, this.getNodeHeight());
    }

    public final Node buildDescendentPALNodeES(ConstraintModel.GroupManager groupManager) {
        Node l = this.leftChild_.buildDescendentPALNodeES(groupManager);
        Node r = this.rightChild_.buildDescendentPALNodeES(groupManager);
        return NodeFactory.createNode(new Node[]{l, r}, groupManager.getExpectedSubstitutionHeight(this.getNodeHeight()));
    }

    protected final void recursivelySetChildrenParentPivot(PivotNode parentPivot) {
        this.leftChild_.recursivelySetParentPivot(parentPivot);
        this.rightChild_.recursivelySetParentPivot(parentPivot);
    }

    protected final ConditionalProbabilityStore getLeftDescendentExtendedConditionals(GeneralConstructionTool tool, boolean allowCaching) {
        return this.leftChild_.getDescendentExtendedConditionals(this.getNodeHeight(), tool, allowCaching);
    }

    protected final ConditionalProbabilityStore getLeftDescendentExtendedConditionals(double specifiedHeight, GeneralConstructionTool tool, boolean allowCaching) {
        return this.leftChild_.getDescendentExtendedConditionals(specifiedHeight, tool, allowCaching);
    }

    protected final ConditionalProbabilityStore getRightDescendentExtendedConditionals(GeneralConstructionTool tool, boolean allowCaching) {
        return this.rightChild_.getDescendentExtendedConditionals(this.getNodeHeight(), tool, allowCaching);
    }

    protected final ConditionalProbabilityStore getRightDescendentExtendedConditionals(double specifiedHeight, GeneralConstructionTool tool, boolean allowCaching) {
        return this.rightChild_.getDescendentExtendedConditionals(specifiedHeight, tool, allowCaching);
    }

    protected final MolecularClockLikelihoodModel.Internal getConstrainedInternal() {
        return this.constrainedInternal_;
    }

    protected final double getDescendentLogLikelihood(GeneralConstructionTool tool, boolean allowCaching) {
        double height = this.getNodeHeight();
        ConditionalProbabilityStore leftConditionalProbabilityProbabilties = this.leftChild_.getDescendentExtendedConditionals(height, tool, allowCaching);
        ConditionalProbabilityStore rightConditionalProbabilityProbabilties = this.rightChild_.getDescendentExtendedConditionals(height, tool, allowCaching);
        return this.obtainConstrainedExternalCalculator().calculateLogLikelihood(height, this.getDescendentPatternInfo(tool), leftConditionalProbabilityProbabilties, rightConditionalProbabilityProbabilties);
    }

    protected final double getMaxChildHeight() {
        return Math.max(this.leftChild_.getNodeHeight(), this.rightChild_.getNodeHeight());
    }

    public ConditionalProbabilityStore getDescendentExtendedConditionals(double extensionHeight, GeneralConstructionTool tool, boolean allowCaching) {
        double height = this.getNodeHeight();
        if (extensionHeight == height) {
            return this.getDescendentFlatConditionals(tool, allowCaching);
        }
        ConditionalProbabilityStore leftConditionals = this.leftChild_.getDescendentExtendedConditionals(height, tool, allowCaching);
        ConditionalProbabilityStore rightConditionals = this.rightChild_.getDescendentExtendedConditionals(height, tool, allowCaching);
        return this.constrainedInternal_.calculateExtendedConditionals(extensionHeight, height, this.getDescendentPatternInfo(tool), leftConditionals, rightConditionals);
    }

    public ConditionalProbabilityStore getDescendentExtendedConditionalsWithAdjustedInternalHeights(double adjustedExtensionHeight, GeneralConstructionTool tool, ConstrainedNode.HeightAdjustment internalNodeHeightAdjuster, boolean allowCaching) {
        double adjustedHeight = internalNodeHeightAdjuster.getAdjustedHeight(this, this.getNodeHeight());
        ConditionalProbabilityStore leftConditionals = this.leftChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, tool, internalNodeHeightAdjuster, allowCaching);
        ConditionalProbabilityStore rightConditionals = this.rightChild_.getDescendentExtendedConditionalsWithAdjustedInternalHeights(adjustedHeight, tool, internalNodeHeightAdjuster, allowCaching);
        return this.constrainedInternal_.calculateExtendedConditionals(adjustedExtensionHeight, adjustedHeight, this.getDescendentPatternInfo(tool), leftConditionals, rightConditionals);
    }

    public ConditionalProbabilityStore getDescendentFlatConditionals(GeneralConstructionTool tool, boolean allowCaching) {
        double height = this.getNodeHeight();
        ConditionalProbabilityStore leftConditionals = this.leftChild_.getDescendentExtendedConditionals(height, tool, allowCaching);
        ConditionalProbabilityStore rightConditionals = this.rightChild_.getDescendentExtendedConditionals(height, tool, allowCaching);
        return this.constrainedInternal_.calculateFlatConditionals(this.getDescendentPatternInfo(tool), leftConditionals, rightConditionals);
    }

    public final void getSubTreeComponents(ArrayList store, Class componentType) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
        this.leftChild_.getSubTreeComponents(store, componentType);
        this.rightChild_.getSubTreeComponents(store, componentType);
    }

    public final void getAllComponents(ArrayList store, Class componentType) {
        this.getSubTreeComponents(store, componentType);
        this.getNonSubTreeComponents(store, componentType);
    }

    public void getNonSubTreeOfChildComponents(ArrayList store, Class componentType, ConstrainedNode childCaller) {
        if (componentType.isAssignableFrom(this.getClass())) {
            store.add(this);
        }
        this.getNonSubTreeComponents(store, componentType);
        if (this.leftChild_ == childCaller) {
            this.rightChild_.getSubTreeComponents(store, componentType);
        } else if (this.rightChild_ == childCaller) {
            this.leftChild_.getSubTreeComponents(store, componentType);
        } else {
            throw new RuntimeException("Assertion error : unknown child caller!");
        }
    }

    public boolean isLeftChild(ConstrainedNode node) {
        if (node == this.leftChild_) {
            return true;
        }
        if (node == this.rightChild_) {
            return false;
        }
        throw new IllegalArgumentException("Unknown child");
    }

    public void obtainLeafInformation(HeightInformationUser user) {
        this.leftChild_.obtainLeafInformation(user);
        this.rightChild_.obtainLeafInformation(user);
    }

    public abstract void getNonSubTreeComponents(ArrayList var1, Class var2);
}

