/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import pal.distance.DistanceMatrix;
import pal.misc.IdGroup;
import pal.misc.SimpleIdGroup;
import pal.tree.NeighborJoiningTree;
import pal.tree.ReadTree;
import pal.tree.Tree;
import pal.tree.TreeManipulator;
import pal.tree.TreeParseException;
import pal.tree.UPGMATree;

public final class TreeTool {
    public static final Tree readTree(Reader r) throws IOException {
        try {
            return new ReadTree(new PushbackReader(r));
        }
        catch (TreeParseException e) {
            throw new IOException("Parse exception:" + e);
        }
    }

    public static final Tree createNeighbourJoiningTree(DistanceMatrix dm) {
        return new NeighborJoiningTree(dm);
    }

    public static final Tree createUPGMA(DistanceMatrix dm) {
        return new UPGMATree(dm);
    }

    public static final Tree createNeighbourJoiningTree(double[][] dm, String[] otuNames) {
        return new NeighborJoiningTree(new DistanceMatrix(dm, (IdGroup)new SimpleIdGroup(otuNames)));
    }

    public static final Tree createUPGMATree(double[][] dm, String[] otuNames) {
        return new UPGMATree(new DistanceMatrix(dm, (IdGroup)new SimpleIdGroup(otuNames)));
    }

    public static final Tree getUnrooted(Tree t) {
        return TreeManipulator.getUnrooted(t);
    }

    public static final Tree getMidPointRooted(Tree t) {
        return TreeManipulator.getMidpointRooted(t);
    }

    public static final Tree getRooted(Tree t, String[] outgroupMembers) {
        return TreeManipulator.getRootedBy(t, outgroupMembers);
    }
}

