/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.tree.Tree;
import pal.tree.TreeUtils;

public interface TreeOperation {
    public Tree operateOn(Tree var1);

    public static final class Utils {
        public static final TreeOperation createScale(double scaleFactor, int resultingUnits) {
            return new Scale(scaleFactor, resultingUnits);
        }

        public static final TreeOperation createPipeline(TreeOperation first, TreeOperation second) {
            return new Pipeline(first, second);
        }

        public static final TreeOperation getNoOperation() {
            return NOP.INSTANCE;
        }

        private static final class Pipeline
        implements TreeOperation {
            private final TreeOperation first_;
            private final TreeOperation second_;

            public Pipeline(TreeOperation first, TreeOperation second) {
                this.first_ = first;
                this.second_ = second;
            }

            public Tree operateOn(Tree tree) {
                return this.second_.operateOn(this.first_.operateOn(tree));
            }
        }

        private static final class Scale
        implements TreeOperation {
            private final double scaleFactor_;
            private final int resultingUnits_;

            public Scale(double scaleFactor, int resultingUnits) {
                this.scaleFactor_ = scaleFactor;
                this.resultingUnits_ = resultingUnits;
            }

            public Tree operateOn(Tree tree) {
                return TreeUtils.getScaled(tree, this.scaleFactor_, this.resultingUnits_);
            }
        }

        private static final class NOP
        implements TreeOperation {
            public static final TreeOperation INSTANCE = new NOP();

            private NOP() {
            }

            public Tree operateOn(Tree tree) {
                return tree;
            }
        }
    }
}

