/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import pal.misc.IdGroup;
import pal.tree.SplitUtils;

public class SplitSystem {
    private int labelCount;
    private int splitCount;
    private IdGroup idGroup;
    private boolean[][] splits;

    public SplitSystem(IdGroup idGroup, int size) {
        this.idGroup = idGroup;
        this.labelCount = idGroup.getIdCount();
        this.splitCount = size;
        this.splits = new boolean[this.splitCount][this.labelCount];
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getLabelCount() {
        return this.labelCount;
    }

    public boolean[][] getSplitVector() {
        return this.splits;
    }

    public boolean[] getSplit(int i) {
        return this.splits[i];
    }

    public IdGroup getIdGroup() {
        return this.idGroup;
    }

    public boolean hasSplit(boolean[] split) {
        int i = 0;
        while (i < this.splitCount) {
            if (SplitUtils.isSame(split, this.splits[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        int i = 0;
        while (i < this.labelCount) {
            pw.println(this.idGroup.getIdentifier(i));
            ++i;
        }
        pw.println();
        int i2 = 0;
        while (i2 < this.splitCount) {
            int j = 0;
            while (j < this.labelCount) {
                if (this.splits[i2][j]) {
                    pw.print('*');
                } else {
                    pw.print('.');
                }
                ++j;
            }
            pw.println();
            ++i2;
        }
        return sw.toString();
    }
}

