/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import pal.math.OrthogonalHints;
import pal.misc.Identifier;
import pal.misc.Parameterized;
import pal.tree.Node;
import pal.tree.NodeUtils;
import pal.tree.SimpleTree;
import pal.tree.Tree;

public interface ParameterizedTree
extends Parameterized,
Tree {
    public OrthogonalHints getOrthogonalHints();

    public String getParameterizationInfo();

    public static abstract class ParameterizedTreeBase
    implements Parameterized,
    Tree {
        private Tree tree;

        protected ParameterizedTreeBase(ParameterizedTreeBase toCopy) {
            this.tree = toCopy.tree.getCopy();
        }

        public ParameterizedTreeBase() {
        }

        public ParameterizedTreeBase(Tree baseTree) {
            this.setBaseTree(baseTree);
        }

        protected void setBaseTree(Tree baseTree) {
            this.tree = baseTree;
            this.createNodeList();
        }

        protected Tree getBaseTree() {
            return this.tree;
        }

        public final Node getRoot() {
            return this.tree.getRoot();
        }

        public final void setRoot(Node root) {
            this.tree.setRoot(root);
        }

        public final Identifier getIdentifier(int i) {
            return this.tree.getIdentifier(i);
        }

        public final void setIdentifier(int i, Identifier id) {
            this.tree.setIdentifier(i, id);
        }

        public final int getIdCount() {
            return this.tree.getIdCount();
        }

        public final int whichIdNumber(String s) {
            return this.tree.whichIdNumber(s);
        }

        public final int getExternalNodeCount() {
            return this.tree.getExternalNodeCount();
        }

        public final int getInternalNodeCount() {
            return this.tree.getInternalNodeCount();
        }

        public final int getNodeCount() {
            return this.tree.getInternalNodeCount() + this.tree.getExternalNodeCount();
        }

        public final Node getExternalNode(int i) {
            return this.tree.getExternalNode(i);
        }

        public final Node getInternalNode(int i) {
            return this.tree.getInternalNode(i);
        }

        public final void createNodeList() {
            this.tree.createNodeList();
        }

        public final int getUnits() {
            return this.tree.getUnits();
        }

        public final void setAttribute(Node node, String name, Object value) {
            this.tree.setAttribute(node, name, value);
        }

        public final Object getAttribute(Node node, String name) {
            return this.tree.getAttribute(node, name);
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            NodeUtils.printNH(new PrintWriter(sw), this.getRoot(), true, false, 0, false);
            sw.write(";");
            return sw.toString();
        }

        public Tree getCopy() {
            return new SimpleTree(this);
        }

        public OrthogonalHints getOrthogonalHints() {
            return null;
        }
    }

    public static interface Factory {
        public ParameterizedTree generateNewTree(Tree var1);
    }
}

