/*
 * Decompiled with CFR 0.152.
 */
package pal.tree;

import pal.misc.Identifier;
import pal.tree.Node;
import pal.tree.SimpleNode;

public class NodeFactory {
    public static final Node createNode() {
        return new SimpleNode();
    }

    public static final Node createNode(Identifier id) {
        return new SimpleNode(id.getName(), 0.0);
    }

    public static final Node createNode(Identifier id, double height) {
        SimpleNode sn = new SimpleNode(id.getName(), 0.0);
        sn.setNodeHeight(height);
        return sn;
    }

    public static final Node createNodeBranchLength(double branchLength, Identifier id) {
        SimpleNode sn = new SimpleNode(id.getName(), 0.0);
        sn.setBranchLength(branchLength);
        return sn;
    }

    public static final Node createNode(Node node) {
        return new SimpleNode(node);
    }

    public static final Node createNode(Node[] children) {
        return new SimpleNode(children);
    }

    public static final Node createNode(Node[] children, double height) {
        SimpleNode sn = new SimpleNode(children);
        sn.setNodeHeight(height);
        return sn;
    }

    public static final Node createNodeBranchLength(double branchLength, Node[] children) {
        SimpleNode sn = new SimpleNode(children);
        sn.setBranchLength(branchLength);
        return sn;
    }
}

